/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog.wizard;

import java.sql.SQLException;
import org.dbgl.gui.abstractdialog.JobWizardDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Group_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.controls.Text_;
import org.dbgl.gui.thread.MigrateThread;
import org.dbgl.model.FileLocation;
import org.dbgl.model.ICanonicalize;
import org.dbgl.service.FileLocationService;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MigrateDialog
extends JobWizardDialog<String> {
    private Text from_;
    private ICanonicalize canonicalizer_;

    public MigrateDialog(Shell parent) {
        super(parent, "migratedialog");
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.migration.title");
    }

    @Override
    protected void onShellCreated() {
        Group optionsGroup = Group_.on(this.shell_).layout(new GridLayout(3, false)).key("dialog.migration.options").build();
        Chain chn = Chain.on(optionsGroup).lbl(l -> l.key("dialog.migration.from")).txt(t -> t).but(b -> b.browse(false, Button_.BrowseType.DIR, Button_.CanonicalType.NONE, false)).build();
        this.from_ = chn.getText();
        this.canonicalizer_ = (ICanonicalize)chn.getButton().getData("canonicalizer");
        Chain.on(optionsGroup).lbl(l -> l.key("dialog.migration.to")).txt(t -> ((Text_.Builder)t.horSpan(2)).nonEditable().val(FileLocationService.getInstance().getDosroot().getPath())).build();
        this.addStep(optionsGroup);
        this.addFinalStep("dialog.migration.progress", "dialog.migration.startmigration");
    }

    @Override
    protected boolean onNext(int step) {
        if (step == 0) {
            if (!this.isValid()) {
                return false;
            }
        } else if (step == 1) {
            try {
                this.job_ = new MigrateThread(this.log_, this.progressBar_, this.status_, new FileLocation(this.from_.getText(), this.canonicalizer_));
            }
            catch (SQLException e) {
                Mess_.on(this.shell_).exception(e).warning();
                return false;
            }
        } else if (step == 2) {
            if (this.job_.isEverythingOk()) {
                Mess_.on(this.shell_).key("dialog.migration.notice.migrationok").display();
            } else {
                Mess_.on(this.shell_).key("dialog.migration.error.problem").warning();
            }
            this.status_.setText(this.text_.get("dialog.migration.reviewlog"));
            this.status_.pack();
            this.result_ = this.from_.getText();
        }
        return true;
    }

    private boolean isValid() {
        Mess_.Builder mess = Mess_.on(this.shell_);
        if (this.from_.getText().equals("")) {
            mess.key("dialog.migration.required.from").bind(this.from_);
        }
        return mess.valid();
    }
}

