/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.aggregate;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.FileLocation;
import org.dbgl.model.GenericStats;
import org.dbgl.model.ICanBeDefault;
import org.dbgl.model.entity.Configurable;
import org.dbgl.service.FileLocationService;
import org.dbgl.service.ITextService;
import org.dbgl.service.TextService;

public class DosboxVersion
extends Configurable
implements ICanBeDefault,
Comparable<DosboxVersion> {
    private static final Pattern VERSION_PATRN = Pattern.compile("^(((\\d)\\.(\\d\\d))((\\-|\\.)(\\d))?)|(r(\\d\\d\\d\\d))|((\\d\\d\\d\\d)\\.(\\d\\d)\\.(\\d\\d))$");
    private String family_;
    private String version_;
    private String executableParameters_;
    private boolean default_;
    private boolean multiConfig_;
    private boolean usingCurses_;
    private Map<String, String> dynamicOptions_;
    private FileLocation path_;
    private FileLocation exe_;
    private GenericStats stats_;

    public String getFamily() {
        return this.family_;
    }

    public void setFamily(String family) {
        this.family_ = family;
    }

    public String getVersion() {
        return this.version_;
    }

    public void setVersion(String version) {
        this.version_ = version;
    }

    public int getVersionAsInt() {
        Matcher versionMatcher = VERSION_PATRN.matcher(this.version_);
        int result = 0;
        if (versionMatcher.matches()) {
            if (versionMatcher.group(3) != null) {
                result += Integer.valueOf(versionMatcher.group(3)) * 1000;
            }
            if (versionMatcher.group(4) != null) {
                result += Integer.valueOf(versionMatcher.group(4)) * 10;
            }
            if (versionMatcher.group(7) != null) {
                result += Integer.valueOf(versionMatcher.group(7)).intValue();
            }
            if (versionMatcher.group(9) != null) {
                result += Integer.valueOf(versionMatcher.group(9)).intValue();
            }
            if (versionMatcher.group(10) != null) {
                result += Integer.valueOf(versionMatcher.group(11) + versionMatcher.group(12) + versionMatcher.group(13)).intValue();
            }
        }
        return result;
    }

    public int distance(DosboxVersion other) {
        return Math.abs(other.getVersionAsInt() - this.getVersionAsInt());
    }

    @Override
    public boolean isDefault() {
        return this.default_;
    }

    public void setDefault(boolean isDefault) {
        this.default_ = isDefault;
    }

    public boolean isMultiConfig() {
        return this.multiConfig_;
    }

    public void setMultiConfig(boolean multiConfig) {
        this.multiConfig_ = multiConfig;
    }

    public boolean isUsingCurses() {
        return this.usingCurses_;
    }

    public void setUsingCurses(boolean usingCurses) {
        this.usingCurses_ = usingCurses;
    }

    public Map<String, String> getDynamicOptions() {
        return this.dynamicOptions_;
    }

    public void setDynamicOptions(Map<String, String> dynamicOptions) {
        this.dynamicOptions_ = dynamicOptions;
    }

    public File getPath() {
        return this.path_.getFile();
    }

    public File getCanonicalPath() {
        return this.path_.getCanonicalFile();
    }

    public void setPath(String path) {
        this.path_ = new FileLocation(path, FileLocationService.getInstance().dosboxRelative());
    }

    public File getExe() {
        return this.exe_.getFile();
    }

    public File getCanonicalExe() {
        return this.exe_.getCanonicalFile();
    }

    public void setExe(String exe) {
        this.exe_ = new FileLocation(exe, FileLocationService.getInstance().dosboxRelative());
    }

    public File getExecutable() {
        return StringUtils.isBlank(this.getExe().getPath()) ? new File(this.getPath(), FileLocationService.DOSBOX_EXE_STRING) : this.getExe();
    }

    public File getCanonicalExecutable() {
        return StringUtils.isBlank(this.getExe().getPath()) ? new File(this.getCanonicalPath(), FileLocationService.DOSBOX_EXE_STRING) : this.getCanonicalExe();
    }

    public String getExecutableParameters() {
        return this.executableParameters_;
    }

    public void setExecutableParameters(String executableParameters) {
        this.executableParameters_ = executableParameters;
    }

    public void setConfigurationFileLocation(String file) {
        this.configuration_.setFileLocation(new FileLocation(file, FileLocationService.getInstance().dosboxRelative()));
    }

    public String getConfigurationString() {
        return this.configuration_.toString(null);
    }

    public String resetAndLoadConfiguration() throws IOException {
        return this.configuration_.reloadWithAutoexec(TextService.getInstance(), null);
    }

    public String loadConfigurationData(ITextService text, String data, File file) throws IOException {
        return this.configuration_.loadDataWithAutoexec(text, data, file, null);
    }

    public File getCwd() {
        return FileLocationService.getInstance().getDosroot();
    }

    public GenericStats getStats() {
        return this.stats_;
    }

    public void setStats(GenericStats stats) {
        this.stats_ = stats;
    }

    @Override
    public int compareTo(DosboxVersion comp) {
        int ver2;
        int ver1 = this.getVersionAsInt();
        if (ver1 != (ver2 = comp.getVersionAsInt())) {
            return ver1 - ver2;
        }
        return this.getTitle().compareTo(comp.getTitle());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DosboxVersion)) {
            return false;
        }
        DosboxVersion that = (DosboxVersion)obj;
        return StringUtils.equals(this.version_, that.version_) && StringUtils.equals(this.getTitle(), that.getTitle());
    }

    public int hashCode() {
        return Objects.hash(this.version_, this.getTitle());
    }
}

