/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.entity;

import exodos.ZipReference;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.ArchiveFileLocation;
import org.dbgl.model.FileLocation;
import org.dbgl.model.GamePack;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.entity.Entity;
import org.dbgl.service.FileLocationService;
import org.dbgl.util.FilesUtils;

public class GamePackEntry
extends Entity
implements Comparable<GamePackEntry> {
    private GamePack gamePack_;
    private int importedId_;
    private final Profile profile_;
    private final String fullConfig_;
    private final String incrConfig_;
    private FileLocation baseDir_;
    private ArchiveFileLocation gameDir_;
    private ArchiveFileLocation capturesDir_;
    private ArchiveFileLocation mapper_;
    private List<ZipEntry> gameArchiveEntries_;
    private List<ZipEntry> captureArchiveEntries_;
    private List<ZipEntry> mapperArchiveEntries_;
    private final Collection<ZipEntry> captures_;
    private final List<ZipReference> extras_;
    private final File gameZipFile_;
    private final long size_;

    public GamePackEntry(int id, Profile profile, GamePack gamePack) {
        this.setId(id);
        this.profile_ = profile;
        this.gamePack_ = gamePack;
        this.setBaseDir(".");
        this.setGameDir(profile.getConfiguration().getAutoexec().getCanonicalGameDir().getPath());
        this.setCapturesDir("");
        File customMapper = profile.getCustomMapperFile();
        if (customMapper != null) {
            this.setMapper(customMapper.getPath());
        }
        this.fullConfig_ = null;
        this.incrConfig_ = null;
        this.captures_ = null;
        this.extras_ = null;
        this.gameZipFile_ = null;
        this.size_ = 0L;
    }

    public GamePackEntry(int id, Profile profile, GamePack gamePack, String captures, String mapper, String gameDir, String fullConfig, String incrConfig) {
        this.setId(id);
        this.profile_ = profile;
        this.gamePack_ = gamePack;
        this.setBaseDir(".");
        if (StringUtils.isNotEmpty(gameDir)) {
            this.setGameDir(gameDir);
        }
        if (StringUtils.isNotEmpty(captures)) {
            this.setCapturesDir(captures);
        }
        if (StringUtils.isNotEmpty(mapper)) {
            this.setMapper(mapper);
        }
        this.fullConfig_ = fullConfig;
        this.incrConfig_ = incrConfig;
        this.captures_ = null;
        this.extras_ = null;
        this.gameZipFile_ = null;
        this.size_ = 0L;
    }

    public GamePackEntry(int id, Profile profile, String gameDir, Collection<ZipEntry> captures, List<ZipReference> extras, File gameZipFile, long size) {
        this.setId(id);
        this.profile_ = profile;
        this.setBaseDir(".");
        if (StringUtils.isNotEmpty(gameDir)) {
            this.setGameDir(gameDir);
        }
        this.setCapturesDir("");
        this.fullConfig_ = null;
        this.incrConfig_ = null;
        this.captures_ = captures;
        this.extras_ = extras;
        this.gameZipFile_ = gameZipFile;
        this.size_ = size;
    }

    public int getImportedId() {
        return this.importedId_;
    }

    public void setImportedId(int importedId) {
        this.importedId_ = importedId;
    }

    public Profile getProfile() {
        return this.profile_;
    }

    public GamePack getGamePack() {
        return this.gamePack_;
    }

    public String getFullConfig() {
        return this.fullConfig_;
    }

    public String getIncrConfig() {
        return this.incrConfig_;
    }

    public File getBaseDir() {
        return this.baseDir_.getFile();
    }

    public File getCanonicalBaseDir() {
        return this.baseDir_.getCanonicalFile();
    }

    public void setBaseDir(String baseDir) {
        this.baseDir_ = new FileLocation(baseDir, FileLocationService.getInstance().dosrootRelative());
    }

    public File getGameDir() {
        return this.gameDir_.getFile();
    }

    public File getCanonicalGameDir() {
        return this.gameDir_.getCanonicalFile();
    }

    public String getGameDirAsDosString() {
        return this.gameDir_.getFileAsDosString();
    }

    public String getArchiveGameDirAsDosString() {
        return this.gameDir_.getArchiveFileAsDosString();
    }

    public File getArchiveGameDir() {
        return this.gameDir_.getArchiveFile();
    }

    public void setGameDir(String gameDir) {
        this.gameDir_ = new ArchiveFileLocation(gameDir, FileLocationService.getInstance().dosrootRelative(), f -> new File(FileLocationService.DOSROOT_DIR_STRING, new File(String.valueOf(this.getId()), f.getPath()).getPath()));
    }

    public File getCapturesDir() {
        return this.capturesDir_.getFile();
    }

    public File getCanonicalCapturesDir() {
        return this.capturesDir_.getCanonicalFile();
    }

    public String getArchiveCapturesAsDosString() {
        return this.capturesDir_.getArchiveFileAsDosString();
    }

    public File getArchiveCapturesDir() {
        return this.capturesDir_.getArchiveFile();
    }

    public void setCapturesDir(String capturesDir) {
        this.capturesDir_ = new ArchiveFileLocation(capturesDir, FileLocationService.getInstance().dataRelative(), f -> new File(FileLocationService.CAPTURES_DIR_STRING, String.valueOf(this.getId())));
    }

    public boolean hasMapper() {
        return this.mapper_ != null;
    }

    public File getMapper() {
        return this.mapper_.getFile();
    }

    public File getCanonicalMapper() {
        return this.mapper_.getCanonicalFile();
    }

    public String getArchiveMapperAsDosString() {
        return this.mapper_.getArchiveFileAsDosString();
    }

    public File getArchiveMapper() {
        return this.mapper_.getArchiveFile();
    }

    public File getNewMapper() {
        return new File(StringUtils.replace(this.profile_.getConfigurationCanonicalFile().getPath(), ".conf", ".map"));
    }

    public void setMapper(String mapper) {
        this.mapper_ = new ArchiveFileLocation(mapper, FileLocationService.getInstance().dosrootRelative(), f -> new File(FileLocationService.MAPPER_DIR_STRING, this.getId() + ".map"));
    }

    public Collection<ZipEntry> getCaptures() {
        return this.captures_;
    }

    public List<ZipReference> getExtras() {
        return this.extras_;
    }

    public File getGameZipFile() {
        return this.gameZipFile_;
    }

    public long getSize() {
        return this.size_;
    }

    public File getCanonicalFullDir() {
        return new File(this.baseDir_.getCanonicalFile(), this.gameDir_.getFile().getPath());
    }

    public List<ZipEntry> getGameArchiveEntries() {
        return this.gameArchiveEntries_;
    }

    public void setGameArchiveEntries(List<ZipEntry> gameArchiveEntries) {
        this.gameArchiveEntries_ = gameArchiveEntries;
    }

    public List<ZipEntry> getCaptureArchiveEntries() {
        return this.captureArchiveEntries_;
    }

    public void setCaptureArchiveEntries(List<ZipEntry> captureArchiveEntries) {
        this.captureArchiveEntries_ = captureArchiveEntries;
    }

    public List<ZipEntry> getMapperArchiveEntries() {
        return this.mapperArchiveEntries_;
    }

    public void setMapperArchiveEntries(List<ZipEntry> mapperArchiveEntries) {
        this.mapperArchiveEntries_ = mapperArchiveEntries;
    }

    public void stripGameTitleFromBaseDir() {
        String gameTitle = FilesUtils.toSafeFilename(this.getProfile().getTitle());
        if (this.getBaseDir().getName().equals(gameTitle)) {
            this.setBaseDir(this.getBaseDir().getParent());
        }
    }

    public void appendGameTitleToBaseDir() {
        String gameTitle = FilesUtils.toSafeFilename(this.getProfile().getTitle());
        if (!this.getBaseDir().getName().equals(gameTitle)) {
            this.setBaseDir(new File(this.getBaseDir(), gameTitle).getPath());
        }
    }

    public int hashCode() {
        return Objects.hash(this.profile_.getTitle());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GamePackEntry)) {
            return false;
        }
        return this.compareTo((GamePackEntry)obj) == 0;
    }

    @Override
    public int compareTo(GamePackEntry comp) {
        return FilesUtils.toSafeFilename(this.profile_.getTitle()).compareToIgnoreCase(FilesUtils.toSafeFilename(comp.profile_.getTitle()));
    }

    public int getIndexFirstEmptyLink() {
        return IntStream.range(0, this.profile_.getLinks().length).filter(x -> StringUtils.isBlank(this.profile_.getLinkDestination(x))).findFirst().orElse(-1);
    }
}

