/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.entity;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.controls.CommaSeparatedDaControlConvertor;
import org.dbgl.gui.controls.SeparatedValuesDaControlConvertor;
import org.dbgl.gui.controls.SpaceSeparatedDaControlConvertor;
import org.dbgl.gui.interfaces.DaControlConvertor;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.entity.Configurable;
import org.dbgl.service.FileLocationService;
import org.dbgl.service.SettingsService;

public class GenerationAwareConfigurable
extends Configurable {
    private static final Pattern CYCLES_PATRN = Pattern.compile("^((auto)(\\s+(fixed\\s+)?\\d+\\%?)?(\\s+(fixed\\s+)?\\d+\\%?)?|(max)(\\s+(fixed\\s+)?\\d+\\%?)?|((fixed\\s+)?(\\d+)))(\\s+limit\\s+(\\d+))?$", 2);
    private static final Pattern CPU_CYCLES_PATRN = Pattern.compile("^((max)(\\s+limit\\s+(\\d+))?|((fixed\\s+)?(\\d+)))$", 2);
    private static final Pattern CPU_CYCLES_PROTECTED_PATRN = Pattern.compile("^((auto)|(max)(\\s+limit\\s+(\\d+))?|((fixed\\s+)?(\\d+)))$", 2);
    public static Generation[][] GENS = new Generation[][]{{Generation.official_063, Generation.official_065, Generation.official_070, Generation.official_073}, {Generation.svn_r4483}, {Generation.ece_r4482}, {Generation.staging_0810, Generation.staging_0820}, {Generation.x_20240301, Generation.x_20241001}};
    protected DosboxVersion dosboxVersion_;
    protected Generation gen_;

    public DosboxVersion getDosboxVersion() {
        return this.dosboxVersion_;
    }

    public void setDosboxVersion(DosboxVersion dosboxVersion) {
        this.dosboxVersion_ = dosboxVersion;
        if (this.dosboxVersion_ != null) {
            this.gen_ = this.determineGen();
        }
    }

    private Generation determineGen() {
        return GenerationAwareConfigurable.determineGen(this.dosboxVersion_);
    }

    public static Generation determineGen(DosboxVersion dosboxVersion) {
        String fam = dosboxVersion.getFamily();
        String ver = dosboxVersion.getVersion();
        if (StringUtils.equalsIgnoreCase(fam, "Official")) {
            if (StringUtils.equals(ver, "0.63")) {
                return Generation.official_063;
            }
            if (StringUtils.equals(ver, "0.65")) {
                return Generation.official_065;
            }
            if (StringUtils.equalsAny(ver, "0.70", "0.71", "0.72")) {
                return Generation.official_070;
            }
            if (StringUtils.equalsAny(ver, "0.73", "0.74", "0.74-2", "0.74-3")) {
                return Generation.official_073;
            }
        } else {
            if (StringUtils.equalsIgnoreCase(fam, "DOSBox SVN")) {
                return Generation.svn_r4483;
            }
            if (StringUtils.equalsIgnoreCase(fam, "DOSBox ECE")) {
                return Generation.ece_r4482;
            }
            if (StringUtils.equalsIgnoreCase(fam, "DOSBox Staging")) {
                if (StringUtils.equalsAny(ver, "0.81.0", "0.81.1", "0.81.2")) {
                    return Generation.staging_0810;
                }
                if (ver.equals("0.82.0")) {
                    return Generation.staging_0820;
                }
            } else if (StringUtils.equalsIgnoreCase(fam, "DOSBox-X")) {
                if (StringUtils.equalsAny(ver, "2024.03.01", "2024.07.01")) {
                    return Generation.x_20240301;
                }
                if (StringUtils.equalsAny("2024.10.01", "2024.12.04")) {
                    return Generation.x_20241001;
                }
            }
        }
        System.err.println("DOSBox generation could not be determined, assume official_073");
        return Generation.official_073;
    }

    public static int familyIdx(Generation g) {
        for (int i = 0; i < GENS.length; ++i) {
            for (int j = 0; j < GENS[i].length; ++j) {
                if (GENS[i][j] != g) continue;
                return i;
            }
        }
        return -1;
    }

    public static int revisionIdx(Generation g) {
        for (int i = 0; i < GENS.length; ++i) {
            for (int j = 0; j < GENS[i].length; ++j) {
                if (GENS[i][j] != g) continue;
                return j;
            }
        }
        return -1;
    }

    public Generation determineGenByConf() {
        if (this.isDosboxVersion073OrAbove()) {
            return Generation.official_073;
        }
        if (this.isDosboxVersion070or071or072()) {
            return Generation.official_070;
        }
        if (this.isDosboxVersion065()) {
            return Generation.official_065;
        }
        if (this.isDosboxVersion063()) {
            return Generation.official_063;
        }
        return null;
    }

    public boolean isDosboxVersion073OrAbove() {
        return this.configuration_.hasValue("cpu", "cputype") && this.configuration_.hasValue("midi", "mididevice") && this.configuration_.hasValue("midi", "midiconfig") && this.configuration_.hasValue("sblaster", "sbmixer") && this.configuration_.hasValue("sblaster", "oplemu") && this.configuration_.hasValue("gus", "gusirq") && this.configuration_.hasValue("gus", "gusdma");
    }

    public boolean isDosboxVersion070or071or072() {
        return this.configuration_.hasValue("joystick", "joysticktype") && this.configuration_.hasValue("joystick", "timed") && this.configuration_.hasValue("joystick", "autofire") && this.configuration_.hasValue("joystick", "swap34") && this.configuration_.hasValue("joystick", "buttonwrap") && this.configuration_.hasValue("dos", "keyboardlayout");
    }

    public boolean isDosboxVersion065() {
        return this.configuration_.hasValue("sdl", "windowresolution") && this.configuration_.hasValue("sdl", "usescancodes") && this.configuration_.hasValue("sblaster", "sbtype") && this.configuration_.hasValue("sblaster", "sbbase") && this.configuration_.hasValue("gus", "gusrate") && this.configuration_.hasValue("gus", "gusbase") && this.configuration_.hasValue("speaker", "tandy") && this.configuration_.hasValue("bios", "joysticktype") && this.configuration_.hasValue("serial", "serial1") && this.configuration_.hasValue("dos", "umb");
    }

    public boolean isDosboxVersion063() {
        return this.configuration_.hasValue("sdl", "fullfixed") && this.configuration_.hasValue("sdl", "hwscale") && this.configuration_.hasValue("midi", "intelligent") && this.configuration_.hasValue("sblaster", "type") && this.configuration_.hasValue("sblaster", "base") && this.configuration_.hasValue("gus", "rate") && this.configuration_.hasValue("gus", "base") && this.configuration_.hasValue("modem", "modem") && this.configuration_.hasValue("modem", "comport") && this.configuration_.hasValue("modem", "listenport") && this.configuration_.hasValue("directserial", "directserial");
    }

    public boolean capturesDirRelativeToDosboxDir() {
        return switch (this.gen_.ordinal()) {
            case 0, 1, 2 -> true;
            default -> false;
        };
    }

    public String capturesConfSection() {
        return switch (this.gen_.ordinal()) {
            case 6, 7 -> "capture";
            default -> "dosbox";
        };
    }

    public String capturesConfSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 6, 7 -> "capture_dir";
            default -> "captures";
        };
    }

    public DaControlConvertor getPriorityConvertor() {
        return switch (this.gen_.ordinal()) {
            case 6, 7 -> SpaceSeparatedDaControlConvertor.getInstance();
            default -> CommaSeparatedDaControlConvertor.getInstance();
        };
    }

    public String priorityActiveSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 6, 7 -> "priority_active_staging0810";
            default -> "priority_active";
        };
    }

    public String priorityInactiveSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 6, 7 -> "priority_inactive_staging0810";
            default -> "priority_inactive";
        };
    }

    public String outputSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 6 -> "output_staging0810";
            case 7 -> "output_staging0820";
            case 8, 9 -> "output_x20240301";
            default -> "output";
        };
    }

    public String windowresSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 6, 7 -> "windowresolution_staging0810";
            default -> "windowresolution";
        };
    }

    public String scalerSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 8, 9 -> "scaler_x20240301";
            default -> "scaler";
        };
    }

    public String aspectSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 6, 7 -> "aspect_staging0810";
            case 8, 9 -> "aspect_x20240301";
            default -> "aspect";
        };
    }

    public String[] glshaderValues() {
        String[] glShaderFiles = FileLocationService.getInstance().listGlShaderFilenames();
        String[] glShaders = ArrayUtils.addAll(SettingsService.getInstance().getValues("profile", this.glshaderSectionItem()), glShaderFiles);
        return glShaders;
    }

    public String glshaderSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 4 -> "glshader_svn4483";
            case 5 -> "glshader_ecer4482";
            case 6, 7 -> "glshader_staging0810";
            case 8, 9 -> "glshader_x20240301";
            default -> null;
        };
    }

    public String vsyncmodeSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 6, 7 -> "vsyncmode_staging0810";
            case 8, 9 -> "vsyncmode_x20240301";
            default -> null;
        };
    }

    public String dosverSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 6, 7 -> "dosversion_staging0810";
            case 8, 9 -> "dosversion_x20240301";
            default -> null;
        };
    }

    public String machineSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 0, 1, 2 -> "machine";
            case 6, 7 -> "machine_staging0810";
            case 8, 9 -> "machine_x20240301";
            default -> "machine073";
        };
    }

    public String coreSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 8, 9 -> "core_x20240301";
            default -> "core";
        };
    }

    public String cputypeSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 7 -> "cputype_staging0820";
            case 8, 9 -> "cputype_x20240301";
            default -> "cputype";
        };
    }

    public String emsSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 8, 9 -> "ems_x20240301";
            default -> "ems";
        };
    }

    public String monochromepalSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 6, 7 -> "monochromepalette_staging0810";
            case 8, 9 -> "monochromepalette_x20240301";
            default -> null;
        };
    }

    public String voodooSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 5 -> "voodoo_ecer4482";
            case 8, 9 -> "voodoo_x20240301";
            default -> null;
        };
    }

    public String lfbglideSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 5 -> "lfbglide_ecer4482";
            case 8, 9 -> "lfbglide_x20240301";
            default -> null;
        };
    }

    public String midideviceSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 5 -> "mididevice_ecer4482";
            case 6, 7 -> "mididevice_staging0810";
            case 8, 9 -> "mididevice_x20240301";
            default -> "mididevice";
        };
    }

    public String fluidsynthdriverSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 5 -> "fluidsynthdriver_ecer4482";
            case 8, 9 -> "fluidsynthdriver_x20240301";
            default -> null;
        };
    }

    public String mt32modelSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 6, 7 -> "mt32model_staging0810";
            case 8, 9 -> "mt32model_x20240301";
            default -> null;
        };
    }

    public String sbtypeSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 7 -> "sbtype_staging0820";
            case 8, 9 -> "sbtype_x20240301";
            default -> "sbtype";
        };
    }

    public String sbbaseSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 8, 9 -> "sbbase_x20240301";
            default -> "sbbase";
        };
    }

    public String sbirqSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 8, 9 -> "sbirq_x20240301";
            default -> "irq";
        };
    }

    public String oplmodeSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 4 -> "oplmode_svn4483";
            case 5 -> "oplmode_ecer4482";
            case 6 -> "oplmode_staging0810";
            case 7 -> "oplmode_staging0820";
            case 8 -> "oplmode_x20240301";
            case 9 -> "oplmode_x20241001";
            default -> "oplmode";
        };
    }

    public String sbdmaSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 8, 9 -> "sbdma_x20240301";
            default -> "dma";
        };
    }

    public String oplemuSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 4 -> "oplemu_svn4483";
            case 5 -> "oplemu_ecer4482";
            case 8, 9 -> "oplemu_x20240301";
            default -> "oplemu";
        };
    }

    public String sbhdmaSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 8, 9 -> "sbhdma_x20240301";
            default -> "hdma";
        };
    }

    public String sbcmsSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 7 -> "sbcms_staging0820";
            case 9 -> "sbcms_x20241001";
            default -> null;
        };
    }

    public String gusbaseSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 7 -> "gusbase_staging0820";
            default -> "gusbase";
        };
    }

    public String gusirq1SectionItem() {
        return switch (this.gen_.ordinal()) {
            case 7 -> "irq1_staging0820";
            default -> "irq1";
        };
    }

    public String gusdma1SectionItem() {
        return switch (this.gen_.ordinal()) {
            case 7 -> "dma1_staging0820";
            default -> "dma1";
        };
    }

    public String pcspeakerSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 6, 7 -> "pcspeaker_staging0810";
            default -> "pcspeaker";
        };
    }

    public String pcrateSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 8, 9 -> "pcrate_x20240301";
            default -> "pcrate";
        };
    }

    public String tandySectionItem() {
        return switch (this.gen_.ordinal()) {
            case 6, 7 -> "tandy_staging0810";
            default -> "tandy";
        };
    }

    public String ps1SectionItem() {
        return switch (this.gen_.ordinal()) {
            case 6, 7 -> "ps1_staging0810";
            case 8, 9 -> "ps1_x20240301";
            default -> null;
        };
    }

    public String innovaportSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 6, 7 -> "innovaport_staging0810";
            case 8, 9 -> "innovaport_x20240301";
            default -> null;
        };
    }

    public String scancodesSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 8, 9 -> "usescancodes_x20240301";
            default -> "usescancodes";
        };
    }

    public String joysticktypeSectionItem() {
        return switch (this.gen_.ordinal()) {
            case 6, 7 -> "joysticktype_staging0810";
            default -> "joysticktype";
        };
    }

    public void downgradeOneOfficialGeneration(Generation generation) {
        switch (generation.ordinal()) {
            case 3: {
                this.configuration_.removeValueIfNone("dosbox", "machine", "cga", "hercules", "pcjr", "tandy");
                this.configuration_.switchSetting("midi", "mididevice", "midi", "device");
                this.configuration_.switchSetting("midi", "midiconfig", "midi", "config");
                this.configuration_.switchSetting("sblaster", "sbmixer", "sblaster", "mixer");
                this.configuration_.switchSetting("gus", "gusirq", "gus", "irq1");
                if (this.configuration_.hasValue("gus", "irq1")) {
                    this.configuration_.setValue("gus", "irq2", this.configuration_.getValue("gus", "irq1"));
                }
                this.configuration_.switchSetting("gus", "gusdma", "gus", "dma1");
                if (this.configuration_.hasValue("gus", "dma1")) {
                    this.configuration_.setValue("gus", "dma2", this.configuration_.getValue("gus", "dma1"));
                }
                this.configuration_.removeValueIfAny("dos", "keyboardlayout", "auto");
                break;
            }
            case 2: {
                this.configuration_.switchSetting("joystick", "joysticktype", "bios", "joysticktype");
                break;
            }
            case 1: {
                if (this.configuration_.hasValue("midi", "mpu401")) {
                    String mpu = this.configuration_.getValue("midi", "mpu401");
                    this.configuration_.setValue("midi", "mpu401", !mpu.equalsIgnoreCase("none"));
                    this.configuration_.setValue("midi", "intelligent", mpu.equalsIgnoreCase("intelligent"));
                }
                this.configuration_.switchSetting("sblaster", "sbtype", "sblaster", "type");
                this.configuration_.switchSetting("sblaster", "sbbase", "sblaster", "base");
                this.configuration_.switchSetting("gus", "gusrate", "gus", "rate");
                this.configuration_.switchSetting("gus", "gusbase", "gus", "base");
                break;
            }
            default: {
                throw new RuntimeException("Cannot downgrade below generation Gen_063");
            }
        }
    }

    public void upgradeOneOfficialGeneration(Generation generation) {
        switch (generation.ordinal()) {
            case 0: {
                boolean intelli;
                boolean mpu = !this.configuration_.hasValue("midi", "mpu401") || this.configuration_.getBooleanValue("midi", "mpu401");
                boolean bl = intelli = !this.configuration_.hasValue("midi", "intelligent") || this.configuration_.getBooleanValue("midi", "intelligent");
                this.configuration_.setValue("midi", "mpu401", mpu ? (intelli ? "intelligent" : "uart") : "none");
                this.configuration_.removeValueIfSet("midi", "intelligent");
                this.configuration_.switchSetting("sblaster", "type", "sblaster", "sbtype");
                this.configuration_.switchSetting("sblaster", "base", "sblaster", "sbbase");
                this.configuration_.switchSetting("gus", "rate", "gus", "gusrate");
                this.configuration_.switchSetting("gus", "base", "gus", "gusbase");
                break;
            }
            case 1: {
                this.configuration_.switchSetting("bios", "joysticktype", "joystick", "joysticktype");
                break;
            }
            case 2: {
                this.configuration_.removeValueIfAny("dosbox", "machine", "vga");
                this.configuration_.switchSetting("midi", "device", "midi", "mididevice");
                this.configuration_.switchSetting("midi", "config", "midi", "midiconfig");
                this.configuration_.switchSetting("sblaster", "mixer", "sblaster", "sbmixer");
                this.configuration_.switchSetting("gus", "irq1", "gus", "gusirq");
                this.configuration_.removeValueIfSet("gus", "irq2");
                this.configuration_.switchSetting("gus", "dma1", "gus", "gusdma");
                this.configuration_.removeValueIfSet("gus", "dma2");
                this.configuration_.removeValueIfAny("dos", "keyboardlayout", "none");
                break;
            }
            default: {
                throw new RuntimeException("Cannot upgrade above generation Gen_073");
            }
        }
    }

    public void downgradeOneStagingGeneration(Generation generation) {
        switch (generation.ordinal()) {
            case 7: {
                GenerationAwareConfigurable.cputypeToOfficial(this.configuration_);
                GenerationAwareConfigurable.cyclesToOfficial(this.configuration_);
                this.configuration_.removeValueIfAny("sblaster", "sbtype", "ess");
                this.configuration_.removeValueIfAny("sblaster", "oplmode", "esfm");
                if (this.configuration_.hasValue("sblaster", "cms") && this.configuration_.getValue("sblaster", "cms").equals("on")) {
                    this.configuration_.setValue("sblaster", "oplmode", "cms");
                }
                this.configuration_.removeValueIfAny("gus", "gusbase", "210", "230", "250");
                this.configuration_.removeValueIfAny("gus", "gusirq", "2", "15");
                break;
            }
            default: {
                throw new RuntimeException("Cannot downgrade below generation staging_0810");
            }
        }
    }

    public void upgradeOneStagingGeneration(Generation generation) {
        switch (generation.ordinal()) {
            case 6: {
                this.configuration_.removeValueIfAny("sdl", "output", "openglnb");
                GenerationAwareConfigurable.cputypeToStaging(this.configuration_);
                GenerationAwareConfigurable.cyclesToStaging(this.configuration_);
                if (this.configuration_.hasValue("sblaster", "oplmode") && this.configuration_.getValue("sblaster", "oplmode").equals("cms")) {
                    this.configuration_.removeValue("sblaster", "oplmode");
                    this.configuration_.setValue("sblaster", "sbtype", "sb1");
                }
                this.configuration_.removeValueIfAny("gus", "gusbase", "280", "2a0", "2c0", "2e0", "300");
                this.configuration_.removeValueIfAny("gus", "gusirq", "9", "10");
                this.configuration_.removeValueIfAny("gus", "gusdma", "0");
                break;
            }
            default: {
                throw new RuntimeException("Cannot upgrade above generation staging_0820");
            }
        }
    }

    private static void priorityToStaging(Configuration configuration) {
        if (configuration.hasValue("sdl", "priority")) {
            String[] vSource;
            boolean pauseWhenInactive;
            String s = configuration.getValue("sdl", "priority");
            SeparatedValuesDaControlConvertor conv = SeparatedValuesDaControlConvertor.detect(s);
            if (conv == null) {
                System.err.println("Invalid [sdl] priority value detected (" + s + ")");
                return;
            }
            if (conv instanceof SpaceSeparatedDaControlConvertor) {
                System.out.println("[sdl] priority value (" + s + ") is already space-separated");
            }
            if (pauseWhenInactive = StringUtils.equalsIgnoreCase((vSource = conv.toControlValues(s))[1], "pause")) {
                vSource[1] = "auto";
            }
            configuration.setValue("sdl", "pause_when_inactive", pauseWhenInactive);
            configuration.setValue("sdl", "priority", SpaceSeparatedDaControlConvertor.getInstance().toConfValue(null, vSource));
        }
    }

    private static void priorityToOfficial(Configuration configuration) {
        if (configuration.hasValue("sdl", "priority")) {
            boolean pauseWhenInactive;
            String[] vSource;
            String s = configuration.getValue("sdl", "priority");
            SeparatedValuesDaControlConvertor conv = SeparatedValuesDaControlConvertor.detect(s);
            if (conv == null) {
                System.err.println("Invalid [sdl] priority value detected (" + s + ")");
                return;
            }
            if (conv instanceof CommaSeparatedDaControlConvertor) {
                System.out.println("[sdl] priority value (" + s + ") is already comma-separated");
            }
            if ((vSource = conv.toControlValues(s))[0].equalsIgnoreCase("auto")) {
                vSource[0] = "higher";
            }
            if (vSource[1].equalsIgnoreCase("auto")) {
                vSource[1] = "normal";
            }
            if (pauseWhenInactive = configuration.getBooleanValue("sdl", "pause_when_inactive")) {
                vSource[1] = "pause";
            }
            configuration.removeValueIfSet("sdl", "pause_when_inactive");
            configuration.setValue("sdl", "priority", CommaSeparatedDaControlConvertor.getInstance().toConfValue(null, vSource));
        }
    }

    private static void cputypeToStaging(Configuration configuration) {
        if (configuration.hasValue("cpu", "cputype")) {
            String cpuType;
            String newCpuType = switch (cpuType = configuration.getValue("cpu", "cputype")) {
                case "386_slow" -> "386";
                case "386" -> "386_fast";
                case "486_slow" -> "486";
                case "pentium_slow" -> "pentium";
                default -> cpuType;
            };
            configuration.setValue("cpu", "cputype", newCpuType);
        }
    }

    private static void cputypeToOfficial(Configuration configuration) {
        if (configuration.hasValue("cpu", "cputype")) {
            String cpuType;
            String newCpuType = switch (cpuType = configuration.getValue("cpu", "cputype")) {
                case "386" -> "386_slow";
                case "386_fast" -> "386";
                case "486" -> "486_slow";
                case "pentium" -> "pentium_slow";
                default -> cpuType;
            };
            configuration.setValue("cpu", "cputype", newCpuType);
        }
    }

    private static void cyclesToStaging(Configuration configuration) {
        if (configuration.hasValue("cpu", "cycles")) {
            String cycles = configuration.getValue("cpu", "cycles");
            Matcher cyclesMatcher = CYCLES_PATRN.matcher(cycles);
            if (cyclesMatcher.matches()) {
                String auto = cyclesMatcher.group(2);
                String max = cyclesMatcher.group(7);
                String fixed = cyclesMatcher.group(12);
                String limit = cyclesMatcher.group(14);
                Object cc = "";
                Object ccp = "";
                if (auto != null) {
                    String real = cyclesMatcher.group(3);
                    if (real != null) {
                        cc = real;
                        String prot = cyclesMatcher.group(5);
                        ccp = prot != null ? prot : "max";
                    } else {
                        cc = "3000";
                        ccp = "max";
                    }
                    if (limit != null) {
                        ccp = (String)ccp + " limit " + limit;
                    }
                } else if (max != null) {
                    cc = "max";
                    String prot = cyclesMatcher.group(8);
                    Object object = ccp = prot != null ? prot : "max";
                    if (limit != null) {
                        cc = (String)cc + " limit " + limit;
                        ccp = (String)ccp + " limit " + limit;
                    }
                } else if (fixed != null) {
                    cc = fixed;
                    ccp = fixed;
                }
                if (StringUtils.equals((CharSequence)cc, (CharSequence)ccp)) {
                    ccp = "auto";
                }
                configuration.setValue("cpu", "cpu_cycles", (String)cc);
                configuration.setValue("cpu", "cpu_cycles_protected", (String)ccp);
            } else {
                configuration.setValue("cpu", "cpu_cycles", cycles);
                configuration.setValue("cpu", "cpu_cycles_protected", "auto");
            }
            configuration.removeValue("cpu", "cycles");
        }
    }

    private static void cyclesToOfficial(Configuration configuration) {
        if (configuration.hasValue("cpu", "cpu_cycles") && configuration.hasValue("cpu", "cpu_cycles_protected")) {
            String cc = configuration.getValue("cpu", "cpu_cycles");
            String ccp = configuration.getValue("cpu", "cpu_cycles_protected");
            Matcher cpuCyclesMatcher = CPU_CYCLES_PATRN.matcher(cc);
            Matcher cpuCyclesProtectedMatcher = CPU_CYCLES_PROTECTED_PATRN.matcher(ccp);
            Object cycles = "";
            if (cpuCyclesMatcher.matches() && cpuCyclesProtectedMatcher.matches()) {
                String ccMax = cpuCyclesMatcher.group(2);
                String ccLimit = cpuCyclesMatcher.group(4);
                String ccFixed = cpuCyclesMatcher.group(7);
                String ccpAuto = cpuCyclesProtectedMatcher.group(2);
                String ccpMax = cpuCyclesProtectedMatcher.group(3);
                String ccpLimit = cpuCyclesProtectedMatcher.group(5);
                String ccpFixed = cpuCyclesProtectedMatcher.group(8);
                if (ccpAuto != null) {
                    if (ccFixed != null) {
                        cycles = ccFixed;
                    } else {
                        cycles = ccMax;
                        if (ccLimit != null) {
                            cycles = (String)cycles + " limit " + ccLimit;
                        }
                    }
                } else {
                    cycles = "auto";
                    cycles = ccFixed != null ? (String)cycles + " " + ccFixed : (String)cycles + " " + ccMax;
                    if (ccpFixed != null) {
                        cycles = (String)cycles + " " + ccpFixed;
                    } else {
                        if (StringUtils.equals((CharSequence)(cycles = (String)cycles + " " + ccpMax), "auto 3000 max")) {
                            cycles = "auto";
                        }
                        if (ccpLimit != null) {
                            cycles = (String)cycles + " limit " + ccpLimit;
                        }
                    }
                }
            } else {
                cycles = cc;
            }
            if (StringUtils.isBlank((CharSequence)cycles)) {
                cycles = "auto";
            }
            configuration.setValue("cpu", "cycles", (String)cycles);
            configuration.removeValue("cpu", "cpu_cycles");
            configuration.removeValue("cpu", "cpu_cycles_protected");
        }
    }

    public void downgradeOneXGeneration(Generation generation) {
        switch (generation.ordinal()) {
            case 9: {
                if (!this.configuration_.hasValue("sblaster", "cms") || !this.configuration_.getValue("sblaster", "cms").equals("on")) break;
                this.configuration_.setValue("sblaster", "oplmode", "cms");
                break;
            }
            default: {
                throw new RuntimeException("Cannot downgrade below generation x_20240301");
            }
        }
    }

    public void upgradeOneXGeneration(Generation generation) {
        switch (generation.ordinal()) {
            case 8: {
                if (!this.configuration_.hasValue("sblaster", "oplmode") || !this.configuration_.getValue("sblaster", "oplmode").equals("cms")) break;
                this.configuration_.removeValue("sblaster", "oplmode");
                this.configuration_.setValue("sblaster", "sbtype", "sb1");
                break;
            }
            default: {
                throw new RuntimeException("Cannot upgrade above generation x_20241001");
            }
        }
    }

    public void switchFamily(Generation src, Generation dst) {
        block0 : switch (src.ordinal()) {
            case 3: {
                switch (dst.ordinal()) {
                    case 3: {
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                    case 5: {
                        break block0;
                    }
                    case 7: {
                        this.configuration_.switchSetting("dosbox", "captures", "capture", "capture_dir");
                        GenerationAwareConfigurable.priorityToStaging(this.configuration_);
                        this.configuration_.removeValueIfAny("sdl", "output", "ddraw", "overlay", "surface", "openglnb");
                        this.configuration_.removeValueIfAny("sdl", "windowresolution", "original", "desktop");
                        this.configuration_.setValueIfAnyOr("sdl", "aspect", "on", "off", "true");
                        GenerationAwareConfigurable.cputypeToStaging(this.configuration_);
                        GenerationAwareConfigurable.cyclesToStaging(this.configuration_);
                        this.configuration_.removeValueIfAny("dosbox", "machine", "vgaonly");
                        this.configuration_.removeValueIfAny("midi", "mididevice", "default", "alsa", "oss", "coreaudio", "coremidi");
                        if (this.configuration_.hasValue("sblaster", "oplmode") && this.configuration_.getValue("sblaster", "oplmode").equals("cms")) {
                            this.configuration_.removeValue("sblaster", "oplmode");
                            this.configuration_.setValue("sblaster", "sbtype", "sb1");
                        }
                        this.configuration_.removeValueIfAny("gus", "gusbase", "280", "2a0", "2c0", "2e0", "300");
                        this.configuration_.removeValueIfAny("gus", "gusirq", "9", "10");
                        this.configuration_.removeValueIfAny("gus", "gusdma", "0");
                        this.configuration_.setValueIfAnyOr("speaker", "pcspeaker", "impulse", "off", "true");
                        this.configuration_.switchSetting("sdl", "sensitivity", "mouse", "mouse_sensitivity");
                        this.configuration_.setValueIfAny("joystick", "joysticktype", "disabled", "none");
                        break block0;
                    }
                    case 9: {
                        this.configuration_.setValueIfAny("cpu", "cputype", "386_prefetch", "386_slow");
                        this.configuration_.setValueIfAny("cpu", "cputype", "486_prefetch", "486_slow");
                        this.configuration_.setValueIfAny("cpu", "cputype", "pentium", "pentium_slow");
                        this.configuration_.removeValueIfAny("sblaster", "sbbase", "300");
                        if (!this.configuration_.hasValue("sblaster", "oplmode") || !this.configuration_.getValue("sblaster", "oplmode").equals("cms")) break block0;
                        this.configuration_.removeValue("sblaster", "oplmode");
                        this.configuration_.setValue("sblaster", "sbtype", "sb1");
                        break block0;
                    }
                    default: {
                        throw new RuntimeException("Cannot switch from 073 to unknown generation");
                    }
                }
            }
            case 4: {
                switch (dst.ordinal()) {
                    case 4: {
                        break block0;
                    }
                    case 3: {
                        this.configuration_.removeValueIfAny("sblaster", "oplmode", "opl3gold");
                        this.configuration_.removeValueIfAny("sblaster", "oplemu", "mame");
                        break block0;
                    }
                    case 5: {
                        break block0;
                    }
                    case 7: {
                        this.configuration_.switchSetting("dosbox", "captures", "capture", "capture_dir");
                        GenerationAwareConfigurable.priorityToStaging(this.configuration_);
                        this.configuration_.removeValueIfAny("sdl", "output", "ddraw", "overlay", "surface", "openglnb");
                        this.configuration_.removeValueIfAny("sdl", "windowresolution", "original", "desktop");
                        this.configuration_.setValueIfAnyOr("sdl", "aspect", "on", "off", "true");
                        this.configuration_.removeValueIfAny("render", "glshader", "advinterp2x", "advinterp3x", "advmame2x", "advmame3x", "rgb2x", "rgb3x", "scan2x", "scan3x", "tv2x", "tv3x");
                        this.configuration_.removeValueIfAny("dosbox", "machine", "vgaonly");
                        GenerationAwareConfigurable.cputypeToStaging(this.configuration_);
                        GenerationAwareConfigurable.cyclesToStaging(this.configuration_);
                        this.configuration_.removeValueIfAny("midi", "mididevice", "default", "alsa", "oss", "coreaudio", "coremidi");
                        if (this.configuration_.hasValue("sblaster", "oplmode") && this.configuration_.getValue("sblaster", "oplmode").equals("cms")) {
                            this.configuration_.removeValue("sblaster", "oplmode");
                            this.configuration_.setValue("sblaster", "sbtype", "sb1");
                        }
                        this.configuration_.removeValueIfAny("sblaster", "oplemu", "mame");
                        this.configuration_.removeValueIfAny("gus", "gusbase", "280", "2a0", "2c0", "2e0", "300");
                        this.configuration_.removeValueIfAny("gus", "gusirq", "9", "10");
                        this.configuration_.removeValueIfAny("gus", "gusdma", "0");
                        this.configuration_.setValueIfAnyOr("speaker", "pcspeaker", "impulse", "off", "true");
                        this.configuration_.switchSetting("sdl", "sensitivity", "mouse", "mouse_sensitivity");
                        this.configuration_.setValueIfAny("joystick", "joysticktype", "disabled", "none");
                        break block0;
                    }
                    case 9: {
                        this.configuration_.setValueIfAny("cpu", "cputype", "386_prefetch", "386_slow");
                        this.configuration_.setValueIfAny("cpu", "cputype", "486_prefetch", "486_slow");
                        this.configuration_.setValueIfAny("cpu", "cputype", "pentium", "pentium_slow");
                        this.configuration_.removeValueIfAny("sblaster", "sbbase", "300");
                        if (!this.configuration_.hasValue("sblaster", "oplmode") || !this.configuration_.getValue("sblaster", "oplmode").equals("cms")) break block0;
                        this.configuration_.removeValue("sblaster", "oplmode");
                        this.configuration_.setValue("sblaster", "sbtype", "sb1");
                        break block0;
                    }
                    default: {
                        throw new RuntimeException("Cannot switch from SVN to unknown generation");
                    }
                }
            }
            case 5: {
                switch (dst.ordinal()) {
                    case 5: {
                        break block0;
                    }
                    case 3: {
                        this.configuration_.removeValueIfAny("midi", "mididevice", "fluidsynth", "mt32");
                        this.configuration_.removeValueIfAny("sblaster", "oplmode", "opl3gold");
                        this.configuration_.removeValueIfAny("sblaster", "oplemu", "mame", "nuked");
                        break block0;
                    }
                    case 4: {
                        this.configuration_.removeValueIfAny("midi", "mididevice", "fluidsynth", "mt32");
                        this.configuration_.removeValueIfAny("sblaster", "oplemu", "nuked");
                        break block0;
                    }
                    case 7: {
                        this.configuration_.switchSetting("dosbox", "captures", "capture", "capture_dir");
                        GenerationAwareConfigurable.priorityToStaging(this.configuration_);
                        this.configuration_.removeValueIfAny("sdl", "output", "ddraw", "overlay", "surface", "openglnb");
                        this.configuration_.removeValueIfAny("sdl", "windowresolution", "original", "desktop");
                        this.configuration_.setValueIfAnyOr("sdl", "aspect", "on", "off", "true");
                        this.configuration_.removeValueIfAny("render", "glshader", "advinterp2x", "advinterp3x", "advmame2x", "advmame3x", "rgb2x", "rgb3x", "scan2x", "scan3x", "tv2x", "tv3x");
                        this.configuration_.removeValueIfAny("dosbox", "machine", "vgaonly");
                        GenerationAwareConfigurable.cputypeToStaging(this.configuration_);
                        GenerationAwareConfigurable.cyclesToStaging(this.configuration_);
                        this.configuration_.removeValueIfAny("midi", "mididevice", "default", "alsa", "oss", "coreaudio", "coremidi");
                        this.configuration_.switchSetting("midi", "fluid.soundfont", "fluidsynth", "soundfont");
                        this.configuration_.switchSetting("midi", "mt32.romdir", "mt32", "romdir");
                        if (this.configuration_.hasValue("sblaster", "oplmode") && this.configuration_.getValue("sblaster", "oplmode").equals("cms")) {
                            this.configuration_.removeValue("sblaster", "oplmode");
                            this.configuration_.setValue("sblaster", "sbtype", "sb1");
                        }
                        this.configuration_.removeValueIfAny("sblaster", "oplemu", "mame", "nuked");
                        this.configuration_.removeValueIfAny("gus", "gusbase", "280", "2a0", "2c0", "2e0", "300");
                        this.configuration_.removeValueIfAny("gus", "gusirq", "9", "10");
                        this.configuration_.removeValueIfAny("gus", "gusdma", "0");
                        this.configuration_.setValueIfAnyOr("speaker", "pcspeaker", "impulse", "off", "true");
                        this.configuration_.switchSetting("sdl", "sensitivity", "mouse", "mouse_sensitivity");
                        this.configuration_.setValueIfAny("joystick", "joysticktype", "disabled", "none");
                        break block0;
                    }
                    case 9: {
                        this.configuration_.setValueIfAny("cpu", "cputype", "386_prefetch", "386_slow");
                        this.configuration_.setValueIfAny("cpu", "cputype", "486_prefetch", "486_slow");
                        this.configuration_.setValueIfAny("cpu", "cputype", "pentium", "pentium_slow");
                        this.configuration_.switchSetting("pci", "voodoo", "voodoo", "voodoo_card");
                        this.configuration_.switchSetting("glide", "glide", "voodoo", "glide");
                        this.configuration_.switchSetting("glide", "lfb", "voodoo", "lfb");
                        this.configuration_.switchSetting("glide", "splash", "voodoo", "splash");
                        this.configuration_.removeValueIfAny("sblaster", "sbbase", "300");
                        if (!this.configuration_.hasValue("sblaster", "oplmode") || !this.configuration_.getValue("sblaster", "oplmode").equals("cms")) break block0;
                        this.configuration_.removeValue("sblaster", "oplmode");
                        this.configuration_.setValue("sblaster", "sbtype", "sb1");
                        break block0;
                    }
                    default: {
                        throw new RuntimeException("Cannot switch from ECE to unknown generation");
                    }
                }
            }
            case 7: {
                switch (dst.ordinal()) {
                    case 7: {
                        break block0;
                    }
                    case 3: {
                        this.configuration_.switchSetting("capture", "capture_dir", "dosbox", "captures");
                        GenerationAwareConfigurable.priorityToOfficial(this.configuration_);
                        this.configuration_.removeValueIfAny("sdl", "output", "texture", "texturenb");
                        this.configuration_.removeValueIfAny("sdl", "windowresolution", "default", "small", "s", "medium", "m", "large", "l");
                        this.configuration_.setValueIfAnyOr("render", "aspect", "true", "false", "auto", "on", "stretch");
                        GenerationAwareConfigurable.cputypeToOfficial(this.configuration_);
                        GenerationAwareConfigurable.cyclesToOfficial(this.configuration_);
                        this.configuration_.setValueIfAny("dosbox", "machine", "cga", "cga_mono");
                        this.configuration_.removeValueIfAny("midi", "mididevice", "auto", "fluidsynth", "mt32");
                        this.configuration_.removeValueIfAny("sblaster", "sbtype", "ess");
                        this.configuration_.removeValueIfAny("sblaster", "oplmode", "opl3gold", "esfm");
                        if (this.configuration_.hasValue("sblaster", "cms") && this.configuration_.getValue("sblaster", "cms").equals("on")) {
                            this.configuration_.setValue("sblaster", "oplmode", "cms");
                        }
                        this.configuration_.removeValueIfAny("gus", "gusbase", "210", "230", "250");
                        this.configuration_.removeValueIfAny("gus", "gusirq", "2", "15");
                        this.configuration_.setValueIfAnyOr("speaker", "pcspeaker", "true", "false", "discrete", "impulse");
                        this.configuration_.removeValueIfAny("speaker", "tandy", "psg");
                        this.configuration_.switchSetting("mouse", "mouse_sensitivity", "sdl", "sensitivity");
                        this.configuration_.setValueIfAny("joystick", "joysticktype", "none", "hidden", "disabled");
                        break block0;
                    }
                    case 4: {
                        this.configuration_.switchSetting("capture", "capture_dir", "dosbox", "captures");
                        GenerationAwareConfigurable.priorityToOfficial(this.configuration_);
                        this.configuration_.removeValueIfAny("sdl", "output", "texture", "texturenb");
                        this.configuration_.removeValueIfAny("sdl", "windowresolution", "default", "small", "s", "medium", "m", "large", "l");
                        this.configuration_.setValueIfAnyOr("render", "aspect", "true", "false", "auto", "on", "stretch");
                        this.configuration_.removeValueIfAny("render", "glshader", "crt-auto", "crt-auto-machine", "crt-auto-arcade", "crt-auto-arcade-sharp");
                        GenerationAwareConfigurable.cputypeToOfficial(this.configuration_);
                        GenerationAwareConfigurable.cyclesToOfficial(this.configuration_);
                        this.configuration_.setValueIfAny("dosbox", "machine", "cga", "cga_mono");
                        this.configuration_.removeValueIfAny("midi", "mididevice", "auto", "fluidsynth", "mt32");
                        this.configuration_.removeValueIfAny("sblaster", "sbtype", "ess");
                        this.configuration_.removeValueIfAny("sblaster", "oplmode", "esfm");
                        if (this.configuration_.hasValue("sblaster", "cms") && this.configuration_.getValue("sblaster", "cms").equals("on")) {
                            this.configuration_.setValue("sblaster", "oplmode", "cms");
                        }
                        this.configuration_.removeValueIfAny("gus", "gusbase", "210", "230", "250");
                        this.configuration_.removeValueIfAny("gus", "gusirq", "2", "15");
                        this.configuration_.setValueIfAnyOr("speaker", "pcspeaker", "true", "false", "discrete", "impulse");
                        this.configuration_.removeValueIfAny("speaker", "tandy", "psg");
                        this.configuration_.switchSetting("mouse", "mouse_sensitivity", "sdl", "sensitivity");
                        this.configuration_.setValueIfAny("joystick", "joysticktype", "none", "hidden", "disabled");
                        break block0;
                    }
                    case 5: {
                        this.configuration_.switchSetting("capture", "capture_dir", "dosbox", "captures");
                        GenerationAwareConfigurable.priorityToOfficial(this.configuration_);
                        this.configuration_.removeValueIfAny("sdl", "output", "texture", "texturenb");
                        this.configuration_.removeValueIfAny("sdl", "windowresolution", "default", "small", "s", "medium", "m", "large", "l");
                        this.configuration_.setValueIfAnyOr("render", "aspect", "true", "false", "auto", "on", "stretch");
                        this.configuration_.removeValueIfAny("render", "glshader", "crt-auto", "crt-auto-machine", "crt-auto-arcade", "crt-auto-arcade-sharp");
                        GenerationAwareConfigurable.cputypeToOfficial(this.configuration_);
                        GenerationAwareConfigurable.cyclesToOfficial(this.configuration_);
                        this.configuration_.setValueIfAny("dosbox", "machine", "cga", "cga_mono");
                        this.configuration_.removeValueIfAny("midi", "mididevice", "auto");
                        this.configuration_.switchSetting("fluidsynth", "soundfont", "midi", "fluid.soundfont");
                        this.configuration_.switchSetting("mt32", "romdir", "midi", "mt32.romdir");
                        this.configuration_.removeValueIfAny("sblaster", "sbtype", "ess");
                        this.configuration_.removeValueIfAny("sblaster", "oplmode", "esfm");
                        if (this.configuration_.hasValue("sblaster", "cms") && this.configuration_.getValue("sblaster", "cms").equals("on")) {
                            this.configuration_.setValue("sblaster", "oplmode", "cms");
                        }
                        this.configuration_.removeValueIfAny("gus", "gusbase", "210", "230", "250");
                        this.configuration_.removeValueIfAny("gus", "gusirq", "2", "15");
                        this.configuration_.setValueIfAnyOr("speaker", "pcspeaker", "true", "false", "discrete", "impulse");
                        this.configuration_.removeValueIfAny("speaker", "tandy", "psg");
                        this.configuration_.switchSetting("mouse", "mouse_sensitivity", "sdl", "sensitivity");
                        this.configuration_.setValueIfAny("joystick", "joysticktype", "none", "hidden", "disabled");
                        break block0;
                    }
                    case 9: {
                        this.configuration_.switchSetting("capture", "capture_dir", "dosbox", "captures");
                        GenerationAwareConfigurable.priorityToOfficial(this.configuration_);
                        this.configuration_.switchSetting("dosbox", "shell_config_shortcuts", "dos", "shell configuration as commands");
                        this.configuration_.switchSetting("dosbox", "automount", "dos", "automount");
                        this.configuration_.removeValueIfAny("sdl", "output", "texture", "texturenb");
                        this.configuration_.removeValueIfAny("sdl", "windowresolution", "default", "small", "s", "medium", "m", "large", "l");
                        this.configuration_.setValueIfAnyOr("render", "aspect", "true", "false", "auto", "on", "stretch");
                        this.configuration_.removeValueIfAny("render", "glshader", "crt-auto", "crt-auto-machine", "crt-auto-arcade", "crt-auto-arcade-sharp");
                        this.configuration_.setValueIfAnyOr("sdl", "vsync", "on", "off", "on", "auto");
                        this.configuration_.switchSetting("sdl", "vsync", "vsync", "vsyncmode");
                        this.configuration_.setValueIfAny("render", "monochrome_palette", "gray", "paperwhite");
                        this.configuration_.switchSetting("render", "monochrome_palette", "render", "monochrome_pal");
                        this.configuration_.setValueIfAny("cpu", "cputype", "386", "386_fast");
                        GenerationAwareConfigurable.cyclesToOfficial(this.configuration_);
                        this.configuration_.removeValueIfAny("midi", "mididevice", "auto");
                        this.configuration_.switchSetting("fluidsynth", "soundfont", "midi", "fluid.soundfont");
                        this.configuration_.setValueIfAny("mt32", "model", "cm32l", "cm32l_102", "cm32l_100", "cm32ln_100");
                        this.configuration_.setValueIfAny("mt32", "model", "mt32", "mt32_old", "mt32_107", "mt32_106", "mt32_105", "mt32_104", "mt32_bluer", "mt32_new", "mt32_207", "mt32_206", "mt32_204", "mt32_203");
                        this.configuration_.switchSetting("mt32", "model", "midi", "mt32.model");
                        this.configuration_.switchSetting("mt32", "romdir", "midi", "mt32.romdir");
                        this.configuration_.setValueIfAny("sblaster", "sbtype", "ess1688", "ess");
                        this.configuration_.removeValueIfAny("sblaster", "sbbase", "300");
                        this.configuration_.removeValueIfAny("gus", "gusbase", "210", "230", "250");
                        this.configuration_.removeValueIfAny("gus", "gusirq", "2", "15");
                        this.configuration_.setValueIfAnyOr("speaker", "pcspeaker", "true", "false", "discrete", "impulse");
                        this.configuration_.removeValueIfAny("speaker", "tandy", "psg");
                        this.configuration_.setValueIfAnyOr("speaker", "ps1audio", "on", "off", "true");
                        this.configuration_.switchSetting("innovation", "sidport", "innova", "sidbase");
                        this.configuration_.switchSetting("mouse", "mouse_sensitivity", "sdl", "sensitivity");
                        this.configuration_.setValueIfAny("joystick", "joysticktype", "none", "hidden", "disabled");
                        this.configuration_.switchSetting("ethernet", "ne2000", "ne2000", "ne2000");
                        this.configuration_.switchSetting("ethernet", "nicbase", "ne2000", "nicbase");
                        this.configuration_.switchSetting("ethernet", "nicirq", "ne2000", "nicirq");
                        this.configuration_.switchSetting("ethernet", "macaddr", "ne2000", "macaddr");
                        break block0;
                    }
                }
                throw new RuntimeException("Cannot switch from Staging to unknown generation");
            }
            case 9: {
                switch (dst.ordinal()) {
                    case 9: {
                        break block0;
                    }
                    case 3: {
                        this.configuration_.removeValueIfAny("sdl", "output", "ttf", "openglhq", "openglpp", "direct3d");
                        this.configuration_.setValueIfAny("render", "scaler", "normal3x", "normal4x", "normal5x");
                        this.configuration_.removeValueIfAny("render", "scaler", "gray", "gray2x", "hardware_none", "hardware2x", "hardware3x", "hardware4x", "hardware5x", "xbrz", "xbrz_bilinear");
                        this.configuration_.setValueIfAnyOr("render", "aspect", "true", "false", "true", "1", "yes", "nearest", "bilinear");
                        this.configuration_.setValueIfAny("dosbox", "machine", "hercules", "mda", "hercules_plus", "hercules_incolor", "hercules_color");
                        this.configuration_.setValueIfAny("dosbox", "machine", "cga", "cga_mono", "cga_rgb", "cga_composite", "cga_composite2");
                        this.configuration_.setValueIfAny("dosbox", "machine", "pcjr", "pcjr_composite", "pcjr_composite2");
                        this.configuration_.setValueIfAny("dosbox", "machine", "vesa_oldvbe", "vesa_oldvbe10");
                        this.configuration_.removeValueIfAny("dosbox", "machine", "amstrad", "jega", "mcga", "svga_s386c928", "svga_s3vision864", "svga_s3vision868", "svga_s3vision964", "svga_s3vision968", "svga_s3trio32", "svga_s3trio64", "svga_s3trio64v+", "svga_s3virge", "svga_s3virgevx", "pc98", "pc9801", "pc9821", "svga_ati_egavgawonder", "svga_ati_vgawonder", "svga_ati_vgawonderplus", "svga_ati_vgawonderxl", "svga_ati_vgawonderxl24", "svga_ati_mach8", "svga_ati_mach32", "svga_ati_mach64", "fm_towns");
                        this.configuration_.setValueIfAny("cpu", "core", "dynamic", "dynamic_x86", "dynamic_nodhfpu", "dynamic_rec");
                        this.configuration_.setValueIfAny("cpu", "cputype", "486_slow", "486old", "486old_prefetch", "486", "486_prefetch");
                        this.configuration_.removeValueIfAny("cpu", "cputype", "8086", "8086_prefetch", "80186", "80186_prefetch", "286", "286_prefetch", "pentium pentium_mmx", "ppro_slow", "pentium_ii", "pentium_iii", "experimental");
                        this.configuration_.setValueIfAny("dos", "ems", "true", "1");
                        this.configuration_.setValueIfAny("dos", "ems", "false", "0");
                        this.configuration_.removeValueIfAny("midi", "mididevice", "mt32", "fluidsynth", "synth", "timidity");
                        this.configuration_.removeValueIfAny("sblaster", "sbtype", "sb16vibra", "ess688", "ess1688", "reveal_sc400");
                        this.configuration_.removeValueIfAny("sblaster", "sbbase", "d2", "d4", "d6", "d8", "da", "dc", "de");
                        this.configuration_.removeValueIfAny("sblaster", "irq", "-1", "0");
                        this.configuration_.setValueIfAny("sblaster", "oplmode", "opl3", "opl3gold");
                        this.configuration_.removeValueIfAny("sblaster", "oplmode", "hardware", "hardwaregb", "esfm");
                        if (this.configuration_.hasValue("sblaster", "cms") && this.configuration_.getValue("sblaster", "cms").equals("on")) {
                            this.configuration_.setValue("sblaster", "oplmode", "cms");
                        }
                        this.configuration_.removeValueIfAny("sblaster", "dma", "-1", "0");
                        this.configuration_.removeValueIfAny("sblaster", "oplemu", "mame", "nuked", "opl2board", "opl3duoboard", "retrowave_opl3", "esfmu");
                        this.configuration_.removeValueIfAny("sblaster", "hdma", "-1", "0");
                        this.configuration_.setValueIfAny("speaker", "pcrate", "49716", "65536");
                        this.configuration_.setValueIfAnyOr("sdl", "usescancodes", "true", "false", "true", "1", "auto");
                        break block0;
                    }
                    case 4: {
                        this.configuration_.removeValueIfAny("sdl", "output", "ttf", "openglhq", "openglpp", "direct3d");
                        this.configuration_.setValueIfAny("render", "scaler", "normal3x", "normal4x", "normal5x");
                        this.configuration_.removeValueIfAny("render", "scaler", "gray", "gray2x", "hardware_none", "hardware2x", "hardware3x", "hardware4x", "hardware5x", "xbrz", "xbrz_bilinear");
                        this.configuration_.setValueIfAnyOr("render", "aspect", "true", "false", "true", "1", "yes", "nearest", "bilinear");
                        this.configuration_.removeValueIfAny("render", "glshader", "default");
                        this.configuration_.setValueIfAny("dosbox", "machine", "hercules", "mda", "hercules_plus", "hercules_incolor", "hercules_color");
                        this.configuration_.setValueIfAny("dosbox", "machine", "cga", "cga_mono", "cga_rgb", "cga_composite", "cga_composite2");
                        this.configuration_.setValueIfAny("dosbox", "machine", "pcjr", "pcjr_composite", "pcjr_composite2");
                        this.configuration_.setValueIfAny("dosbox", "machine", "vesa_oldvbe", "vesa_oldvbe10");
                        this.configuration_.removeValueIfAny("dosbox", "machine", "amstrad", "jega", "mcga", "svga_s386c928", "svga_s3vision864", "svga_s3vision868", "svga_s3vision964", "svga_s3vision968", "svga_s3trio32", "svga_s3trio64", "svga_s3trio64v+", "svga_s3virge", "svga_s3virgevx", "pc98", "pc9801", "pc9821", "svga_ati_egavgawonder", "svga_ati_vgawonder", "svga_ati_vgawonderplus", "svga_ati_vgawonderxl", "svga_ati_vgawonderxl24", "svga_ati_mach8", "svga_ati_mach32", "svga_ati_mach64", "fm_towns");
                        this.configuration_.setValueIfAny("cpu", "core", "dynamic", "dynamic_x86", "dynamic_nodhfpu", "dynamic_rec");
                        this.configuration_.setValueIfAny("cpu", "cputype", "486_slow", "486old", "486old_prefetch", "486", "486_prefetch");
                        this.configuration_.removeValueIfAny("cpu", "cputype", "8086", "8086_prefetch", "80186", "80186_prefetch", "286", "286_prefetch", "pentium pentium_mmx", "ppro_slow", "pentium_ii", "pentium_iii", "experimental");
                        this.configuration_.setValueIfAny("dos", "ems", "true", "1");
                        this.configuration_.setValueIfAny("dos", "ems", "false", "0");
                        this.configuration_.removeValueIfAny("midi", "mididevice", "mt32", "fluidsynth", "synth", "timidity");
                        this.configuration_.removeValueIfAny("sblaster", "sbtype", "sb16vibra", "ess688", "ess1688", "reveal_sc400");
                        this.configuration_.removeValueIfAny("sblaster", "sbbase", "d2", "d4", "d6", "d8", "da", "dc", "de");
                        this.configuration_.removeValueIfAny("sblaster", "irq", "-1", "0");
                        this.configuration_.removeValueIfAny("sblaster", "oplmode", "hardware", "hardwaregb", "esfm");
                        if (this.configuration_.hasValue("sblaster", "cms") && this.configuration_.getValue("sblaster", "cms").equals("on")) {
                            this.configuration_.setValue("sblaster", "oplmode", "cms");
                        }
                        this.configuration_.removeValueIfAny("sblaster", "dma", "-1", "0");
                        this.configuration_.removeValueIfAny("sblaster", "oplemu", "nuked", "opl2board", "opl3duoboard", "retrowave_opl3", "esfmu");
                        this.configuration_.removeValueIfAny("sblaster", "hdma", "-1", "0");
                        this.configuration_.setValueIfAny("speaker", "pcrate", "49716", "65536");
                        this.configuration_.setValueIfAnyOr("sdl", "usescancodes", "true", "false", "true", "1", "auto");
                        break block0;
                    }
                    case 5: {
                        this.configuration_.removeValueIfAny("sdl", "output", "ttf", "openglhq", "openglpp", "direct3d");
                        this.configuration_.setValueIfAny("render", "scaler", "normal3x", "normal4x", "normal5x");
                        this.configuration_.removeValueIfAny("render", "scaler", "gray", "gray2x", "hardware_none", "hardware2x", "hardware3x", "hardware4x", "hardware5x", "xbrz", "xbrz_bilinear");
                        this.configuration_.setValueIfAnyOr("render", "aspect", "true", "false", "true", "1", "yes", "nearest", "bilinear");
                        this.configuration_.removeValueIfAny("render", "glshader", "default");
                        this.configuration_.setValueIfAny("dosbox", "machine", "hercules", "mda", "hercules_plus", "hercules_incolor", "hercules_color");
                        this.configuration_.setValueIfAny("dosbox", "machine", "cga", "cga_mono", "cga_rgb", "cga_composite", "cga_composite2");
                        this.configuration_.setValueIfAny("dosbox", "machine", "pcjr", "pcjr_composite", "pcjr_composite2");
                        this.configuration_.setValueIfAny("dosbox", "machine", "vesa_oldvbe", "vesa_oldvbe10");
                        this.configuration_.removeValueIfAny("dosbox", "machine", "amstrad", "jega", "mcga", "svga_s386c928", "svga_s3vision864", "svga_s3vision868", "svga_s3vision964", "svga_s3vision968", "svga_s3trio32", "svga_s3trio64", "svga_s3trio64v+", "svga_s3virge", "svga_s3virgevx", "pc98", "pc9801", "pc9821", "svga_ati_egavgawonder", "svga_ati_vgawonder", "svga_ati_vgawonderplus", "svga_ati_vgawonderxl", "svga_ati_vgawonderxl24", "svga_ati_mach8", "svga_ati_mach32", "svga_ati_mach64", "fm_towns");
                        this.configuration_.setValueIfAny("cpu", "core", "dynamic", "dynamic_x86", "dynamic_nodhfpu", "dynamic_rec");
                        this.configuration_.setValueIfAny("cpu", "cputype", "486_slow", "486old", "486old_prefetch", "486", "486_prefetch");
                        this.configuration_.removeValueIfAny("cpu", "cputype", "8086", "8086_prefetch", "80186", "80186_prefetch", "286", "286_prefetch", "pentium pentium_mmx", "ppro_slow", "pentium_ii", "pentium_iii", "experimental");
                        this.configuration_.setValueIfAny("dos", "ems", "true", "1");
                        this.configuration_.setValueIfAny("dos", "ems", "false", "0");
                        this.configuration_.switchSetting("voodoo", "voodoo_card", "pci", "voodoo");
                        this.configuration_.switchSetting("voodoo", "glide", "glide", "glide");
                        this.configuration_.switchSetting("voodoo", "lfb", "glide", "lfb");
                        this.configuration_.switchSetting("voodoo", "splash", "glide", "splash");
                        this.configuration_.removeValueIfAny("midi", "mididevice", "synth", "timidity");
                        this.configuration_.removeValueIfAny("sblaster", "sbtype", "sb16vibra", "ess688", "ess1688", "reveal_sc400");
                        this.configuration_.removeValueIfAny("sblaster", "sbbase", "d2", "d4", "d6", "d8", "da", "dc", "de");
                        this.configuration_.removeValueIfAny("sblaster", "irq", "-1", "0");
                        this.configuration_.removeValueIfAny("sblaster", "oplmode", "hardware", "hardwaregb", "esfm");
                        if (this.configuration_.hasValue("sblaster", "cms") && this.configuration_.getValue("sblaster", "cms").equals("on")) {
                            this.configuration_.setValue("sblaster", "oplmode", "cms");
                        }
                        this.configuration_.removeValueIfAny("sblaster", "dma", "-1", "0");
                        this.configuration_.removeValueIfAny("sblaster", "oplemu", "opl2board", "opl3duoboard", "retrowave_opl3", "esfmu");
                        this.configuration_.removeValueIfAny("sblaster", "hdma", "-1", "0");
                        this.configuration_.setValueIfAny("speaker", "pcrate", "49716", "65536");
                        this.configuration_.setValueIfAnyOr("sdl", "usescancodes", "true", "false", "true", "1", "auto");
                        break block0;
                    }
                    case 7: {
                        this.configuration_.switchSetting("dosbox", "captures", "capture", "capture_dir");
                        GenerationAwareConfigurable.priorityToStaging(this.configuration_);
                        this.configuration_.switchSetting("dos", "shell configuration as commands", "dosbox", "shell_config_shortcuts");
                        this.configuration_.switchSetting("dos", "automount", "dosbox", "automount");
                        this.configuration_.removeValueIfAny("sdl", "output", "default", "surface", "overlay", "ttf", "openglhq", "openglnb", "openglpp", "ddraw", "direct3d");
                        this.configuration_.removeValueIfAny("sdl", "windowresolution", "original", "desktop");
                        this.configuration_.setValueIfAny("render", "scaler", "normal3x", "normal4x", "normal5x");
                        this.configuration_.removeValueIfAny("render", "scaler", "gray", "gray2x", "hardware_none", "hardware2x", "hardware3x", "hardware4x", "hardware5x", "xbrz", "xbrz_bilinear");
                        this.configuration_.setValueIfAnyOr("render", "aspect", "on", "off", "true", "1", "yes", "nearest", "bilinear");
                        this.configuration_.switchSetting("vsync", "vsyncmode", "sdl", "vsync");
                        this.configuration_.switchSetting("render", "monochrome_pal", "render", "monochrome_palette");
                        this.configuration_.removeValueIfAny("render", "glshader", "default", "advinterp2x", "advinterp3x", "advmame2x", "advmame3x", "rgb2x", "rgb3x", "scan2x", "scan3x", "tv2x", "tv3x");
                        this.configuration_.setValueIfAnyOr("sdl", "vsync", "on", "off", "on", "force", "host");
                        this.configuration_.setValueIfAny("dos", "ver", "7.1", "7.0");
                        this.configuration_.removeValueIfAny("dos", "ver", "auto");
                        this.configuration_.setValueIfAny("dosbox", "machine", "hercules", "mda", "hercules_plus", "hercules_incolor", "hercules_color");
                        this.configuration_.setValueIfAny("dosbox", "machine", "cga", "cga_rgb", "cga_composite", "cga_composite2");
                        this.configuration_.setValueIfAny("dosbox", "machine", "pcjr", "pcjr_composite", "pcjr_composite2");
                        this.configuration_.setValueIfAny("dosbox", "machine", "vesa_oldvbe", "vesa_oldvbe10");
                        this.configuration_.removeValueIfAny("dosbox", "machine", "vgaonly", "amstrad", "jega", "mcga", "svga_s386c928", "svga_s3vision864", "svga_s3vision868", "svga_s3vision964", "svga_s3vision968", "svga_s3trio32", "svga_s3trio64", "svga_s3trio64v+", "svga_s3virge", "svga_s3virgevx", "pc98", "pc9801", "pc9821", "svga_ati_egavgawonder", "svga_ati_vgawonder", "svga_ati_vgawonderplus", "svga_ati_vgawonderxl", "svga_ati_vgawonderxl24", "svga_ati_mach8", "svga_ati_mach32", "svga_ati_mach64", "fm_towns");
                        this.configuration_.setValueIfAny("cpu", "core", "dynamic", "dynamic_x86", "dynamic_nodhfpu", "dynamic_rec");
                        this.configuration_.setValueIfAny("cpu", "cputype", "486", "486old", "486old_prefetch", "486_prefetch");
                        this.configuration_.removeValueIfAny("cpu", "cputype", "8086", "8086_prefetch", "80186", "80186_prefetch", "286", "286_prefetch", "ppro_slow", "pentium_ii", "pentium_iii", "experimental");
                        GenerationAwareConfigurable.cyclesToStaging(this.configuration_);
                        this.configuration_.setValueIfAny("dos", "ems", "true", "1");
                        this.configuration_.setValueIfAny("dos", "ems", "false", "0");
                        this.configuration_.setValueIfAny("render", "monochrome_pal", "paperwhite", "gray");
                        this.configuration_.removeValueIfAny("midi", "mididevice", "alsa", "default", "coreaudio", "coremidi", "oss", "synth", "timidity");
                        this.configuration_.switchSetting("midi", "fluid.soundfont", "fluidsynth", "soundfont");
                        this.configuration_.switchSetting("midi", "mt32.model", "mt32", "model");
                        this.configuration_.switchSetting("midi", "mt32.romdir", "mt32", "romdir");
                        this.configuration_.setValueIfAny("sblaster", "sbtype", "ess", "ess688", "ess1688");
                        this.configuration_.removeValueIfAny("sblaster", "sbtype", "sb16vibra", "reveal_sc400");
                        this.configuration_.removeValueIfAny("sblaster", "sbbase", "d2", "d4", "d6", "d8", "da", "dc", "de");
                        this.configuration_.removeValueIfAny("sblaster", "irq", "-1", "0");
                        this.configuration_.removeValueIfAny("sblaster", "oplmode", "hardware", "hardwaregb");
                        this.configuration_.removeValueIfAny("sblaster", "dma", "-1", "0");
                        this.configuration_.removeValueIfAny("sblaster", "oplemu", "mame", "nuked", "opl2board", "opl3duoboard", "retrowave_opl3", "esfmu");
                        this.configuration_.removeValueIfAny("sblaster", "hdma", "-1", "0");
                        this.configuration_.removeValueIfAny("gus", "gusbase", "280", "2a0", "2c0", "2e0", "300");
                        this.configuration_.removeValueIfAny("gus", "gusirq", "9", "10");
                        this.configuration_.removeValueIfAny("gus", "gusdma", "0");
                        this.configuration_.setValueIfAnyOr("speaker", "pcspeaker", "impulse", "off", "true");
                        this.configuration_.setValueIfAny("speaker", "pcrate", "49716", "65536");
                        this.configuration_.setValueIfAnyOr("speaker", "ps1audio", "true", "false", "on");
                        this.configuration_.removeValueIfAny("innova", "sidbase", "220", "2e0", "300");
                        this.configuration_.switchSetting("innova", "sidbase", "innovation", "sidport");
                        this.configuration_.setValueIfAnyOr("sdl", "usescancodes", "true", "false", "true", "1", "auto");
                        this.configuration_.switchSetting("sdl", "sensitivity", "mouse", "mouse_sensitivity");
                        this.configuration_.setValueIfAny("joystick", "joysticktype", "disabled", "none");
                        this.configuration_.switchSetting("ne2000", "ne2000", "ethernet", "ne2000");
                        this.configuration_.switchSetting("ne2000", "nicbase", "ethernet", "nicbase");
                        this.configuration_.switchSetting("ne2000", "nicirq", "ethernet", "nicirq");
                        this.configuration_.switchSetting("ne2000", "macaddr", "ethernet", "macaddr");
                        break block0;
                    }
                }
                throw new RuntimeException("Cannot switch from DOSBox-X to unknown generation");
            }
            default: {
                throw new RuntimeException("Cannot switch generation, invalid src gen");
            }
        }
    }

    public static enum Generation {
        official_063,
        official_065,
        official_070,
        official_073,
        svn_r4483,
        ece_r4482,
        staging_0810,
        staging_0820,
        x_20240301,
        x_20241001;

    }
}

