;-------------------------------------------------------------------------------------------------------------------

	; DSVZ200 Wrapper - interfaces the emulator DSVZ200 with original unmodified ZX81 1K Chess program

	; Target - VTech VZ200


	; INITIALIZE      - Calls routines needed by emulator wrapper and resets variables

	; DRAWCHESSBOARD  - Clear the screen and draw the chess board surrounds

	; UPDATE          - Redraws the chess board only

	; KEYSCAN         - Standard computer keyboard scan, returns a modified result compatible with the ZX81

	; HOME            - Reset Cursor Input Position, Remove any Displayed Input move characters

	; PRINT           - Add one Input Move character to Display

;-------------------------------------------------------------------------------------------------------------------
DRAWCHESSBOARD:
		; DISPLAY CHESS BOARD AND INPUT SUBROUTINES FOR EMULATOR

		LD BC,$0200			     ;Set BC to Video RAM size
		LD HL,$7000			     ;
DS01: 		LD A,$90			     ;CLEAR SCREEN MEMORY FROM $7000
		LD (HL),A			     ;
		INC HL				     ;
		DEC BC				     ;
		LD A,B				     ;
		OR C				     ;
		JR NZ,DS01			     ;
		LD HL,VZ200BOARD		     ;DRAW GRAPHICS 1-9 AND A-H ,TITLE ETC AROUND CHESS BOARD
		LD DE,$7049			     ;
		LD A,$0C			     ;
DS02: 		PUSH AF 			     ;
		LD BC,$0E			     ;
		LDIR 				     ;
		EX DE,HL			     ;
		PUSH DE 			     ;
		LD DE,$12			     ;
		ADD HL,DE			     ;
		POP DE				     ;
		EX DE,HL			     ;
		POP AF				     ;
		DEC A				     ;
		OR A				     ;
		JR NZ,DS02			     ;
		;CALL UPDATE01                        ;DRAW CHESS BOARD
		RET


INITIALIZE:
		DB $ED,$5F ;LD A,R
		LD (seed),A
		CALL RANDOMIZE

		CALL DRAWCHESSBOARD ;Wrapper draws chess board from ZX81 video RAM Contents

		;Reset Variables
		LD HL,move_from
		LD BC,$74
IN01:
		XOR A
		LD (HL),A
		INC HL
		DEC BC
		LD A,B
		OR C
		JR NZ,IN01

		LD A,0		   ;MODE  0 = HUMAN VS COMPUTER - COMPUTER MOVES FIRST
		LD (g_mode),a	   ;      1 = COMPUTER VS COMPUTER
				   ;      2 = HUMAN VS COMPUTER - HUMAN MOVES FIRST
		LD A,(g_mode)
		AND 2
		JR Z,computer_moves_first
		XOR A
		LD (whos_turn),A
computer_moves_first:


		;Set Registers to initial program starting values determined from the ZX81 emulator
		LD HL,$4000
		;PUSH HL
		;POP IY
		LD BC,$423F
		LD DE,$43B6
		LD HL,$1520
		LD A,$3F
		EXX
		LD BC,$8102
		LD DE,$002B
		LD HL,$10D2
		LD A,$E5
		EXX
		RET
		;---------------------------------------------------------------------------------------------------


		;PSEUDO RANDOM NUMBER GENERATOR
RANDOMIZE:
		LD A,(seed)
		LD B,A
		RRCA
		RRCA
		RRCA
		XOR $1F
		ADD A,B
		SBC A,$FF
		LD (seed),A
		RET

DELAY:
		PUSH BC
		PUSH AF
		LD BC,$FFFF
DEL01:  	DEC BC
		LD A,B
		OR C
		JR NZ,DEL01
		POP AF
		POP BC
		RET


UPDATEANDPMOVE:
		PUSH HL
		CALL PMOVE
		POP HL
		CALL UPDATE01
		RET




;-------------------------------------------------------------------------------------------------------------------
PRINT:  					     ;
		PUSH AF 			     ;Save register AF
		LD A,D				     ;
		ADD A,$13			     ;Adjust for VZ200 Numbers 1-8
		CP $39				     ;
		JR C,PRT01			     ;
		SUB $39 			     ;Characters A-H
						     ;
PRT01:  	LD (IX+0),A			     ;Output Character
		INC IX				     ;
		POP AF				     ;
		RET 				     ;
		;---------------------------------------------------------------------------------------------------

;-------------------------------------------------------------------------------------------------------------------
CLEAR:  					     ;Remove last Move input, 5 characters
		LD B,5				     ;
		LD A,$60			     ;Space character code on VZ200
CLR01:  	LD (IX+0),A			     ;
		DEC IX				     ;
		DJNZ CLR01			     ;
UPDATE:
		PUSH AF
		LD (HL),0			     ;Remove piece at 'From' square
		LD (DE),A			     ;Store piece at new square
		LD B,A				     ;
		JP UPD04
UPDATE01:
		PUSH AF
UPD04:
		PUSH HL 			     ;Save registers BC,DE,HL
		PUSH DE 			     ;
		PUSH BC 			     ;
		LD HL,chess_board+1		     ;Screen data
		LD DE,$708C			     ;
		LD A,$08			     ;
UPD02:  	PUSH AF 			     ;
		LD BC,$08			     ;
UPD03:  	LD A,(HL)			     ;
		CALL TRANSLATEZXTOVZ		     ;Converts ZX81 codes to character codes compatible with target computer
		LD (DE),A			     ;
		INC DE				     ;
		INC HL				     ;
		DEC BC				     ;
		LD A,B				     ;
		OR C				     ;
		JR NZ,UPD03			     ;
		EX DE,HL			     ;
		PUSH DE 			     ;
		LD DE,$18			     ;
		ADD HL,DE			     ;
		POP DE				     ;
		EX DE,HL			     ;
		INC HL				     ;
		INC HL				     ;
		INC HL				     ;
		POP AF				     ;
		DEC A				     ;
		OR A				     ;
		JR NZ,UPD02			     ;
		POP BC				     ;
		POP DE				     ;
		POP HL				     ;
		POP AF				     ;
		RET 				     ;
		;---------------------------------------------------------------------------------------------------

;-------------------------------------------------------------------------------------------------------------------
TRANSLATEZXTOVZ: 				     ;
		PUSH DE 			     ;Save registers BC,DE,HL
		PUSH BC 			     ;
		PUSH HL 			     ;
		LD HL,zx81tovz200chartable	     ;Converion data ZX81 to VZ200
		LD C,A				     ;
		ADD A,$20			     ;
		LD E,A				     ;Copy E to A this will be be modified if found in the table or stay the same
		LD B,$0D			     ;Size of table is 13 entries
TRNL01: 	LD A,(HL)			     ;
		INC HL				     ;
		CP C				     ;
		JR NZ,TRNL02			     ;Not a so match keep searching table
		LD A,(HL)			     ;
		LD E,A				     ;The original value has been matched so change E to new value
		JR TRNL03			     ;
TRNL02: 	INC HL				     ;Two bytes per entry
		DJNZ TRNL01			     ;
TRNL03: 	LD A,E				     ;Copy result from E back to A
		POP HL				     ;
		POP BC				     ;
		POP DE				     ;
		RET 				     ;

;-------------------------------------------------------------------------------------------------------------------
;KEYBOARD SCAN ROUTINE WRITTEN FOR DSVZ200 ALLOWS ZX1K CHESS TO RUN ON THE DSVZ200 EMULATOR
ROM02BB:
KEYSCAN:
		PUSH DE 		;Save registers BC,DE
		PUSH BC 		;
		CALL $2EF4		;Call VZ200 or VZ300 BASIC ROM address for 'Keyboard Scan'
		OR A			;
		JR NZ,RM01		;
		ADD A,$13		;Adjust for Number keys
RM01:
		SUB $14 		;The ZX81 will return $FF not $00 when no key down
		CP $FF			;
		JR Z,RM02		;If A = $FF Then no key press
		CP $2C			;
		JR C,RM02		;
		SUB $07 		;If > 2 Then add 7, This corrects for the characters A to Z
RM02: 		LD H,8			;
		LD L,A			;Put result in L
		POP BC			;
		POP DE			;
		LD BC,$FEFE		;Do not remove this line it is required to match the ZX81 subroutine
		RET

		   ;COPIED FROM THE ORIGINAL ZX81 BASIC ROM
;
;02BB  KEYSCAN     LD HL,$FFFF        ;Returns $FF if no key is pressed down
;                  LD BC,$FEFE        ;IO Port address $FE
;                  IN A,(C)           ;
;                  OR $01             ;Set low order bit  00000001
;02C5  EACHLINE    OR $E0             ;Set high order bits 11100000
;                  LD D,A             ;
;                  CPL                ;Xor A
;                  CP $01             ;
;                  SBC A,A            ;if > 1 then set to $FF
;                  OR B               ;OR $FE
;                  AND L              ;Mask with L
;                  LD L,A             ;Store result in L
;                  LD A,H             ;
;                  AND D              ;
;                  LD H,A             ;Mask H with D and save result in H
;                  RLC B              ;
;                  IN A,(C)           ;
;                  JR EACHLINE        ;Read Keyboard Port again and repeat for each row of keyboard keys on the ZX81
;                  RRA                ;
;                  RL H               ;
;                  RLA                ;
;                  RLA                ;
;                  RLA                ;A << 3
;                  SBC A,A            ;
;                  AND $18            ;Mask A with %00011000
;                  ADD A,$1D          ;
;                  LD (MARGIN),A      ;'Margin' is a ZX81 system variable
;                  RET                ;

ROM0724:
		LD (HL),B	;COPIED FROM ZX81 BASIC ROM
		DEC HL		;
		LD (HL),C	;
		DEC HL		;
		LD (HL),E	;
		DEC HL		;
		LD (HL),D	;
		RET 		;

zx81tovz200chartable:
		DB $30,$4B  ;WHITE KING       ;This table is used for converting ZX81 character codes
		DB $33,$4E  ;WHITE KNIGHT     ;to the emulators character display codes
		DB $35,$50  ;WHITE PAWN       ;
		DB $36,$51  ;WHITE QUEEN      ;first number on left of table is the original ZX81 value
		DB $37,$52  ;WHITE ROOK       ;the number on the right side of the table is the new modified result
		DB $27,$42  ;WHITE BISHOP     ;
		DB $B0,$0B  ;BLACK KING       ;
		DB $B3,$0E  ;BLACK KNIGHT     ;
		DB $B5,$10  ;BLACK PAWN       ;
		DB $B6,$11  ;BLACK QUEEN      ;
		DB $B7,$12  ;BLACK ROOK       ;
		DB $A7,$02  ;BLACK BISHOP     ;

; --- Chess board data for the VZ200 emulator ---

VZ200BOARD:
		DB $20,$31,$0B,$20,$03,$08,$05,$13,$13,$20,$90,$90,$90
		DB $90,$60,$60,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90
		DB $60,$60,$20,$31,$90,$90,$90,$90,$90,$90,$90,$90,$90
		DB $90,$60,$60,$20,$32,$90,$90,$90,$90,$90,$90,$90,$90
		DB $90,$90,$60,$60,$20,$33,$90,$90,$20,$90,$90,$90,$90
		DB $90,$90,$90,$60,$60,$20,$34,$90,$20,$A0,$90,$90,$90
		DB $90,$90,$90,$90,$60,$60,$20,$35,$90,$90,$20,$90,$90
		DB $90,$90,$90,$90,$90,$60,$60,$20,$36,$90,$20,$A0,$90
		DB $90,$90,$90,$90,$90,$90,$60,$60,$20,$37,$90,$90,$90
		DB $90,$90,$90,$90,$90,$90,$90,$60,$60,$20,$38,$90,$90
		DB $90,$90,$90,$90,$90,$90,$90,$90,$60,$60,$60,$60,$90
		DB $90,$90,$90,$90,$90,$90,$90,$90,$90,$60,$60,$60,$60
		DB $60,$08,$07,$06,$05,$04,$03,$02,$01,$60,$60,$60


		g_mode: 	DB $00	  ;Game Mode
		move_counter: 	DB $00
		seed: 		DB $00







;-------------------------------------------------------------------------------------------------------------------
HOME:
		CALL UPDATE01			     ;Redraw chess board

		PUSH DE 			     ;Save registers BC,DE
		PUSH BC 			     ;
		LD HL,$7053			     ;Sets Cursor Position to start of input $7009
		PUSH HL 			     ;
		POP IX				     ;
		LD A,$20			     ;
		LD (IX+0),A			     ;Clear previous move input from screen
		LD (IX+1),A			     ;
		LD (IX+2),A			     ;
		LD (IX+3),A			     ;
HM03: 		LD HL,inputbuffer		     ;HL points to inputbuffer
		POP BC				     ;
		POP DE				     ;

;-------------------------------------------------------------------------------------------------------------------
		   ;      Game Modes
		   ;          0 = HUMAN VS COMPUTER - COMPUTER MOVES FIRST
		   ;          1 = COMPUTER VS COMPUTER (aka 1K Chess VS 1K Chess)
		   ;          2 = HUMAN VS COMPUTER - HUMAN MOVES FIRST

EXTENDS_CHESS:
		LD A,(g_mode)			     ;MODE
		AND 1				     ;
		RET Z				     ;Not Mode 1
		CALL CHGMV
		LD A,(whos_turn)		     ;
		JR Z,exit_auto
		LD HL,move_counter		     ;Increment Move counter
		INC (HL)			     ;
		LD A,(HL)			     ;
		CP 8				     ;8 Data elements
		JR NC,exit_auto
;-------------------------------------------------------------------------------------------------------------------
opening_move:
		DEC A
		OR A
		LD HL,0
		RLCA
		LD L,A				     ;index
		LD DE,om_data		  ;Whites opening moves
		ADD HL,DE
		LD A,(whos_turn)		     ;
		AND $40 			     ; $40 ?
		JR Z,white_turn1		     ;
		LD DE,$40			     ;Move Pointer to Blacks moves
		ADD HL,DE			     ;
white_turn1:
		LD A,(seed)
		AND $03
		RLCA
		RLCA
		RLCA 	;times
		RLCA 	;16 x
		LD E,A
		XOR A
		LD D,A
		;ADD HL,DE   ;Point to random Table 0 , 1 , 2 or 3

		LD A,(HL)			     ;From position
		PUSH HL
		CALL GRIDTOBYTE
		LD A,(HL)			     ;Get Piece at position
		LD C,A
		AND $80 			     ;Clear square
		LD (HL),A			     ;
		LD A,C
		POP HL

		INC HL				     ;Point to 'Move To' POSITION
		PUSH AF 			     ;
		LD A,(HL)			     ;From position
		CALL GRIDTOBYTE
		POP AF
		LD (HL),A			     ;To Position

		CALL DELAY		;Slow down because move happens to fast
		CALL DELAY		;
		CALL DELAY		;
		CALL UPDATE01

		LD C,$80			     ;Toggle Turn Colour
		LD A,(whos_turn)		     ;
		XOR C				     ;
		LD (whos_turn),A		     ;
		;---------------------------------------------------------------------------------------------------
exit_auto:
		LD HL,inputbuffer		     ;HL points to inputbuffer
		POP BC
		JP DEMOMODE
;-------------------------------------------------------------------------------------------------------------------
GRIDTOBYTE:
		LD B,A
		AND $0F
		LD L,A
		XOR A
		LD H,A
		LD A,B
		AND $F0
		RRCA
		RRCA
		RRCA
		RRCA
		AND $0F
		INC A
		LD B,A
		LD A,L
TIM01:  	ADD A,$0B	;TIMES x 11
		DJNZ TIM01
		LD L,A
		LD DE,chess_board_data
		ADD HL,DE
		LD DE,$5
		ADD HL,DE
		RET
om_data:
	;       FromRC -RC To
		DB $24,$44	;Opening moves set a
		DB $23,$33
		DB $22,$42
		DB $32,$42

		DB $11,$11
		DB $11,$11
		DB $11,$11
		DB $11,$11


		DB $02,$00	;Opening moves set b
		DB $02,$00
		DB $00,$00
		DB $00,$00
		DB $00,$00
		DB $00,$00
		DB $00,$00
		DB $00,$00


		DB $03,$00	;Opening moves set c
		DB $03,$00
		DB $00,$00
		DB $00,$00
		DB $00,$00
		DB $00,$00
		DB $00,$00
		DB $00,$00


		DB $04,$00	;Opening moves set c
		DB $04,$00
		DB $00,$00
		DB $00,$00
		DB $00,$00
		DB $00,$00
		DB $00,$00
		DB $00,$00
end_of_moves:
;-------------------------------------------------------------------------------------------------------------------

