package net.sourceforge.javaqemu.view;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class VMCreationViewEnd extends JFrame {
	
	private static final long serialVersionUID = 1L;

	private JPanel windowContent;
	
	private GridBagLayout gridBagLayout;

	private GridBagConstraints gridBagConstraints;
	
	private JLabel windowDescription;
	
	private JButton noButton;
	
	private JButton yesButton;
	
	public VMCreationViewEnd() {
		super();
		
		windowContent = new JPanel();

		gridBagLayout = new GridBagLayout();
		this.gridBagConstraints = new GridBagConstraints();

		windowContent.setLayout(gridBagLayout);

		windowDescription = new JLabel("Do you want to open the new created virtual machine?");
		
		noButton = new JButton("No");
		
		yesButton = new JButton("Yes");
		
		gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.gridwidth = 2;

		windowContent.add(windowDescription, gridBagConstraints);
		
		gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.weightx = 0.5;
		gridBagConstraints.gridwidth = 1;
		
		windowContent.add(yesButton, gridBagConstraints);
		
		gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.weightx = 0.5;
		
		windowContent.add(noButton, gridBagConstraints);
	}
	
	public void initialize() {
		this.setContentPane(windowContent);
		this.setTitle("Create a new machine - The end");
		this.pack();
	}
	
	public void configureListener(ActionListener listener) {		
		noButton.addActionListener(listener);
		yesButton.addActionListener(listener);
	}

	public void configureStandardMode() {		
		noButton.setActionCommand("No_option_pos_creation");
		yesButton.setActionCommand("Yes_option_pos_creation");
	}
	
	public void showMessage(String message) {
		JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(500,500));
        JTextArea textArea = new JTextArea(message);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        textArea.setMargin(new Insets(5,5,5,5));
        scrollPane.getViewport().setView(textArea);
        Object trueMessage = scrollPane;
		JOptionPane.showMessageDialog(null, trueMessage);
	}
}
