package net.sourceforge.javaqemu.view;

import java.awt.GridLayout;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import net.sourceforge.javaqemu.control.FileControl;

public class NetworkDumpWorkerView extends JFileChooserView {
	
	private static final long serialVersionUID = 1L;

	private JPanel windowContent;

	private GridLayout gridLayout;

	private JCheckBox isEnabled;
	
	private JLabel temp;

	private JLabel vlanDescription;

	private JComboBox<String> vlan;
	
	private JButton fileChooser;
	
	private JTextField file;
	
	private JLabel lenDescription;
	
	private JTextField len;
	
	private JButton eraseButton;

	private JButton okButton;
	
	public NetworkDumpWorkerView(FileControl myfile, int position) {
		super(null);

		windowContent = new JPanel();
		
		this.setJpanel(windowContent);
		
		gridLayout = new GridLayout(5, 2);

		windowContent.setLayout(gridLayout);

		isEnabled = new JCheckBox("Enable this option!");

		windowContent.add(this.isEnabled);

		temp = new JLabel();
		
		windowContent.add(temp);

		vlanDescription = new JLabel("Choose the VLAN:");

		windowContent.add(vlanDescription);

		String[] numberOptions = { "", "0", "1", "2", "3", "4", "5", "6", "7",
				"8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18",
				"19", "20", "21", "22", "23", "24", "25", "26", "27", "28",
				"29", "30", "31", "32", "33", "34", "35", "36", "37", "38",
				"39", "40", "41", "42", "43", "44", "45", "46", "47", "48",
				"49", "50", "51", "52", "53", "54", "55", "56", "57", "58",
				"59", "60", "61", "62", "63", "64", "65", "66", "67", "68",
				"69", "70", "71", "72", "73", "74", "75", "76", "77", "78",
				"79", "80", "81", "82", "83", "84", "85", "86", "87", "88",
				"89", "90", "91", "92", "93", "94", "95", "96", "97", "98",
				"99", "100" };

		this.vlan = new JComboBox<String>(numberOptions);

		windowContent.add(vlan);
		
		this.fileChooser = new JButton("Choose the file for the dumped network traffic:");
		
		windowContent.add(this.fileChooser);
		
		this.file = new JTextField();
		
		windowContent.add(this.file);
		
		this.lenDescription = new JLabel("Choose the quantity of bytes per packet are stored:");
		
		windowContent.add(this.lenDescription);
		
		this.len = new JTextField();
		
		windowContent.add(this.len);
		
		okButton = new JButton("OK");

		eraseButton = new JButton("Erase");
		
		windowContent.add(okButton);

		windowContent.add(eraseButton);

		this.setContentPane(windowContent);

		this.setTitle("JavaQemu - Network Dump Choice");

		switch (position) {
		case 1:
			if (myfile.getMymodel().getFirstNetworkExtraOption() != null) {
				if (this.contains(myfile.getMymodel()
						.getFirstNetworkExtraOption())) {
					this.buildMe(myfile.getMymodel()
							.getFirstNetworkExtraOption());
					this.isEnabled.setSelected(true);
				}
			}
			break;
		case 2:
			if (myfile.getMymodel().getSecondNetworkExtraOption() != null) {
				if (this.contains(myfile.getMymodel()
						.getSecondNetworkExtraOption())) {
					this.buildMe(myfile.getMymodel()
							.getSecondNetworkExtraOption());
					this.isEnabled.setSelected(true);
				}
			}
			break;
		case 3:
			if (myfile.getMymodel().getThirdNetworkExtraOption() != null) {
				if (this.contains(myfile.getMymodel().getThirdNetworkExtraOption())) {
					this.buildMe(myfile.getMymodel().getThirdNetworkExtraOption());
					this.isEnabled.setSelected(true);
				}
			}
			break;
		case 4:
			if (myfile.getMymodel().getFourthNetworkExtraOption() != null) {
				if (this.contains(myfile.getMymodel().getFourthNetworkExtraOption())) {
					this.buildMe(myfile.getMymodel().getFourthNetworkExtraOption());
					this.isEnabled.setSelected(true);
				}
			}
			break;
		case 5:
			if (myfile.getMymodel().getFifthNetworkExtraOption() != null) {
				if (this.contains(myfile.getMymodel().getFifthNetworkExtraOption())) {
					this.buildMe(myfile.getMymodel().getFifthNetworkExtraOption());
					this.isEnabled.setSelected(true);
				}
			}
			break;
		case 6:
			if (myfile.getMymodel().getSixthNetworkExtraOption() != null) {
				if (this.contains(myfile.getMymodel().getSixthNetworkExtraOption())) {
					this.buildMe(myfile.getMymodel().getSixthNetworkExtraOption());
					this.isEnabled.setSelected(true);
				}
			}
			break;
		case 7:
			if (myfile.getMymodel().getSeventhNetworkExtraOption() != null) {
				if (this.contains(myfile.getMymodel().getSeventhNetworkExtraOption())) {
					this.buildMe(myfile.getMymodel().getSeventhNetworkExtraOption());
					this.isEnabled.setSelected(true);
				}
			}
			break;
		case 8:
			if (myfile.getMymodel().getEighthNetworkExtraOption() != null) {
				if (this.contains(myfile.getMymodel().getEighthNetworkExtraOption())) {
					this.buildMe(myfile.getMymodel().getEighthNetworkExtraOption());
					this.isEnabled.setSelected(true);
				}
			}
			break;
		case 9:
			if (myfile.getMymodel().getNinthNetworkExtraOption() != null) {
				if (this.contains(myfile.getMymodel().getNinthNetworkExtraOption())) {
					this.buildMe(myfile.getMymodel().getNinthNetworkExtraOption());
					this.isEnabled.setSelected(true);
				}
			}
			break;
		case 10:
			if (myfile.getMymodel().getTenthNetworkExtraOption() != null) {
				if (this.contains(myfile.getMymodel().getTenthNetworkExtraOption())) {
					this.buildMe(myfile.getMymodel().getTenthNetworkExtraOption());
					this.isEnabled.setSelected(true);
				}
			}
			break;
		default:
			break;
		}
		
		this.rechecks();
	}
	
	private void rechecks() {
		this.pack();
		this.repaint();
	}

	public void configureListener(ActionListener listener) {
		eraseButton.addActionListener(listener);
		okButton.addActionListener(listener);
		fileChooser.addActionListener(listener);
	}

	public void configureStandardMode() {
		eraseButton.setActionCommand("eraseButton");
		okButton.setActionCommand("okButton");
		fileChooser.setActionCommand("fileChooser");
	}

	private void buildMe(String optionString) {
		String options[] = optionString.split(",");
		for (String option : options) {
			if (option.startsWith("vlan=")) {
				this.vlan
						.setSelectedItem(option.substring(option.indexOf("=") + 1));
			} else if (option.startsWith("file=")) {
				this.file.setText(option.substring(option.indexOf("=") + 1));
			} else if (option.startsWith("len=")) {
				this.len.setText(option.substring(option.indexOf("=") + 1));
			}
		}
	}

	public JCheckBox getIsEnabled() {
		return isEnabled;
	}

	public JComboBox<String> getVlan() {
		return vlan;
	}
	
	private boolean contains(String option) {
		if (option.contains("dump"))
			return true;
		return false;
	}

	public JTextField getFile() {
		return file;
	}

	public JTextField getLen() {
		return len;
	}
}
