#define MAIN
#define uchar unsigned char
#define uint unsigned int
#define CFGSIZE 3
#define MAXRESOLUTION 8

#include <iostream>

uchar cfgarray[CFGSIZE];

void printcfg(void)
{
 std::cout << "RESOLUTION ";
 switch(cfgarray[0])
 {
  case 0: std::cout << "  640 x 400 (16:10)"; break;
  case 1: std::cout << "  640 x 480 (4:3)"; break;
  case 2: std::cout << "  800 x 600 (4:3)"; break;
  case 3: std::cout << "  1280 x 720 (16:9)"; break;
  case 4: std::cout << "  1280 x 800 (16:10)"; break;
  case 5: std::cout << "  1366 x 768 (16:9)"; break;
  case 6: std::cout << "  1440 x 900 (16:10)"; break;
  case 7: std::cout << "  1600 x 900 (16:9)"; break;
  case 8: std::cout << "  1920 x 1080 (16:9)"; break;
 }
 
 std::cout << "\nSCREEN MODE  ";
 switch(cfgarray[1])
 {
  case 0: std::cout << "WINDOWED"; break;
  case 1: std::cout << "FULL SCREEN"; break;
 }
 
 std::cout << "\nMUPARSER     ";
 switch(cfgarray[2])
 {
  case 0: std::cout << "DISABLED"; break;
  case 1: std::cout << "ENABLED"; break;
 }
}

int main(void)
{
 size_t actual_size;
 FILE *pFile;

 uint number=9; // invalid value
 
 char dummy;
 
 std::cout << "**********************************************\n";
 std::cout << "* Quick and dirty Hi65 configuration utility *\n";
 std::cout << "**********************************************\n\n";
 
 /* Configuration file format:
 1 byte - resolution, selected from a list
 1 byte - full screen (0=false, 1=true)
 1 byte - MuParser (0=disabled, 1=enabled)
 */
 
 pFile=fopen ("hi65.cfg","rb");
 actual_size=fread((void*)cfgarray,sizeof(unsigned char),CFGSIZE,pFile);
 fclose (pFile);
 
 std::cout << "     CURRENT CONFIGURATION\n";
 std::cout << "-------------------------------\n";
 
 printcfg();
 
 std::cout << "\n\nPress RETURN to start the configuration"; 
 
 std::cin.ignore();
 
 std::cout << "\nAVAILABLE RESOLUTIONS";
 std::cout << "\n---------------------";
 std::cout << "\nType: 0 for  640 x  400 (16:10)";
 std::cout << "\n      1 for  640 x  480 (4:3)";
 std::cout << "\n      2 for  800 x  600 (4:3)";
 std::cout << "\n      3 for 1280 x  720 (16:9)";
 std::cout << "\n      4 for 1280 x  800 (16:10)";
 std::cout << "\n      5 for 1366 x  768 (16:9)";
 std::cout << "\n      6 for 1440 x  900 (16:10)";
 std::cout << "\n      7 for 1600 x  900 (16:9)";
 std::cout << "\n      8 for 1920 x 1080 (16:9)";
 std::cout << "\nThen press RETURN\n";
 while (number<0 || number >8)
 {
  std::cin >> number;
  if (number<0 || number>8)
   // std::cout << "\nPlease enter a number from 0 to 8. Available resolutions are listed above.\n";
   printf("\nPlease enter a number from 0 to %d. Available resolutions are listed above.\n",MAXRESOLUTION);
 }
 cfgarray[0]=number;
 number=9;
 
 std::cout << "\nSCREEN MODE CONFIGURATION";
 std::cout << "\n-------------------------";
 std::cout << "\nType 0 for windowed mode, 1 for full screen mode";
 std::cout << "\nThen press RETURN\n";
 while (number<0 || number>1)
 {
  std::cin >> number;
  if (number<0 || number>1)
   std::cout << "\nPlease enter 0 or 1. Other values are not accepted.\n";
 }
 cfgarray[1]=number;
 number=9;
 
 std::cout << "\nMUPARSER STATUS";
 std::cout << "\n---------------";
 std::cout << "\nType 0 to disable MuParser, 1 to enable it";
 std::cout << "\nThen press RETURN\n";
 while (number<0 || number>1)
 {
  std::cin >> number;
  if (number<0 || number>1)
   std::cout << "\nPlease enter 0 or 1. Other values are not accepted.\n";
 }
 cfgarray[2]=number;
 
 pFile=fopen ("hi65.cfg","wb");
 fwrite (cfgarray,1,CFGSIZE,pFile);
 fclose (pFile);
 
 pFile=fopen ("hi65.cfg","rb");
 actual_size=fread((void*)cfgarray,sizeof(unsigned char),CFGSIZE,pFile);
 fclose (pFile);
 
 std::cout << "\n       NEW CONFIGURATION\n";
 std::cout << "-------------------------------\n";
 
 printcfg();
 
 std::cout << "\n\nConfiguration complete. Press RETURN to exit the program.";
 
 std::cin.ignore();
 std::cin.get();
 
 return 0;
}
