/*
  HI65 - a high-level Commodore 65 emulator
  Copyright (C) 2013-2023  Simone Gremmo
  Contact: devilmaster@email.com

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see
  http://www.gnu.org/licenses/gpl.txt
*/

// The C65 has 2 fonts: one is "unshifted" (default), the other one is
// "shifted". By pressing ALTGR+SHIFT you switch from one to the other.

// unshifted C65 font
const unsigned char f8x8[]=
{
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // space
 0x18,0x18,0x18,0x18,0x00,0x00,0x18,0x00, // !
 0x66,0x66,0x66,0x00,0x00,0x00,0x00,0x00, // "
 0x66,0x66,0xFF,0x66,0xFF,0x66,0x66,0x00, // #
 0x18,0x3E,0x60,0x7C,0x06,0x7C,0x18,0x00, // $
 0x62,0x66,0x0C,0x18,0x30,0x66,0x46,0x00, // %
 0x3C,0x66,0x3C,0x38,0x67,0x66,0x3F,0x00, // &
 0x06,0x0C,0x18,0x00,0x00,0x00,0x00,0x00, // '
 0x0C,0x18,0x30,0x30,0x30,0x18,0x0C,0x00, // (
 0x30,0x18,0x0C,0x0C,0x0C,0x18,0x30,0x00, // )
 0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00, // *
 0x00,0x18,0x18,0x7E,0x18,0x18,0x00,0x00, // +
 0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x30, // ,
 0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00, // -
 0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00, // .
 0x00,0x03,0x06,0x0C,0x18,0x30,0x60,0x00, // /
 0x3C,0x66,0x6E,0x76,0x66,0x66,0x3C,0x00, // 0
 0x18,0x18,0x38,0x18,0x18,0x18,0x7E,0x00, // 1
 0x3C,0x66,0x06,0x0C,0x30,0x60,0x7E,0x00, // 2
 0x3C,0x66,0x06,0x1C,0x06,0x66,0x3C,0x00, // 3
 0x06,0x0E,0x1E,0x66,0x7F,0x06,0x06,0x00, // 4
 0x7E,0x60,0x7C,0x06,0x06,0x66,0x3C,0x00, // 5
 0x3C,0x66,0x60,0x7C,0x66,0x66,0x3C,0x00, // 6
 0x7E,0x66,0x0C,0x18,0x18,0x18,0x18,0x00, // 7
 0x3C,0x66,0x66,0x3C,0x66,0x66,0x3C,0x00, // 8
 0x3C,0x66,0x66,0x3E,0x06,0x66,0x3C,0x00, // 9
 0x00,0x00,0x18,0x00,0x00,0x18,0x00,0x00, // :
 0x00,0x00,0x18,0x00,0x00,0x18,0x18,0x30, // ;
 0x0E,0x18,0x30,0x60,0x30,0x18,0x0E,0x00, // <
 0x00,0x00,0x7E,0x00,0x7E,0x00,0x00,0x00, // =
 0x70,0x18,0x0C,0x06,0x0C,0x18,0x70,0x00, // >
 0x3C,0x66,0x06,0x0C,0x18,0x00,0x18,0x00, // ?
 0x3C,0x66,0x6E,0x6E,0x60,0x62,0x3C,0x00, // @
 0x08,0x1C,0x3E,0x7F,0x7F,0x1C,0x3E,0x00, // spades
 0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18, // vertical bar, in the middle
 0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00, // horizontal bar, in the middle
 0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00, // horizontal bar, 1 pixel above the middle
 0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00, // horizontal bar, 2 pixels above the middle
 0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00, // horizontal bar, 1 pixel below the middle
 0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30, // vertical bar, 1 pixel left of the middle
 0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C, // vertical bar, 1 pixel right of the middle
 0x00,0x00,0x00,0xE0,0xF0,0x38,0x18,0x18, // quarter of empty circle, top right
 0x18,0x18,0x1C,0x0F,0x07,0x00,0x00,0x00, // quarter of empty circle, bottom left
 0x18,0x18,0x38,0xF0,0xE0,0x00,0x00,0x00, // quarter of empty circle, bottom right
 0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xFF,0xFF, // right angle, bottom right
 0xC0,0xE0,0x70,0x38,0x1C,0x0E,0x07,0x03, // backslash (\)
 0x03,0x07,0x0E,0x1C,0x38,0x70,0xE0,0xC0, // slash (/)
 0xFF,0xFF,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0, // right angle, top left
 0xFF,0xFF,0x03,0x03,0x03,0x03,0x03,0x03, // right angle, top right
 0x00,0x3C,0x7E,0x7E,0x7E,0x7E,0x3C,0x00, // full circle
 0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00, // horizontal bar, 2 pixels below the middle
 0x36,0x7F,0x7F,0x7F,0x3E,0x1C,0x08,0x00, // hearts
 0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60, // vertical bar, 2 pixels left of the middle
 0x00,0x00,0x00,0x07,0x0F,0x1C,0x18,0x18, // quarter of empty circle, top left
 0xC3,0xE7,0x7E,0x3C,0x3C,0x7E,0xE7,0xC3, // big X
 0x00,0x3C,0x7E,0x66,0x66,0x7E,0x3C,0x00, // empty circle
 0x18,0x18,0x66,0x66,0x18,0x18,0x3C,0x00, // clubs
 0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06, // vertical bar, 2 pixels right of the middle
 0x08,0x1C,0x3E,0x7F,0x3E,0x1C,0x08,0x00, // diamonds
 0x3C,0x30,0x30,0x30,0x30,0x30,0x3C,0x00, // [
 0x0C,0x12,0x30,0x7C,0x30,0x62,0xFC,0x00, // \ (actually "", because "\" is part of the graphical set)
 0x3C,0x0C,0x0C,0x0C,0x0C,0x0C,0x3C,0x00, // ]
 0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18, // ^ (up arrow)
 0x00,0x10,0x30,0x7F,0x7F,0x30,0x10,0x00, // _ (actually "<-", because "_" is part of the graphical set)
 0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00, // ` (actually a horizontal line in the middle)
 0x18,0x3C,0x66,0x7E,0x66,0x66,0x66,0x00, // A
 0x7C,0x66,0x66,0x7C,0x66,0x66,0x7C,0x00, // B
 0x3C,0x66,0x60,0x60,0x60,0x66,0x3C,0x00, // C
 0x78,0x6C,0x66,0x66,0x66,0x6C,0x78,0x00, // D
 0x7E,0x60,0x60,0x78,0x60,0x60,0x7E,0x00, // E
 0x7E,0x60,0x60,0x78,0x60,0x60,0x60,0x00, // F
 0x3C,0x66,0x60,0x6E,0x66,0x66,0x3C,0x00, // G
 0x66,0x66,0x66,0x7E,0x66,0x66,0x66,0x00, // H
 0x3C,0x18,0x18,0x18,0x18,0x18,0x3C,0x00, // I
 0x1E,0x0C,0x0C,0x0C,0x0C,0x6C,0x38,0x00, // J
 0x66,0x6C,0x78,0x70,0x78,0x6C,0x66,0x00, // K
 0x60,0x60,0x60,0x60,0x60,0x60,0x7E,0x00, // L
 0x63,0x77,0x7F,0x6B,0x63,0x63,0x63,0x00, // M
 0x66,0x76,0x7E,0x7E,0x6E,0x66,0x66,0x00, // N
 0x3C,0x66,0x66,0x66,0x66,0x66,0x3C,0x00, // O
 0x7C,0x66,0x66,0x7C,0x60,0x60,0x60,0x00, // P
 0x3C,0x66,0x66,0x66,0x66,0x3C,0x1E,0x00, // Q
 0x7C,0x66,0x66,0x7C,0x78,0x6C,0x66,0x00, // R
 0x3C,0x66,0x60,0x3C,0x06,0x66,0x3C,0x00, // S
 0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0x00, // T
 0x66,0x66,0x66,0x66,0x66,0x66,0x3C,0x00, // U
 0x66,0x66,0x66,0x66,0x66,0x3C,0x18,0x00, // V
 0x63,0x63,0x63,0x6B,0x7F,0x77,0x63,0x00, // W
 0x66,0x66,0x3C,0x18,0x3C,0x66,0x66,0x00, // X
 0x66,0x66,0x66,0x3C,0x18,0x18,0x18,0x00, // Y
 0x7E,0x06,0x0C,0x18,0x30,0x60,0x7E,0x00, // Z
 0x18,0x18,0x18,0xFF,0xFF,0x18,0x18,0x18, // centered cross
 0xC0,0xC0,0x30,0x30,0xC0,0xC0,0x30,0x30, // half grid, left
 0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18, // vertical pipe ("or" symbol)
 0x00,0x00,0x03,0x3E,0x76,0x36,0x36,0x00, // pi
 0xFF,0x7F,0x3F,0x1F,0x0F,0x07,0x03,0x01, // half a square (top right)
 
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // other space
 0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0, // half a square (left)
 0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF, // half a square (down)
 0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // overscore (like an underscore, but it's on top)
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF, // underscore (_)
 0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0, // 2-pixel-wide vertical bar, left
 0xCC,0xCC,0x33,0x33,0xCC,0xCC,0x33,0x33, // full grid (inverted)
 0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03, // 2-pixel-wide vertical bar, right
 0x00,0x00,0x00,0x00,0xCC,0xCC,0x33,0x33, // half grid, bottom
 0xFF,0xFE,0xFC,0xF8,0xF0,0xE0,0xC0,0x80, // half a square (top left)
 0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03, // another 2-pixel-wide vertical bar, right
 0x18,0x18,0x18,0x1F,0x1F,0x18,0x18,0x18, // |- facing right
 0x00,0x00,0x00,0x00,0x0F,0x0F,0x0F,0x0F, // small square, bottom right
 0x18,0x18,0x18,0x1F,0x1F,0x00,0x00,0x00, // top right quarter of a cross
 0x00,0x00,0x00,0xF8,0xF8,0x18,0x18,0x18, // bottom left quarter of a cross
 0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF, // 2-pixel-wide horizontal bar, bottom
 0x00,0x00,0x00,0x1F,0x1F,0x18,0x18,0x18, // bottom right quarter of a cross
 0x18,0x18,0x18,0xFF,0xFF,0x00,0x00,0x00, // |- facing up
 0x00,0x00,0x00,0xFF,0xFF,0x18,0x18,0x18, // |- facing down
 0x18,0x18,0x18,0xF8,0xF8,0x18,0x18,0x18, // -| facing left
 0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0, // another 2-pixel-wide vertical bar, left
 0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0, // 3-pixel-wide vertical bar, left
 0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07, // 3-pixel-wide vertical bar, right
 0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00, // 2-pixel-wide horizontal bar, top
 0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00, // 3-pixel-wide horizontal bar, top
 0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF, // 3-pixel-wide horizontal bar, bottom
 0x03,0x03,0x03,0x03,0x03,0x03,0xFF,0xFF, // right angle, bottom right
 0x00,0x00,0x00,0x00,0xF0,0xF0,0xF0,0xF0, // small square, bottom left
 0x0F,0x0F,0x0F,0x0F,0x00,0x00,0x00,0x00, // small square, top right
 0x18,0x18,0x18,0xF8,0xF8,0x00,0x00,0x00, // top left quarter of a cross
 0xF0,0xF0,0xF0,0xF0,0x00,0x00,0x00,0x00, // small square, top left
 0xF0,0xF0,0xF0,0xF0,0x0F,0x0F,0x0F,0x0F, // two small squares (top left/bottom right)
};

// shifted C65 font
const unsigned char f8x8shifted[]=
{
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //  0   space
 0x18,0x18,0x18,0x18,0x00,0x00,0x18,0x00, //  1   !
 0x66,0x66,0x66,0x00,0x00,0x00,0x00,0x00, //  2   "
 0x66,0x66,0xFF,0x66,0xFF,0x66,0x66,0x00, //  3   #
 0x18,0x3E,0x60,0x7C,0x06,0x7C,0x18,0x00, //  4   $
 0x62,0x66,0x0C,0x18,0x30,0x66,0x46,0x00, //  5   %
 0x3C,0x66,0x3C,0x38,0x67,0x66,0x3F,0x00, //  6   &
 0x06,0x0C,0x18,0x00,0x00,0x00,0x00,0x00, //  7   '
 0x0C,0x18,0x30,0x30,0x30,0x18,0x0C,0x00, //  8   (
 0x30,0x18,0x0C,0x0C,0x0C,0x18,0x30,0x00, //  9   )
 0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00, // 10   *
 0x00,0x18,0x18,0x7E,0x18,0x18,0x00,0x00, // 11   +
 0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x30, // 12   ,
 0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00, // 13   -
 0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00, // 14   .
 0x00,0x03,0x06,0x0C,0x18,0x30,0x60,0x00, // 15   /
 0x3C,0x66,0x6E,0x76,0x66,0x66,0x3C,0x00, // 16   0
 0x18,0x18,0x38,0x18,0x18,0x18,0x7E,0x00, // 17   1
 0x3C,0x66,0x06,0x0C,0x30,0x60,0x7E,0x00, // 18   2
 0x3C,0x66,0x06,0x1C,0x06,0x66,0x3C,0x00, // 19   3
 0x06,0x0E,0x1E,0x66,0x7F,0x06,0x06,0x00, // 20   4
 0x7E,0x60,0x7C,0x06,0x06,0x66,0x3C,0x00, // 21   5
 0x3C,0x66,0x60,0x7C,0x66,0x66,0x3C,0x00, // 22   6
 0x7E,0x66,0x0C,0x18,0x18,0x18,0x18,0x00, // 23   7
 0x3C,0x66,0x66,0x3C,0x66,0x66,0x3C,0x00, // 24   8
 0x3C,0x66,0x66,0x3E,0x06,0x66,0x3C,0x00, // 25   9
 0x00,0x00,0x18,0x00,0x00,0x18,0x00,0x00, // 26   :
 0x00,0x00,0x18,0x00,0x00,0x18,0x18,0x30, // 27   ;
 0x0E,0x18,0x30,0x60,0x30,0x18,0x0E,0x00, // 28   <
 0x00,0x00,0x7E,0x00,0x7E,0x00,0x00,0x00, // 29   =
 0x70,0x18,0x0C,0x06,0x0C,0x18,0x70,0x00, // 30   >
 0x3C,0x66,0x06,0x0C,0x18,0x00,0x18,0x00, // 31   ?
 0x3C,0x66,0x6E,0x6E,0x60,0x62,0x3C,0x00, // 32   @
 0x18,0x3C,0x66,0x7E,0x66,0x66,0x66,0x00, // 33   A  ***********************************
 0x7C,0x66,0x66,0x7C,0x66,0x66,0x7C,0x00, // 34   B  *                                 *
 0x3C,0x66,0x60,0x60,0x60,0x66,0x3C,0x00, // 35   C  *                                 *
 0x78,0x6C,0x66,0x66,0x66,0x6C,0x78,0x00, // 36   D  *                                 *
 0x7E,0x60,0x60,0x78,0x60,0x60,0x7E,0x00, // 37   E  *                                 *
 0x7E,0x60,0x60,0x78,0x60,0x60,0x60,0x00, // 38   F  *                                 *
 0x3C,0x66,0x60,0x6E,0x66,0x66,0x3C,0x00, // 39   G  *                                 *
 0x66,0x66,0x66,0x7E,0x66,0x66,0x66,0x00, // 40   H  *                                 *
 0x3C,0x18,0x18,0x18,0x18,0x18,0x3C,0x00, // 41   I  *                                 *
 0x1E,0x0C,0x0C,0x0C,0x0C,0x6C,0x38,0x00, // 42   J  * TO USE THESE LETTERS YOU MUST   *
 0x66,0x6C,0x78,0x70,0x78,0x6C,0x66,0x00, // 43   K  * TYPE THEM IN LOWER CASE         *
 0x60,0x60,0x60,0x60,0x60,0x60,0x7E,0x00, // 44   L  *                                 *
 0x63,0x77,0x7F,0x6B,0x63,0x63,0x63,0x00, // 45   M  *                                 *
 0x66,0x76,0x7E,0x7E,0x6E,0x66,0x66,0x00, // 46   N  *                                 *
 0x3C,0x66,0x66,0x66,0x66,0x66,0x3C,0x00, // 47   O  *                                 *
 0x7C,0x66,0x66,0x7C,0x60,0x60,0x60,0x00, // 48   P  *                                 *
 0x3C,0x66,0x66,0x66,0x66,0x3C,0x1E,0x00, // 49   Q  *                                 *
 0x7C,0x66,0x66,0x7C,0x78,0x6C,0x66,0x00, // 50   R  *                                 *
 0x3C,0x66,0x60,0x3C,0x06,0x66,0x3C,0x00, // 51   S  *                                 *
 0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0x00, // 52   T  *                                 *
 0x66,0x66,0x66,0x66,0x66,0x66,0x3C,0x00, // 53   U  *                                 *
 0x66,0x66,0x66,0x66,0x66,0x3C,0x18,0x00, // 54   V  *                                 *
 0x63,0x63,0x63,0x6B,0x7F,0x77,0x63,0x00, // 55   W  *                                 *
 0x66,0x66,0x3C,0x18,0x3C,0x66,0x66,0x00, // 56   X  *                                 *
 0x66,0x66,0x66,0x3C,0x18,0x18,0x18,0x00, // 57   Y  *                                 *
 0x7E,0x06,0x0C,0x18,0x30,0x60,0x7E,0x00, // 58   Z  ***********************************
 0x3C,0x30,0x30,0x30,0x30,0x30,0x3C,0x00, // 59   [
 0x0C,0x12,0x30,0x7C,0x30,0x62,0xFC,0x00, // 60   \ (actually "", because "\" is part of the graphical set)
 0x3C,0x0C,0x0C,0x0C,0x0C,0x0C,0x3C,0x00, // 61   ]
 0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18, // 62   ^ (up arrow)
 0x00,0x10,0x30,0x7F,0x7F,0x30,0x10,0x00, // 63   _ (actually "<-", because "_" is part of the graphical set)
 0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00, // 64   ` (actually a horizontal line in the middle)
 0x00,0x00,0x3C,0x06,0x3E,0x66,0x3E,0x00, // 65   a  ***********************************
 0x60,0x60,0x7C,0x66,0x66,0x66,0x7C,0x00, // 66   b  *                                 *
 0x00,0x00,0x3C,0x66,0x60,0x66,0x3C,0x00, // 67   c  *                                 *
 0x06,0x06,0x3E,0x66,0x66,0x66,0x3E,0x00, // 68   d  *                                 *
 0x00,0x00,0x3C,0x66,0x7E,0x60,0x3E,0x00, // 69   e  *                                 *
 0x1C,0x36,0x30,0x78,0x30,0x30,0x30,0x00, // 70   f  *                                 *
 0x00,0x00,0x3E,0x66,0x66,0x3E,0x06,0x7C, // 71   g  *                                 *
 0x60,0x60,0x7C,0x66,0x66,0x66,0x66,0x00, // 72   h  *                                 *
 0x18,0x00,0x18,0x18,0x18,0x18,0x18,0x00, // 73   i  *                                 *
 0x06,0x00,0x06,0x06,0x06,0x06,0x66,0x3C, // 74   j  * TO USE THESE LETTERS YOU MUST   *
 0x60,0x60,0x66,0x6C,0x78,0x7C,0x66,0x00, // 75   k  * TYPE THEM IN UPPER CASE         *
 0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00, // 76   l  *                                 *
 0x00,0x00,0x63,0x77,0x7F,0x6B,0x63,0x00, // 77   m  *                                 *
 0x00,0x00,0x7C,0x66,0x66,0x66,0x66,0x00, // 78   n  *                                 *
 0x00,0x00,0x3C,0x66,0x66,0x66,0x3C,0x00, // 79   o  *                                 *
 0x00,0x00,0x7C,0x66,0x66,0x7C,0x60,0x60, // 80   p  *                                 *
 0x00,0x00,0x3E,0x66,0x66,0x7E,0x06,0x06, // 81   q  *                                 *
 0x00,0x00,0x7C,0x66,0x60,0x60,0x60,0x00, // 82   r  *                                 *
 0x00,0x00,0x3C,0x60,0x3C,0x06,0x7C,0x00, // 83   s  *                                 *
 0x30,0x30,0xFC,0x30,0x30,0x36,0x1C,0x00, // 84   t  *                                 *
 0x00,0x00,0x66,0x66,0x66,0x66,0x3C,0x00, // 85   u  *                                 *
 0x00,0x00,0x66,0x66,0x66,0x3C,0x18,0x00, // 86   v  *                                 *
 0x00,0x00,0x63,0x6B,0x7F,0x36,0x22,0x00, // 87   w  *                                 *
 0x00,0x00,0x66,0x3C,0x18,0x3C,0x66,0x00, // 88   x  *                                 *
 0x00,0x00,0x66,0x66,0x66,0x3E,0x06,0x7C, // 89   y  *                                 *
 0x00,0x00,0x7E,0x0C,0x18,0x30,0x7E,0x00, // 90   z  ***********************************
 0x18,0x18,0x18,0xFF,0xFF,0x18,0x18,0x18, // centered cross
 0xC0,0xC0,0x30,0x30,0xC0,0xC0,0x30,0x30, // half grid, left
 0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18, // vertical pipe ("or" symbol)
 0x33,0x33,0xCC,0xCC,0x33,0x33,0xCC,0xCC, // full grid
 0x33,0x99,0xCC,0x66,0x33,0x98,0xCC,0x66, // diagonals top left/bottom right
 
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // other space
 0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0, // half a square (left)
 0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF, // half a square (bottom)
 0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // overscore (like an underscore, but it's on top)
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF, // underscore (_)
 0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0, // 2-pixel-wide vertical bar, left
 0xCC,0xCC,0x33,0x33,0xCC,0xCC,0x33,0x33, // full grid (inverted)
 0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03, // 2-pixel-wide vertical bar, right
 0x00,0x00,0x00,0x00,0xCC,0xCC,0x33,0x33, // half grid, bottom
 0xCC,0x99,0x33,0x66,0xCC,0x99,0x33,0x66, // diagonals top right/bottom left
 0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03, // another 2-pixel-wide vertical bar, right
 0x18,0x18,0x18,0x1F,0x1F,0x18,0x18,0x18, // |- facing right
 0x00,0x00,0x00,0x00,0x0F,0x0F,0x0F,0x0F, // small square, bottom right
 0x18,0x18,0x18,0x1F,0x1F,0x00,0x00,0x00, // top right quarter of a cross
 0x00,0x00,0x00,0xF8,0xF8,0x18,0x18,0x18, // bottom left quarter of a cross
 0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF, // 2-pixel-wide horizontal bar, down
 0x00,0x00,0x00,0x1F,0x1F,0x18,0x18,0x18, // bottom right quarter of a cross
 0x18,0x18,0x18,0xFF,0xFF,0x00,0x00,0x00, // |- facing up
 0x00,0x00,0x00,0xFF,0xFF,0x18,0x18,0x18, // |- facing down
 0x18,0x18,0x18,0xF8,0xF8,0x18,0x18,0x18, // -| facing left
 0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0, // another 2-pixel-wide vertical bar, left
 0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0, // 3-pixel-wide vertical bar, left
 0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07, // 3-pixel-wide vertical bar, right
 0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00, // 2-pixel-wide horizontal bar, up
 0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00, // 3-pixel-wide horizontal bar, up
 0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF, // 3-pixel-wide horizontal bar, down
 0x01,0x03,0x06,0x6C,0x78,0x70,0x60,0x00, // check (Amiga symbol)
 0x00,0x00,0x00,0x00,0xF0,0xF0,0xF0,0xF0, // small square, bottom left
 0x0F,0x0F,0x0F,0x0F,0x00,0x00,0x00,0x00, // small square, top right
 0x18,0x18,0x18,0xF8,0xF8,0x00,0x00,0x00, // top left quarter of a cross
 0xF0,0xF0,0xF0,0xF0,0x00,0x00,0x00,0x00, // small square, top left
 0xF0,0xF0,0xF0,0xF0,0x0F,0x0F,0x0F,0x0F, // two small squares (top left/bottom right)
};

// The colors of the C65 are expressed through a triplet of numbers
// ranging from 0 to 15. The colors of Allegro are similarly expressed
// through a triplet of numbers, but they range from 0 to 255.
// To convert a C65 color into the corresponding Allegro color, a
// proportion has been used: c65color : allegrocolor = 15 : 255
const unsigned char c65color[]=
{0,17,34,51,68,85,102,119,136,153,170,187,204,221,238,255};

// The  following  error  messages  are  displayed  by BASIC.  Error
// messages  can  also  be displayed with the use of the ERR$()
// function. The  error  number refers only to the number assigned to
// the error for use with this function. 
const unsigned char c65basicerrors[]=
{
 't','o','o',' ','m','a','n','y',' ','f','i','l','e','s',' ',' ',' ',' ',' ',' ',' ',
 'f','i','l','e',' ','o','p','e','n',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
 'f','i','l','e',' ','n','o','t',' ','o','p','e','n',' ',' ',' ',' ',' ',' ',' ',' ',
 'f','i','l','e',' ','n','o','t',' ','f','o','u','n','d',' ',' ',' ',' ',' ',' ',' ',
 'd','e','v','i','c','e',' ','n','o','t',' ','p','r','e','s','e','n','t',' ',' ',' ',
 'n','o','t',' ','i','n','p','u','t',' ','f','i','l','e',' ',' ',' ',' ',' ',' ',' ',
 'n','o','t',' ','o','u','t','p','u','t',' ','f','i','l','e',' ',' ',' ',' ',' ',' ',
 'm','i','s','s','i','n','g',' ','f','i','l','e',' ','n','a','m','e',' ',' ',' ',' ',
 'i','l','l','e','g','a','l',' ','d','e','v','i','c','e',' ','n','u','m','b','e','r',
 'n','e','x','t',' ','w','i','t','h','o','u','t',' ','f','o','r',' ',' ',' ',' ',' ',
 's','y','n','t','a','x',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
 'r','e','t','u','r','n',' ','w','i','t','h','o','u','t',' ','g','o','s','u','b',' ',
 'o','u','t',' ','o','f',' ','d','a','t','a',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
 'i','l','l','e','g','a','l',' ','q','u','a','n','t','i','t','y',' ',' ',' ',' ',' ',
 'o','v','e','r','f','l','o','w',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
 'o','u','t',' ','o','f',' ','m','e','m','o','r','y',' ',' ',' ',' ',' ',' ',' ',' ',
 'u','n','d','e','f','\'','d',' ','s','t','a','t','e','m','e','n','t',' ',' ',' ',' ',
 'b','a','d',' ','s','u','b','s','c','r','i','p','t',' ',' ',' ',' ',' ',' ',' ',' ',
 'r','e','d','i','m','\'','d',' ','a','r','r','a','y',' ',' ',' ',' ',' ',' ',' ',' ',
 'd','i','v','i','s','i','o','n',' ','b','y',' ','z','e','r','o',' ',' ',' ',' ',' ',
 'i','l','l','e','g','a','l',' ','d','i','r','e','c','t',' ',' ',' ',' ',' ',' ',' ',
 't','y','p','e',' ','m','i','s','m','a','t','c','h',' ',' ',' ',' ',' ',' ',' ',' ',
 's','t','r','i','n','g',' ','t','o','o',' ','l','o','n','g',' ',' ',' ',' ',' ',' ',
 'w','r','o','n','g',' ','f','i','l','e',' ','d','a','t','a',' ',' ',' ',' ',' ',' ',
 'f','o','r','m','u','l','a',' ','t','o','o',' ','c','o','m','p','l','e','x',' ',' ',
 'c','a','n','\'','t',' ','c','o','n','t','i','n','u','e',' ',' ',' ',' ',' ',' ',' ',
 'u','n','d','e','f','i','n','e','d',' ','f','u','n','c','t','i','o','n',' ',' ',' ',
 'v','e','r','i','f','y',' ','p','r','o','g','r','a','m',' ',' ',' ',' ',' ',' ',' ',
 'l','o','a','d',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
 'b','r','e','a','k',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
 'c','a','n','\'','t',' ','r','e','s','u','m','e',' ',' ',' ',' ',' ',' ',' ',' ',' ',
 'l','o','o','p',' ','n','o','t',' ','f','o','u','n','d',' ',' ',' ',' ',' ',' ',' ',
 'l','o','o','p',' ','w','i','t','h','o','u','t',' ','d','o',' ',' ',' ',' ',' ',' ',
 'd','i','r','e','c','t',' ','m','o','d','e',' ','o','n','l','y',' ',' ',' ',' ',' ',
 'n','o',' ','g','r','a','p','h','i','c','s',' ','a','r','e','a',' ',' ',' ',' ',' ',
 'b','a','d',' ','d','i','s','k',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
 'b','e','n','d',' ','n','o','t',' ','f','o','u','n','d',' ',' ',' ',' ',' ',' ',' ',
 'l','i','n','e',' ','n','u','m','b','e','r',' ','t','o','o',' ','l','a','r','g','e',
 'u','n','r','e','s','o','l','v','e','d',' ','r','e','f','e','r','e','n','c','e',' ',
 'u','n','i','m','p','l','e','m','e','n','t','e','d',' ','c','o','m','m','a','n','d',
 'f','i','l','e',' ','r','e','a','d',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
 
 // DOS errors
 'o','k',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
 'f','i','l','e','s',' ','s','c','r','a','t','c','h','e','d',' ',' ',' ',' ',' ',' ',
 'p','a','r','t','i','t','i','o','n',' ','s','e','l','e','c','t','e','d',' ',' ',' ',
 'f','i','l','e','s',' ','l','o','c','k','e','d',' ',' ',' ',' ',' ',' ',' ',' ',' ',
 'f','i','l','e','s',' ','u','n','l','o','c','k','e','d',' ',' ',' ',' ',' ',' ',' ',
 'f','i','l','e','s',' ','r','e','s','t','o','r','e','d',' ',' ',' ',' ',' ',' ',' ',
 'b','l','o','c','k',' ','h','d','r',' ','n','o','t',' ','f','o','u','n','d',' ',' ',
 'n','o',' ','s','y','n','c',' ','c','h','a','r','a','c','t','e','r',' ',' ',' ',' ',
 'd','a','t','a','b','l','o','c','k',' ','n','o','t',' ','p','r','e','s','e','n','t',
 'd','a','t','a','b','l','o','c','k',' ','c','h','e','c','k','s','u','m',' ',' ',' ',
 'b','y','t','e',' ','d','e','c','o','d','i','n','g',' ',' ',' ',' ',' ',' ',' ',' ',
 'w','r','i','t','e',' ','v','e','r','i','f','i','c','a','t','i','o','n',' ',' ',' ',
 'w','r','i','t','e',' ','p','r','o','t','e','c','t',' ',' ',' ',' ',' ',' ',' ',' ',
 'r','e','a','d',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
 'w','r','i','t','e',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
 'd','i','s','k',' ','i','d',' ','m','i','s','m','a','t','c','h',' ',' ',' ',' ',' ',
 's','y','n','t','a','x',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
 'i','n','v','a','l','i','d',' ','c','o','m','m','a','n','d',' ',' ',' ',' ',' ',' ',
 'c','o','m','m','a','n','d',' ','t','o','o',' ','l','o','n','g',' ',' ',' ',' ',' ',
 'i','n','v','a','l','i','d',' ','f','i','l','e',' ','n','a','m','e',' ',' ',' ',' ',

 'f','i','l','e',' ','e','x','i','s','t','s',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
 
 // MuParser errors
 'u','n','e','x','p','e','c','t','e','d',' ','o','p','e','r','a','t','o','r',' ',' ',
 'u','n','a','s','s','i','g','n','a','b','l','e',' ','t','o','k','e','n',' ',' ',' ',
 'u','n','e','x','p',' ','e','n','d',' ','o','f',' ','f','o','r','m','u','l','a',' ',
 'u','n','e','x','p','e','c','t','e','d',' ','s','e','p','a','r','a','t','o','r',' ',
 'u','n','e','x','p','e','c','t','e','d',' ','a','r','g','u','m','e','n','t',' ',' ',
 'u','n','e','x','p','e','c','t','e','d',' ','v','a','l','u','e',' ',' ',' ',' ',' ',
 'u','n','e','x','p','e','c','t','e','d',' ','v','a','r','i','a','b','l','e',' ',' ',
 'u','n','e','x','p',' ','p','a','r','e','n','t','h','e','s','i','s',' ',' ',' ',' ',
 'u','n','e','x','p','e','c','t','e','d',' ','s','t','r','i','n','g',' ',' ',' ',' ',
 's','t','r','i','n','g',' ','e','x','p','e','c','t','e','d',' ',' ',' ',' ',' ',' ',
 'v','a','l','u','e',' ','e','x','p','e','c','t','e','d',' ',' ',' ',' ',' ',' ',' ',
 'm','i','s','s','i','n','g',' ','p','a','r','e','n','t','h','e','s','i','s',' ',' ',
 'u','n','e','x','p','e','c','t','e','d',' ','f','u','n','c','t','i','o','n',' ',' ',
 'u','n','t','e','r','m','i','n','a','t','e','d',' ','s','t','r','i','n','g',' ',' ',
 't','o','o',' ','m','a','n','y',' ','p','a','r','a','m','e','t','e','r','s',' ',' ',
 't','o','o',' ','f','e','w',' ','p','a','r','a','m','e','t','e','r','s',' ',' ',' ',
 'o','p','e','r','a','t','o','r',' ','c','o','n','f','l','i','c','t',' ',' ',' ',' ',
 'r','e','s','u','l','t',' ','i','s',' ','a',' ','s','t','r','i','n','g',' ',' ',' ',
 'i','n','v','a','l','i','d',' ','n','a','m','e',' ',' ',' ',' ',' ',' ',' ',' ',' ',
 'i','n','v','a','l','i','d',' ','b','i','n','a','r','y',' ','i','d',' ',' ',' ',' ',
 'i','n','v','a','l','i','d',' ','i','n','f','i','x',' ','i','d',' ',' ',' ',' ',' ',
 'i','n','v','a','l','i','d',' ','p','o','s','t','f','i','x',' ','i','d',' ',' ',' ',
 'b','u','i','l','t','i','n',' ','o','v','e','r','l','o','a','d',' ',' ',' ',' ',' ',
 'i','n','v','a','l','i','d',' ','f','u','n','c',' ','p','o','i','n','t','e','r',' ',
 'i','n','v','a','l','i','d',' ','v','a','r',' ','p','o','i','n','t','e','r',' ',' ',
 'e','m','p','t','y',' ','e','x','p','r','e','s','s','i','o','n',' ',' ',' ',' ',' ',
 'n','a','m','e',' ','c','o','n','f','l','i','c','t',' ',' ',' ',' ',' ',' ',' ',' ',
 'i','n','v','a','l','i','d',' ','o','p','r',' ','p','r','i','o','r','i','t','y',' ',
 'd','o','m','a','i','n',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
 'd','i','v','i','s','i','o','n',' ','b','y',' ','z','e','r','o',' ',' ',' ',' ',' ',
 'g','e','n','e','r','i','c',' ','m','u','p','a','r','s','e','r',' ',' ',' ',' ',' ',
 'l','o','c','a','l','e',' ','c','o','n','f','l','i','c','t',' ',' ',' ',' ',' ',' ',
 'u','n','e','x','p',' ','c','o','n','d','i','t','i','o','n','a','l',' ',' ',' ',' ',
 'm','i','s','s','i','n','g',' ','e','l','s','e',' ','c','l','a','u','s','e',' ',' ',
 'm','i','s','p','l','a','c','e','d',' ','c','o','l','o','n',' ',' ',' ',' ',' ',' ',
 'i','n','t','e','r','n','a','l',' ','m','u','p','a','r','s','e','r',' ',' ',' ',' ',
};



















