/*
  HI65 - a high-level Commodore 65 emulator
  Copyright (C) 2013-2023  Simone Gremmo
  Contact: devilmaster@email.com

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see
  http://www.gnu.org/licenses/gpl.txt
*/

#include <allegro.h>
#include <cstdio>
#include "f8x8.h"
#include "gdef.h"
#include "pro.h"
#include "var.h"

uchar load(uchar *str)
{
 /* uint i,j,k,q;
 int c; */
 uint i;
 size_t actual_size;
 FILE *pFile;
 
 // The whole program memory is set to 0 just before loading the program
 for (i=0; i<PROGRAMSIZE; i++)
  program[i]=0;
 
 pFile=fopen ((const char *) str,"rb"); // reads from a binary file
 if (!pFile)
  return 1;
 else
 {
  actual_size=fread((void*)program,sizeof(unsigned char),PROGRAMSIZE,pFile);
  fclose (pFile);
  return 0;
 }
}

void fprints(uchar *str) // it saves strings to a file
{
 uchar c;
 
 FILE *pFile;
 
 pFile = fopen ("c65log.txt","a");
 while ((c=*str++)!=0)
  fputc (c,pFile);
 fclose (pFile);
}

void fEnter(void)
{
 FILE *pFile;
 
 pFile = fopen ("c65log.txt","a");
 fputc(13,pFile);
 fputc(10,pFile);
 fclose (pFile);
}

void fprintn(uint number) // it saves integer numbers to a file
{
 uchar asciinumber[50];
 uchar i,howmanydigits;
 
 FILE *pFile;
 
 for (i=0; i<50; i++)
  asciinumber[i]=' ';

 howmanydigits=sprintf((char *)asciinumber,"%d",number);
 pFile = fopen ("c65log.txt","a");
 for (i=0; i<howmanydigits; i++)
 {
  if (asciinumber[i]!=' ')
   asciinumber[i]-=160;
  fputc (asciinumber[i],pFile);
 }
 fclose (pFile);
}

void setresolution(void)
{
 size_t actual_size;
 FILE *pFile;
#ifdef DEBUG_SCREEN
#else
 uchar cfgarray[3];
#endif
 
 pFile=fopen ("hi65.cfg","rb");
 
 // If the configuration file is missing, we create one with default
 // settings. Then we can read it.
 if (!pFile)
 {
  pFile=fopen ("hi65.cfg","a"); // open for append
  fputc(0,pFile); // 640*400
  fputc(0,pFile); // windowed
  fputc(0,pFile); // MuParser disabled
  fclose (pFile);
  pFile=fopen ("hi65.cfg","rb"); // open for read, binary
 }
 
 actual_size=fread((void*)cfgarray,sizeof(unsigned char),3,pFile);
 fclose (pFile);
 
 switch(cfgarray[0])
 {
  // NOTE: resolutions like 320x200 are useless, because the C65 line
  // mode has an X resolution of 640 pixels. For the same reason, a
  // resolution of 1024x768 is not included, because 1024 is not a
  // multiple of 640
  case 0: screen_width=640;
          screen_height=400;
          screen_border_x=screen_border_y=0;
          break;
  case 1: screen_width=640;
          screen_height=480;
          screen_border_x=0;
          screen_border_y=40;
          break;
  case 2: screen_width=800;
          screen_height=600;
          screen_border_x=80;
          screen_border_y=60;
          break;
  case 3: screen_width=1280;
          screen_height=720;
          screen_border_x=screen_border_y=0;
          break;
  case 4: screen_width=1280;
          screen_height=800;
          screen_border_x=screen_border_y=0;
          break;
  case 5: screen_width=1360;
          screen_height=768;
          screen_border_x=40;
          screen_border_y=0;
          break;
  case 6: screen_width=1440;
          screen_height=900;
          screen_border_x=80;
          screen_border_y=50;
          break;
  case 7: screen_width=1600;
          screen_height=900;
          screen_border_x=160;
          screen_border_y=50;
          break;
  case 8: screen_width=1920;
          screen_height=1080;
          screen_border_x=screen_border_x=0;
          break;
 }
 if (program_loaded_from_frontend)
  // For some reason, Hi65 won't run windowed when launched from the frontend,
  // this is an additional safety measure
  // (ALSO FORCED FULLSCREEN IN THE FRONTEND)
  fullscreen=1;
 else
  fullscreen=cfgarray[1];
 enable_muparser=cfgarray[2];
}


