VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form Form1 
   Caption         =   "Hi65 Edit and Launch Tool"
   ClientHeight    =   7605
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   10680
   Icon            =   "hi65_frontend.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   7605
   ScaleWidth      =   10680
   StartUpPosition =   3  'Windows Default
   Begin VB.CheckBox chkMuParser 
      Caption         =   "Use MuParser"
      Height          =   195
      Left            =   7080
      TabIndex        =   9
      Top             =   0
      Width           =   1335
   End
   Begin VB.TextBox txtMain 
      BackColor       =   &H00FFFFFF&
      BeginProperty Font 
         Name            =   "Lucida Console"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000000&
      Height          =   6855
      Left            =   0
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   8
      Top             =   720
      Width           =   10695
   End
   Begin VB.ComboBox Combo2 
      Height          =   315
      ItemData        =   "hi65_frontend.frx":000C
      Left            =   3960
      List            =   "hi65_frontend.frx":000E
      Style           =   2  'Dropdown List
      TabIndex        =   7
      Top             =   360
      Width           =   3015
   End
   Begin VB.ComboBox Combo1 
      Height          =   315
      ItemData        =   "hi65_frontend.frx":0010
      Left            =   3960
      List            =   "hi65_frontend.frx":0012
      Style           =   2  'Dropdown List
      TabIndex        =   6
      Top             =   0
      Width           =   3015
   End
   Begin VB.CommandButton cmdLaunchWithCurrent 
      Height          =   615
      Left            =   3240
      Picture         =   "hi65_frontend.frx":0014
      Style           =   1  'Graphical
      TabIndex        =   5
      ToolTipText     =   "Launch hi65 with current program"
      Top             =   0
      Width           =   615
   End
   Begin VB.CommandButton cmdOpenAndLaunch 
      Height          =   615
      Left            =   2640
      Picture         =   "hi65_frontend.frx":0C56
      Style           =   1  'Graphical
      TabIndex        =   4
      ToolTipText     =   "Select .PRG and launch hi65"
      Top             =   0
      Width           =   615
   End
   Begin VB.CommandButton cmdopenAndTokenize 
      Height          =   615
      Left            =   2040
      Picture         =   "hi65_frontend.frx":1098
      Style           =   1  'Graphical
      TabIndex        =   3
      ToolTipText     =   "Open .TXT and tokenize into .PRG"
      Top             =   0
      Width           =   615
   End
   Begin VB.CommandButton cmdSave 
      Height          =   615
      Left            =   1320
      Picture         =   "hi65_frontend.frx":14DA
      Style           =   1  'Graphical
      TabIndex        =   2
      ToolTipText     =   "Save .TXT and tokenize into .PRG"
      Top             =   0
      Width           =   615
   End
   Begin VB.CommandButton cmdOpen 
      Height          =   615
      Left            =   720
      Picture         =   "hi65_frontend.frx":191C
      Style           =   1  'Graphical
      TabIndex        =   1
      ToolTipText     =   "Open .TXT"
      Top             =   0
      Width           =   615
   End
   Begin VB.CommandButton cmdNew 
      Height          =   615
      Left            =   120
      Picture         =   "hi65_frontend.frx":1D5E
      Style           =   1  'Graphical
      TabIndex        =   0
      ToolTipText     =   "New .TXT"
      Top             =   0
      Width           =   615
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   10080
      Top             =   120
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      CancelError     =   -1  'True
   End
   Begin VB.Label Label1 
      Caption         =   "Welcome!"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   7080
      TabIndex        =   10
      Top             =   240
      Width           =   2775
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileNew 
         Caption         =   "&New .TXT..."
         Shortcut        =   ^N
      End
      Begin VB.Menu mnuFileOpen 
         Caption         =   "&Open .TXT..."
         Shortcut        =   ^{F12}
      End
      Begin VB.Menu mnuFileSaveAndTokenize 
         Caption         =   "&Save .TXT and tokenize into .PRG"
         Shortcut        =   +{F12}
      End
      Begin VB.Menu mnuFileSaveAsAndTokenize 
         Caption         =   "&Save .TXT as... and tokenize into .PRG"
      End
      Begin VB.Menu mnuFileBar1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileopenAndTokenize 
         Caption         =   "&Open .TXT and tokenize into .PRG"
      End
      Begin VB.Menu mnuFileOpenAndLaunch 
         Caption         =   "&Select .PRG and launch emulator"
      End
      Begin VB.Menu mnuFileLaunchWithCurrent 
         Caption         =   "&Launch emulator with current program"
      End
      Begin VB.Menu mnuFilebar2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "&Exit"
      End
   End
   Begin VB.Menu mnuPaths 
      Caption         =   "&Paths"
      Begin VB.Menu mnuPathsHi65 
         Caption         =   "&Set path for Hi65"
      End
      Begin VB.Menu mnuPathsVICE 
         Caption         =   "&Set path for VICE"
      End
      Begin VB.Menu mnuPathsbar1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuPathsHi65Current 
         Caption         =   "&Hi65 resides in frontend directory"
         Checked         =   -1  'True
      End
      Begin VB.Menu mnuPathsVICECurrent 
         Caption         =   "&VICE resides in frontend directory"
         Checked         =   -1  'True
      End
   End
   Begin VB.Menu mnuEditor 
      Caption         =   "&Editor"
      Begin VB.Menu mnuEditorFont 
         Caption         =   "&Font"
      End
      Begin VB.Menu mnuColor 
         Caption         =   "&Color"
         Begin VB.Menu mnuColorText 
            Caption         =   "&Text"
         End
         Begin VB.Menu mnuColorBackground 
            Caption         =   "&Baclground"
         End
      End
      Begin VB.Menu mnuEditorSyntax 
         Caption         =   "&Syntax highlighting"
         Enabled         =   0   'False
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&?"
      Begin VB.Menu mnuHelpAbout 
         Caption         =   "&About Hi65 Edit and Launch Tool"
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Public quiet As Boolean
Public resolution As Byte
Public fullscreen As Byte
Public muparser As Byte
Public buffer As String
Public appname As String
Public sourcename As String
Public emulator As String
Public hi65path As String
Public vicepath As String
Public eversavedanything As Boolean
Public leftprop As Single
Public widthprop As Single
Public heightprop As Single

Private Sub chkMuParser_Click()
    If quiet = False Then
        muparser = chkMuParser.Value
        If muparser = 0 Then Label1.Caption = "MuParser disabled." Else Label1.Caption = "MuParser enabled."
        Open App.Path + "\hi65.cfg" For Binary As #1
        Put #1, 1, Combo1.ListIndex
        'If (Option1 = True) Then Put #1, 2, 1 Else Put #1, 2, 0
        Put #1, 2, 1 'the frontend forces Hi65 configuration to full screen mode, ALSO FORCED FULL SCREEN IN HI65.EXE
        Put #1, 3, muparser
        Close #1
    End If
End Sub

Private Sub cmdNew_Click()
    NewTxt
End Sub

Private Sub cmdOpen_Click()
    OpenTxt
End Sub

Private Sub cmdSave_Click()
    SaveTxt (False)
    TokenizeTxt
End Sub

Private Sub cmdopenAndTokenize_Click()
    OpenTxt
    TokenizeTxt
End Sub

Private Sub cmdOpenAndLaunch_Click()
    OpenPrgLaunchEmulator
End Sub

Private Sub cmdLaunchWithCurrent_Click()
    LaunchWithCurrent
End Sub

Private Sub Combo2_Click()
    Select Case Combo2.ListIndex
        Case "0"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\pet.bmp")
            emulator = "xpet"
        Case "1"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "2"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\vic.bmp")
            emulator = "xvic"
        Case "3"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\vic.bmp")
            emulator = "xvic"
        Case "4"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\vic.bmp")
            emulator = "xvic"
        Case "5"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "6"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "7"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "8"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "9"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "10"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "11"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "12"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "13"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "14"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "15"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "16"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "17"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "18"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "19"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\vic.bmp")
            emulator = "xvic"
        Case "20"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "21"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "22"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "23"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "24"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\vic.bmp")
            emulator = "xvic"
        Case "25"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "26"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "27"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\64.bmp")
            emulator = "x64"
        Case "28"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\vic.bmp")
            emulator = "xvic"
        Case "29"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\pet.bmp")
            emulator = "xpet"
        Case "30"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\vic.bmp")
            emulator = "xvic"
        Case "31"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\16.bmp")
            emulator = "xplus4"
        Case "32"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\128.bmp")
            emulator = "x128"
        Case "33"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\128.bmp")
            emulator = "x128"
        Case "34"
            cmdLaunchWithCurrent.Picture = LoadPicture(App.Path + "\65.bmp")
            emulator = "hi65"
    End Select
    
    cmdOpenAndLaunch.ToolTipText = "Select .PRG and launch " + emulator
    cmdLaunchWithCurrent.ToolTipText = "Launch " + emulator + " with current program"
End Sub

Private Sub mnuColorBackground_Click()
    CommonDialog1.CancelError = True
    On Error Resume Next
    CommonDialog1.Color = txtMain.BackColor
    
    CommonDialog1.ShowColor
    If Err.Number = cdlCancel Then
        Exit Sub
    ElseIf Err.Number <> 0 Then
        MsgBox "Error " & Format$(Err.Number) & " selecting color." & vbCrLf & Err.Description
        Exit Sub
    End If

    txtMain.BackColor = CommonDialog1.Color
    SaveIni
End Sub

Private Sub mnuColorText_Click()
    CommonDialog1.CancelError = True
    On Error Resume Next
    CommonDialog1.Color = txtMain.ForeColor
    
    CommonDialog1.ShowColor
    If Err.Number = cdlCancel Then
        Exit Sub
    ElseIf Err.Number <> 0 Then
        MsgBox "Error " & Format$(Err.Number) & " selecting color." & vbCrLf & Err.Description
        Exit Sub
    End If

    txtMain.ForeColor = CommonDialog1.Color
    SaveIni
End Sub

Private Sub mnuEditorFont_Click()
    CommonDialog1.CancelError = True
    On Error Resume Next
    CommonDialog1.FontName = txtMain.Font.Name
    CommonDialog1.FontSize = txtMain.Font.Size
    CommonDialog1.FontBold = txtMain.Font.Bold
    CommonDialog1.FontItalic = txtMain.Font.Italic
    CommonDialog1.Flags = cdlCFBoth
    
    CommonDialog1.ShowFont
    If Err.Number = cdlCancel Then
        Exit Sub
    ElseIf Err.Number <> 0 Then
        MsgBox "Error " & Format$(Err.Number) & " selecting font." & vbCrLf & Err.Description
        Exit Sub
    End If
    
    txtMain.Font.Name = CommonDialog1.FontName
    txtMain.Font.Size = CommonDialog1.FontSize
    txtMain.Font.Bold = CommonDialog1.FontBold
    txtMain.Font.Italic = CommonDialog1.FontItalic
    SaveIni
End Sub

Private Sub mnuFileNew_Click()
    NewTxt
End Sub

Private Sub mnuFileOpen_Click()
    OpenTxt
End Sub

Private Sub mnuFileSaveAndTokenize_Click()
    SaveTxt (False)
    TokenizeTxt
End Sub

Private Sub mnuFileSaveAsAndTokenize_Click()
    SaveTxt (True)
    TokenizeTxt
End Sub

Private Sub mnuFileopenAndTokenize_Click()
    OpenTxt
    TokenizeTxt
End Sub

Private Sub mnuFileOpenAndLaunch_Click()
    OpenPrgLaunchEmulator
End Sub

Private Sub Combo1_Click()
    If quiet = False Then
        Open App.Path + "\hi65.cfg" For Binary As #1
        Put #1, 1, Combo1.ListIndex
        'If (Option1 = True) Then Put #1, 2, 1 Else Put #1, 2, 0
        Put #1, 2, 1 'the frontend forces Hi65 configuration to full screen mode, ALSO FORCED FULL SCREEN IN HI65.EXE
        Put #1, 3, chkMuParser.Value
        Close #1
        Label1.Caption = "Resolution changed."
    End If
End Sub

Private Sub Option1_Click()
    Open App.Path + "\hi65.cfg" For Binary As #1
    Put #1, 1, Combo1.ListIndex
    'If (Option1 = True) Then Put #1, 2, 1 Else Put #1, 2, 0
    Put #1, 2, 1 'the frontend forces Hi65 configuration to full screen mode, ALSO FORCED FULL SCREEN IN HI65.EXE
    Put #1, 3, muparser
    Close #1
    Label1.Caption = "Video mode: full screen"
End Sub

Private Sub Option2_Click()
    Open App.Path + "\hi65.cfg" For Binary As #1
    Put #1, 1, Combo1.ListIndex
    'If (Option1 = True) Then Put #1, 2, 1 Else Put #1, 2, 0
    Put #1, 2, 1 'the frontend forces Hi65 configuration to full screen mode, ALSO FORCED FULL SCREEN IN HI65.EXE
    Put #1, 3, muparser
    Close #1
    Label1.Caption = "Video mode: windowed"
End Sub

Private Sub Form_Load()
    On Error Resume Next
    

    
    appname = "Hi65 Edit and Launch Tool"
    sourcename = "_program.txt"
    Form1.Caption = sourcename + " - " + appname
    eversavedanything = False
    
    CommonDialog1.InitDir = App.Path
    CommonDialog1.FilterIndex = 1
    CommonDialog1.Flags = _
        cdlOFNFileMustExist + _
        cdlOFNHideReadOnly + _
        cdlOFNLongNames + _
        cdlOFNExplorer
    CommonDialog1.CancelError = True
    
    quiet = True
    Combo1.AddItem "640 x 400 (16:10)"
    Combo1.AddItem "640 x 480 (4:3)"
    Combo1.AddItem "800 x 600 (4:3)"
    Combo1.AddItem "1280 x 720 (16:9)"
    Combo1.AddItem "1280 x 800 (16:10)"
    Combo1.AddItem "1360 x 768 (16:9)"
    Combo1.AddItem "1440 x 900 (16:10)"
    Combo1.AddItem "1600 x 900 (16:9)"
    Combo1.AddItem "1920 x 1080 (16:9)"
    
    Open App.Path + "\hi65.cfg" For Binary As #1
    Get #1, 1, resolution
    Get #1, 2, fullscreen
    Get #1, 3, muparser
    Close #1
    Combo1.ListIndex = resolution
    chkMuParser.Value = muparser
    If (fullscreen = 1) Then Option1 = True Else Option2 = True
    quiet = False
    
    Combo2.AddItem "PET Basic V1.0"
    Combo2.AddItem "Basic v2.0"
    Combo2.AddItem "Basic v2.0 with Super Expander"
    Combo2.AddItem "Basic v2.0 with Turtle Basic"
    Combo2.AddItem "Basic v2.0 with Mighty Basic"
    Combo2.AddItem "Basic v2.0 with AtBasic"
    Combo2.AddItem "Basic v2.0 with Simons' Basic"
    Combo2.AddItem "Basic v2.0 with Speech Basic v2.7"
    Combo2.AddItem "Basic v2.0 with Final Cartridge III"
    Combo2.AddItem "Basic v2.0 with Ultrabasic-64"
    Combo2.AddItem "Basic v2.0 with Graphics basic"
    Combo2.AddItem "Basic v2.0 with WS basic"
    Combo2.AddItem "Basic v2.0 with WS basic final"
    Combo2.AddItem "Basic v2.0 with Pegasus basic 4.0"
    Combo2.AddItem "Basic v2.0 with Xbasic"
    Combo2.AddItem "Basic v2.0 with Drago basic 2.2"
    Combo2.AddItem "Basic v2.0 with REU-basic"
    Combo2.AddItem "Basic v2.0 with Basic Lightning"
    Combo2.AddItem "Basic v2.0 with Magic Basic"
    Combo2.AddItem "Basic v2.0 with Easy Basic"
    Combo2.AddItem "Basic v2.0 with Blarg"
    Combo2.AddItem "Basic v2.0 with Game Basic"
    Combo2.AddItem "Basic v2.0 with Basex"
    Combo2.AddItem "Basic v2.0 with Super Basic"
    Combo2.AddItem "Basic 2.0 with Expanded Basic(VIC20)"
    Combo2.AddItem "Basic 2.0 with Expanded Basic(C64)"
    Combo2.AddItem "Basic 2.0 with Super Expander Chip"
    Combo2.AddItem "Basic 2.0 with Warsaw Basic"
    Combo2.AddItem "Basic 2.0 with Basic 4.0 extensions"
    Combo2.AddItem "PET Basic v4.0"
    Combo2.AddItem "Basic 2.0 with Basic 5.0 extensions"
    Combo2.AddItem "Basic v3.5"
    Combo2.AddItem "Basic v7.0"
    Combo2.AddItem "Basic v7.1"
    Combo2.AddItem "Basic v10.0 (C65)"
    Combo2.ListIndex = 34
    
    leftprop = txtMain.Left / ScaleWidth
    widthprop = txtMain.Width / ScaleWidth

    Open App.Path + "\paths.ini" For Input As #2
    Input #2, hi65path, vicepath, tmpfontname, tmpfontsize, tmpfontbold
    If tmpfontbold <> "True" And tmpfontbolt <> "False" Then Input #2, tmpfontbold
    Input #2, tmpfontitalic, tmpforecolor, tmpbackcolor
    Close #2
    txtMain.Font.Name = tmpfontname
    txtMain.Font.Size = tmpfontsize
    txtMain.Font.Bold = tmpfontbold
    txtMain.Font.Italic = tmpfontitalic
    txtMain.ForeColor = tmpforecolor
    txtMain.BackColor = tmpbackcolor
    If hi65path = "*" Then
        hi65path = ""
        mnuPathsHi65.Enabled = False
        mnuPathsHi65Current.Checked = True
    Else
        mnuPathsHi65.Enabled = True
        mnuPathsHi65Current.Checked = False
    End If
    If vicepath = "*" Then
        vicepath = ""
        mnuPathsVICE.Enabled = False
        mnuPathsVICECurrent.Checked = True
    Else
        mnuPathsVICE.Enabled = True
        mnuPathsVICECurrent.Checked = False
    End If
        
    Open App.Path + "\hi65.cfg" For Binary As #1
    Put #1, 1, Combo1.ListIndex
    'If (Option1 = True) Then Put #1, 2, 1 Else Put #1, 2, 0
    Put #1, 2, 1 'the frontend forces Hi65 configuration to full screen mode, ALSO FORCED FULL SCREEN IN HI65.EXE
    Put #1, 3, muparser
    Close #1
    Label1.Caption = "Welcome!"
End Sub
Private Function CheckUnsavedTxt() As Integer
    Dim intAnswer As Integer
    
    If txtMain.Text <> buffer Then
        intAnswer = MsgBox("Save " + sourcename + "?", vbYesNoCancel + vbExclamation + vbDefaultButton1, appname)
        If intAnswer = vbYes Then SaveTxt (False)
        CheckUnsavedTxt = intAnswer
    End If
End Function

Private Sub NewTxt()
    If CheckUnsavedTxt = vbCancel Then Exit Sub
    
    txtMain.Text = ""
    buffer = txtMain.Text
    eversavedanything = False
End Sub

Private Sub OpenTxt()
    On Error Resume Next
    
    If CheckUnsavedTxt = vbCancel Then Exit Sub
    
    CommonDialog1.DialogTitle = "Open File"
    CommonDialog1.FileName = ""
    Label1.Caption = "Select .txt file to edit"
    CommonDialog1.Filter = "Text files (*.txt)|*.txt|All Files (*.*)|*.*"
    CommonDialog1.ShowOpen
    If Err.Number = cdlCancel Then
        ' The user canceled.
        Label1.Caption = "You selected Cancel."
        Exit Sub
    ElseIf Err.Number <> 0 Then
        ' Unknown error.
        MsgBox "Error " + Format$(Err.Number) + _
            " selecting file." + vbCrLf + _
            Err.Description
        Label1.Caption = "Something went wrong."
        Exit Sub
    End If
    
    Open CommonDialog1.FileName For Input As #1
    txtMain.Text = ""
    txtMain.Text = Input$(LOF(1), 1)
    buffer = txtMain.Text
    sourcename = CommonDialog1.FileName
    Form1.Caption = sourcename + " - " + appname
    Close #1
    eversavedanything = True
    ChDir App.Path
End Sub

Public Sub SaveTxt(ByRef saveas As Boolean)
    On Error Resume Next
    
    If eversavedanything = False Then
        saveas = True
        eversavedanything = True
    End If
    
    If saveas = True Then
        CommonDialog1.DialogTitle = "Save File"
        CommonDialog1.FileName = ""
        Label1.Caption = "Enter name for .txt file"
        CommonDialog1.Filter = "Text files (*.txt)|*.txt|All Files (*.*)|*.*"
        CommonDialog1.ShowSave
        If Err.Number = cdlCancel Then
            ' The user canceled.
            Label1.Caption = "You selected Cancel."
            Exit Sub
        ElseIf Err.Number <> 0 Then
            ' Unknown error.
            MsgBox "Error " + Format$(Err.Number) + _
                " selecting file." + vbCrLf + _
                Err.Description
            Label1.Caption = "Something went wrong."
            Exit Sub
        Else
            'The user has selected a file
            sourcename = CommonDialog1.FileName
        End If
    End If
    
    'Now we do the actual saving
    Open sourcename For Output As #1
    Print #1, txtMain
    Close #1
    buffer = txtMain.Text
    Form1.Caption = sourcename + " - " + appname
    ChDir App.Path
End Sub

Private Sub TokenizeTxt()
    'Launch Petcat and tokenize the file
    Select Case Combo2.ListIndex
        Case "0"
            basicversion = "1"
        Case "1"
            basicversion = "2"
        Case "2"
            basicversion = "superexp"
        Case "3"
            basicversion = "turtle"
        Case "4"
            basicversion = "mighty"
        Case "5"
            basicversion = "a"
        Case "6"
            basicversion = "simon"
        Case "7"
            basicversion = "speech"
        Case "8"
            basicversion = "F"
        Case "9"
            basicversion = "ultra"
        Case "10"
            basicversion = "graph"
        Case "11"
            basicversion = "WSB"
        Case "12"
            basicversion = "WSBF"
        Case "13"
            basicversion = "Pegasus"
        Case "14"
            basicversion = "Xbasic"
        Case "15"
            basicversion = "Drago"
        Case "16"
            basicversion = "REU"
        Case "17"
            basicversion = "Lightning"
        Case "18"
            basicversion = "magic"
        Case "19"
            basicversion = "easy"
        Case "20"
            basicversion = "blarg"
        Case "21"
            basicversion = "Game"
        Case "22"
            basicversion = "BSX"
        Case "23"
            basicversion = "superbas"
        Case "24"
            basicversion = "exp20"
        Case "25"
            basicversion = "exp64"
        Case "26"
            basicversion = "sxc"
        Case "27"
            basicversion = "warsaw"
        Case "28"
            basicversion = "4v"
        Case "29"
            basicversion = "4 -w4e"
        Case "30"
            basicversion = "5"
        Case "31"
            basicversion = "3"
        Case "32"
            basicversion = "70"
        Case "33"
            basicversion = "71"
        Case "34"
            basicversion = "10"
    End Select
    Err.Number = 0
    commandline = "petcat.exe -w" + basicversion + " -o " + Chr$(34) + Left(sourcename, Len(sourcename) - 3) + "prg" + Chr$(34) + " -- " + Chr$(34) + sourcename + Chr$(34)
    Shell commandline
    If Err.Number = 53 Then
        MsgBox "Warning: petcat.exe not found." + vbCrLf + "Please check installation directory.", vbOKOnly + vbExclamation, appname
        Label1.Caption = "The file has NOT been tokenized."
        Exit Sub
    End If
    Label1.Caption = "The file has been tokenized."
End Sub

Private Sub LaunchEmulator(ByVal launchedwithcurrent As Boolean)
    Dim prgname As String
            
    On Error Resume Next
    
    'Launch Hi65 with the selected BASIC 10 program
    '(the silly text at the end is a string that is very unlikely to be typed by accident)
    If (CommonDialog1.FileName = "" Or sourcename = "_program.txt") And launchedwithcurrent = True Then prgname = "_program.prg" Else prgname = CommonDialog1.FileName
    If Right(prgname, 3) <> "prg" Then prgname = Mid(prgname, 1, Len(prgname) - 3) + "prg"
    Err.Number = 0
    If emulator = "hi65" Then
        Open App.Path + "\hi65.cfg" For Binary As #1
        Put #1, 1, Combo1.ListIndex
        'If (Option1 = True) Then Put #1, 2, 1 Else Put #1, 2, 0
        Put #1, 2, 1 'the frontend forces Hi65 configuration to full screen mode, ALSO FORCED FULL SCREEN IN HI65.EXE
        Put #1, 3, muparser
        Close #1
        commandline = hi65path + emulator + " " + prgname + " recognition_code_927_i_am_a_potato" + vbCrLf
    Else
        commandline = vicepath + emulator + " " + prgname
    End If
    Label1.Caption = "Starting " + emulator + "..."
    Shell commandline
    If Err.Number = 53 Then MsgBox "Warning: " + emulator + ".exe not found." + vbCrLf + "Please check installation directory.", vbOKOnly + vbExclamation, appname
End Sub

Private Sub OpenPrgLaunchEmulator()
    On Error Resume Next
    
    CommonDialog1.FileName = ""
    Label1.Caption = "Select .prg file to run"
    CommonDialog1.Filter = "Tokenized BASIC 10 files (*.prg)|*.prg|All Files (*.*)|*.*"
    CommonDialog1.ShowOpen
    If Err.Number = cdlCancel Then
        ' The user canceled.
        Label1.Caption = "You selected Cancel."
        Exit Sub
    ElseIf Err.Number <> 0 Then
        ' Unknown error.
        MsgBox "Error " + Format$(Err.Number) + _
            " selecting file." + vbCrLf + _
            Err.Description
        Label1.Caption = "Something went wrong."
        Exit Sub
    End If
    LaunchEmulator (False)
    ChDir App.Path
End Sub

Private Sub LaunchWithCurrent()
    Dim bakname As String
    
    bakname = sourcename
    If txtMain.Text <> buffer Then sourcename = "_program.txt"
    
    Open sourcename For Output As #1
    Print #1, txtMain
    Close #1
    
    TokenizeTxt
    LaunchEmulator (True)
    
    If sourcename = "_program.txt" Then sourcename = bakname
End Sub

Private Sub mnuHelpAbout_Click()
    MsgBox "Hi65 (c) 2013-2023 Devil Master" + vbCrLf + _
    "Hi65 Edit and Launch Tool (c) 2013-2023 Devil Master" + vbCrLf + vbCrLf + _
    "https://devilmaster.altervista.org", vbOKOnly + vbInformation, appname
End Sub

Private Sub Form_Resize()
    If ScaleWidth > 0 Then txtMain.Move leftprop * ScaleWidth, 700, widthprop * ScaleWidth, Form1.Height - 1600
End Sub

Private Sub mnuPathsHi65_Click()
    On Error Resume Next
        
    CommonDialog1.DialogTitle = "Find and select Hi65.exe"
    CommonDialog1.FileName = ""
    Label1.Caption = "Find and select Hi65.exe"
    CommonDialog1.Filter = "Executables (*.exe)|*.exe|All Files (*.*)|*.*"
    CommonDialog1.ShowOpen
    If Err.Number = cdlCancel Then
        ' The user canceled.
        Label1.Caption = "You selected Cancel."
        Exit Sub
    ElseIf Err.Number <> 0 Then
        ' Unknown error.
        MsgBox "Error " + Format$(Err.Number) + _
            " selecting file." + vbCrLf + _
            Err.Description
        Label1.Caption = "Something went wrong."
        Exit Sub
    End If
    ChDir App.Path
    hi65path = CommonDialog1.FileName
    While Right(hi65path, 1) <> "\"
        hi65path = Left(hi65path, Len(hi65path) - 1)
    Wend
    Label1.Caption = "Hi65 path changed to " + hi65path
    SaveIni
End Sub

Private Sub mnuPathsHi65Current_Click()
    mnuPathsHi65.Enabled = Not (mnuPathsHi65.Enabled)
    mnuPathsHi65Current.Checked = Not (mnuPathsHi65Current.Checked)
    
    If mnuPathsHi65Current.Checked = True Then
        hi65path = ""
        Label1.Caption = "Hi65 path changed to current directory."
    Else
        mnuPathsHi65_Click
    End If
    SaveIni
End Sub

Private Sub mnuPathsVICE_Click()
    On Error Resume Next
        
    CommonDialog1.DialogTitle = "Find and select any executable from VICE"
    CommonDialog1.FileName = ""
    Label1.Caption = "Find and select any executable from VICE"
    CommonDialog1.Filter = "Executables (*.exe)|*.exe|All Files (*.*)|*.*"
    CommonDialog1.ShowOpen
    If Err.Number = cdlCancel Then
        ' The user canceled.
        Label1.Caption = "You selected Cancel."
        Exit Sub
    ElseIf Err.Number <> 0 Then
        ' Unknown error.
        MsgBox "Error " + Format$(Err.Number) + _
            " selecting file." + vbCrLf + _
            Err.Description
        Label1.Caption = "Something went wrong."
        Exit Sub
    End If
    ChDir App.Path
    vicepath = CommonDialog1.FileName
    While Right(vicepath, 1) <> "\"
        vicepath = Left(vicepath, Len(vicepath) - 1)
    Wend
    Label1.Caption = "VICE path changed to " + vicepath
    SaveIni
End Sub

Private Sub mnuPathsVICECurrent_Click()
    mnuPathsVICE.Enabled = Not (mnuPathsVICE.Enabled)
    mnuPathsVICECurrent.Checked = Not (mnuPathsVICECurrent.Checked)
    
    If mnuPathsVICECurrent.Checked = True Then
        vicepath = ""
        Label1.Caption = "VICE path changed to current directory."
    Else
        mnuPathsVICE_Click
    End If
    SaveIni
End Sub

Private Sub SaveIni()
    If hi65path = "" Then hi65path = "*"
    If vicepath = "" Then vicepath = "*"
    Open App.Path + "\paths.ini" For Output As #2
    Print #2, hi65path
    Close #2
    Open App.Path + "\paths.ini" For Append As #2
    Print #2, vicepath
    Print #2, txtMain.Font.Name
    Print #2, txtMain.Font.Size
    Print #2, txtMain.Font.Bold
    Print #2, txtMain.Font.Italic
    Print #2, txtMain.ForeColor
    Print #2, txtMain.BackColor
    Close #2
    If hi65path = "*" Then hi65path = ""
    If vicepath = "*" Then vicepath = ""
End Sub
