/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.common;

import info.msxlaunchers.openmsx.common.Utils;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public final class FileTypeUtils {
    private static final Set<String> romExtensions = FileTypeUtils.getUnmodifiableSet("ri", "rom", "col");
    private static final Set<String> diskExtensions = FileTypeUtils.getUnmodifiableSet("di1", "di2", "dmk", "dsk", "xsa");
    private static final Set<String> tapeExtensions = FileTypeUtils.getUnmodifiableSet("cas", "wav", "tsx");
    private static final Set<String> harddiskExtensions = FileTypeUtils.getUnmodifiableSet("dsk", "hdd");
    private static final Set<String> laserdiscExtensions = FileTypeUtils.getUnmodifiableSet("ogv");
    private static final Set<String> zipExtensions = FileTypeUtils.getUnmodifiableSet("zip", "gz");
    private static final Set<String> xmlExtension = FileTypeUtils.getUnmodifiableSet("xml");
    private static final Set<String> patchExtensions = FileTypeUtils.getUnmodifiableSet("ips", "ups");
    private static final Set<String> lhaExtensions = FileTypeUtils.getUnmodifiableSet("lha", "lzh");
    public static final long MAX_DISK_FILE_SIZE = 737280L;

    public static boolean isROM(File file) {
        return FileTypeUtils.isType(file, romExtensions);
    }

    public static boolean isDisk(File file) {
        return FileTypeUtils.isType(file, diskExtensions);
    }

    public static boolean isTape(File file) {
        return FileTypeUtils.isType(file, tapeExtensions);
    }

    public static boolean isHarddisk(File file) {
        return FileTypeUtils.isType(file, harddiskExtensions);
    }

    public static boolean isLaserdisc(File file) {
        return FileTypeUtils.isType(file, laserdiscExtensions);
    }

    public static boolean isZIP(File file) {
        return FileTypeUtils.isType(file, zipExtensions);
    }

    public static boolean isXML(File file) {
        return FileTypeUtils.isType(file, xmlExtension);
    }

    public static boolean isPatch(File file) {
        return FileTypeUtils.isType(file, patchExtensions);
    }

    public static boolean isLHA(File file) {
        return FileTypeUtils.isType(file, lhaExtensions);
    }

    public static String getMainFile(String romA, String romB, String diskA, String diskB, String tape, String harddisk, String laserdisc, String script) {
        String mainFile = null;
        if (!Utils.isEmpty(romA)) {
            mainFile = romA;
        } else if (!Utils.isEmpty(romB)) {
            mainFile = romB;
        } else if (!Utils.isEmpty(diskA)) {
            mainFile = diskA;
        } else if (!Utils.isEmpty(diskB)) {
            mainFile = diskB;
        } else if (!Utils.isEmpty(tape)) {
            mainFile = tape;
        } else if (!Utils.isEmpty(harddisk)) {
            mainFile = harddisk;
        } else if (!Utils.isEmpty(laserdisc)) {
            mainFile = laserdisc;
        } else if (!Utils.isEmpty(script)) {
            mainFile = script;
        }
        return mainFile;
    }

    public static Set<String> getROMExtensions() {
        return romExtensions;
    }

    public static Set<String> getDiskExtensions() {
        return diskExtensions;
    }

    public static Set<String> getTapeExtensions() {
        return tapeExtensions;
    }

    public static Set<String> getHarddiskExtensions() {
        return harddiskExtensions;
    }

    public static Set<String> getLaserdiscExtensions() {
        return laserdiscExtensions;
    }

    public static Set<String> getZIPExtensions() {
        return zipExtensions;
    }

    public static Set<String> getPatchExtensions() {
        return patchExtensions;
    }

    public static Set<String> getLHAExtensions() {
        return lhaExtensions;
    }

    private static Set<String> getUnmodifiableSet(String ... extensions) {
        return Arrays.asList(extensions).stream().collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    private static boolean isType(File file, Set<String> validExtensions) {
        boolean isType = false;
        if (file == null || file.isDirectory()) {
            isType = false;
        } else {
            String filename = file.getName();
            String extension = filename.substring(filename.lastIndexOf(46) + 1).toLowerCase();
            isType = validExtensions.contains(extension);
        }
        return isType;
    }
}

