/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.common.version;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;

public final class VersionUtils {
    public static String getScreenshotsVersion(String screenshotsPath) {
        String screenshotsVersion = "";
        try {
            if (screenshotsPath != null) {
                Path path = FileSystems.getDefault().getPath(screenshotsPath, "version.txt");
                byte[] data = Files.readAllBytes(path);
                screenshotsVersion = new String(data).replace("\n", "").replace("\r", "");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return screenshotsVersion;
    }

    public static boolean isVersionNewer(String currentVersion, String newVersion) {
        boolean answer = false;
        if (currentVersion != null && newVersion != null) {
            String[] currentVersionDigits = currentVersion.split("\\.");
            String[] newVersionDigits = newVersion.split("\\.");
            boolean done = false;
            int counter = 0;
            try {
                while (!done) {
                    int newVersionInt;
                    int currentVersionInt;
                    if (currentVersionDigits.length > counter && newVersionDigits.length > counter) {
                        currentVersionInt = Integer.parseInt(currentVersionDigits[counter]);
                        newVersionInt = Integer.parseInt(newVersionDigits[counter]);
                        if (newVersionInt > currentVersionInt) {
                            answer = true;
                            done = true;
                            continue;
                        }
                        ++counter;
                        continue;
                    }
                    if (currentVersionDigits.length > counter && newVersionDigits.length == counter) {
                        currentVersionInt = Integer.parseInt(currentVersionDigits[counter]);
                        newVersionInt = 0;
                    } else if (currentVersionDigits.length == counter && newVersionDigits.length > counter) {
                        currentVersionInt = 0;
                        newVersionInt = Integer.parseInt(newVersionDigits[counter]);
                    } else {
                        currentVersionInt = 0;
                        newVersionInt = 0;
                    }
                    if (newVersionInt > currentVersionInt) {
                        answer = true;
                    }
                    done = true;
                }
            }
            catch (NumberFormatException nfe) {
                answer = false;
            }
        }
        return answer;
    }
}

