/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.extension;

import com.google.inject.Inject;
import info.msxlaunchers.openmsx.common.FileTypeUtils;
import info.msxlaunchers.openmsx.common.FileUtils;
import info.msxlaunchers.openmsx.extension.ExtensionLister;
import info.msxlaunchers.openmsx.launcher.data.settings.Settings;
import info.msxlaunchers.openmsx.launcher.persistence.settings.SettingsPersister;
import info.msxlaunchers.openmsx.machine.InvalidMachinesDirectoryException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

final class OpenMSXExtensionLister
implements ExtensionLister {
    private final SettingsPersister settingsPersister;
    private static final String HARDWARE_CONFIG_FILENAME = "hardwareconfig.xml";

    @Inject
    OpenMSXExtensionLister(SettingsPersister settingsPersister) {
        this.settingsPersister = Objects.requireNonNull(settingsPersister);
    }

    @Override
    public Set<String> get() throws InvalidMachinesDirectoryException, IOException {
        File[] fileList;
        Settings settings = this.settingsPersister.getSettings();
        HashSet<String> extensions = new HashSet<String>();
        String openMSXMachinesFullPath = settings.getOpenMSXMachinesFullPath();
        if (openMSXMachinesFullPath == null || !new File(openMSXMachinesFullPath).isDirectory()) {
            throw new InvalidMachinesDirectoryException();
        }
        File parentDirectory = new File(settings.getOpenMSXMachinesFullPath()).getParentFile();
        for (File directory : fileList = parentDirectory.listFiles()) {
            if (!directory.isDirectory() || !directory.getName().equals("extensions")) continue;
            for (File file : fileList = directory.listFiles()) {
                if (this.isValidOpenMSXExtensionFile(file)) {
                    extensions.add(FileUtils.getFileNameWithoutExtension(file));
                    continue;
                }
                if (!OpenMSXExtensionLister.isValidOpenMSXExtensionDirectory(file)) continue;
                extensions.add(file.getName());
            }
        }
        return Collections.unmodifiableSet(extensions);
    }

    private boolean isValidOpenMSXExtensionFile(File file) {
        return FileTypeUtils.isXML(file);
    }

    private static boolean isValidOpenMSXExtensionDirectory(File directory) {
        boolean valid = directory.isDirectory();
        if (valid) {
            File hardwareConfigFile = new File(directory, HARDWARE_CONFIG_FILENAME);
            valid = hardwareConfigFile.exists();
        }
        return valid;
    }
}

