/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.game.repository.processor;

import info.msxlaunchers.openmsx.game.repository.processor.ParseHandler;
import info.msxlaunchers.openmsx.game.repository.processor.StopSAXParsingException;
import info.msxlaunchers.openmsx.launcher.data.repository.RepositoryGame;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

final class GameInfoParseHandler
extends ParseHandler {
    private String code;
    private RepositoryGame repositoryGame;
    private String title;
    private String system;
    private String company;
    private String year;
    private String country;
    private boolean original;
    private String originalString;
    private String mapper;
    private String start;
    private String remark;
    private boolean found = false;

    GameInfoParseHandler(String code) {
        this.code = code;
    }

    public RepositoryGame getGameInfo() {
        return this.repositoryGame;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (qName.equalsIgnoreCase("original")) {
            this.original = attributes.getValue("value").equals("true");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String tempText = this.getNodeText();
        if (qName.equalsIgnoreCase("title")) {
            this.title = tempText;
        }
        if (qName.equalsIgnoreCase("system")) {
            this.system = tempText;
        } else if (qName.equalsIgnoreCase("company")) {
            this.company = tempText;
        } else if (qName.equalsIgnoreCase("year")) {
            this.year = tempText;
        } else if (qName.equalsIgnoreCase("country")) {
            this.country = tempText;
        } else if (qName.equalsIgnoreCase("original")) {
            this.originalString = tempText;
        } else if (qName.equalsIgnoreCase("type") || qName.equalsIgnoreCase("boot")) {
            this.mapper = tempText;
        } else if (qName.equalsIgnoreCase("start")) {
            this.start = tempText;
        } else if (qName.equalsIgnoreCase("text")) {
            this.remark = tempText;
        } else if (qName.equalsIgnoreCase("hash")) {
            if (tempText.equalsIgnoreCase(this.code)) {
                this.found = true;
            }
        } else if (qName.equalsIgnoreCase("dump")) {
            if (this.found) {
                this.repositoryGame = RepositoryGame.title(this.title).system(this.system).company(this.company).year(this.year).country(this.country).isOriginal(this.original).originalText(this.originalString).mapper(this.mapper).start(this.start).remark(this.remark).build();
                throw new StopSAXParsingException();
            }
            this.original = false;
            this.originalString = null;
            this.mapper = null;
            this.start = null;
            this.remark = null;
        }
        this.resetNodeTextHolder();
    }
}

