/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.builder;

import info.msxlaunchers.openmsx.common.ExternalLinksUtils;
import info.msxlaunchers.openmsx.common.FileTypeUtils;
import info.msxlaunchers.openmsx.common.HashUtils;
import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.extra.ExtraData;
import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.data.game.constants.FDDMode;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Genre;
import info.msxlaunchers.openmsx.launcher.data.game.constants.InputDevice;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class GameBuilder {
    public Game createGameObjectForDataEnteredByUser(String name, String info, String machine, String romA, String romB, String extensionRom, String diskA, String diskB, String tape, String harddisk, String laserdisc, String script, FDDMode fddMode, boolean scriptOverride, InputDevice inputDevice, boolean connectGFX9000, Map<String, ExtraData> extraDataMap) {
        boolean notScript = GameBuilder.isNotScript(romA, romB, diskA, diskB, tape, harddisk, laserdisc, script);
        FileSha1CodeAndSize fileSha1CodeAndSize = notScript ? this.getFileSha1CodeAndSize(romA, romB, diskA, diskB, tape, harddisk, laserdisc) : new FileSha1CodeAndSize(null, 0L);
        return this.createGameObject(name, info, false, machine, romA, romB, extensionRom, diskA, diskB, tape, harddisk, laserdisc, script, fddMode, scriptOverride, inputDevice, connectGFX9000, fileSha1CodeAndSize.sha1Code, fileSha1CodeAndSize.size, this.initIfNull(extraDataMap));
    }

    public Game createGameObjectForImportedData(String name, String info, String machine, String romA, String romB, String extensionRom, String diskA, String diskB, String tape, String harddisk, Map<String, ExtraData> extraDataMap) {
        FileSha1CodeAndSize fileSha1CodeAndSize = this.getFileSha1CodeAndSize(romA, romB, diskA, diskB, tape, harddisk, null);
        Game game = fileSha1CodeAndSize.sha1Code != null ? this.createGameObject(name, info, false, machine, romA, romB, extensionRom, diskA, diskB, tape, harddisk, null, null, null, true, null, false, fileSha1CodeAndSize.sha1Code, fileSha1CodeAndSize.size, this.initIfNull(extraDataMap)) : null;
        return game;
    }

    public Game createGameObjectForScannedFiles(String name, String machine, String rom, String extensionRom, String disk, String tape, String harddisk, String laserdisc, String sha1Code, long fileSize, Map<String, ExtraData> extraDataMap) {
        return this.createGameObject(name, null, true, machine, rom, null, extensionRom, disk, null, tape, harddisk, laserdisc, null, null, true, null, false, sha1Code, fileSize, this.initIfNull(extraDataMap));
    }

    public Game createGameObjectFromGameAndUpdateExtraData(Game game, Map<String, ExtraData> extraDataMap) {
        Objects.requireNonNull(game);
        return this.createGameObject(game.getName(), game.getInfo(), false, game.getMachine(), game.getRomA(), game.getRomB(), game.getExtensionRom(), game.getDiskA(), game.getDiskB(), game.getTape(), game.getHarddisk(), game.getLaserdisc(), game.getTclScript(), null, game.isTclScriptOverride(), null, game.isConnectGFX9000(), game.getSha1Code(), game.getSize(), this.initIfNull(extraDataMap));
    }

    private static boolean isNotScript(String romA, String romB, String diskA, String diskB, String tape, String harddisk, String laserdisc, String script) {
        return !Utils.isEmpty(romA) || !Utils.isEmpty(romB) || !Utils.isEmpty(diskA) || !Utils.isEmpty(diskB) || !Utils.isEmpty(tape) || !Utils.isEmpty(harddisk) || !Utils.isEmpty(laserdisc) || Utils.isEmpty(script);
    }

    private Game createGameObject(String name, String info, boolean useGenenerationMSXURLAsInfo, String machine, String romA, String romB, String extensionRom, String diskA, String diskB, String tape, String harddisk, String laserdisc, String script, FDDMode fddMode, boolean scriptOverride, InputDevice inputDevice, boolean connectGFX9000, String sha1Code, long fileSize, Map<String, ExtraData> extraDataMap) {
        int msxGenID = 0;
        boolean isMSX = false;
        boolean isMSX2 = false;
        boolean isMSX2Plus = false;
        boolean isTurboR = false;
        boolean isPSG = false;
        boolean isSCC = false;
        boolean isSCCI = false;
        boolean isPCM = false;
        boolean isMSXMUSIC = false;
        boolean isMSXAUDIO = false;
        boolean isMoonsound = false;
        boolean isMIDI = false;
        String screenshotSuffix = null;
        int genre1 = 0;
        int genre2 = 0;
        String infoField = info;
        ExtraData extraData = extraDataMap.get(sha1Code);
        if (extraData != null) {
            msxGenID = extraData.getMSXGenerationsID();
            if (useGenenerationMSXURLAsInfo) {
                infoField = ExternalLinksUtils.getGenerationMSXURL(msxGenID);
            }
            isMSX = extraData.isMSX();
            isMSX2 = extraData.isMSX2();
            isMSX2Plus = extraData.isMSX2Plus();
            isTurboR = extraData.isTurboR();
            isPSG = extraData.isPSG();
            isSCC = extraData.isSCC();
            isSCCI = extraData.isSCCI();
            isPCM = extraData.isPCM();
            isMSXMUSIC = extraData.isMSXMUSIC();
            isMSXAUDIO = extraData.isMSXAUDIO();
            isMoonsound = extraData.isMoonsound();
            isMIDI = extraData.isMIDI();
            screenshotSuffix = extraData.getSuffix();
            genre1 = extraData.getGenre1();
            genre2 = extraData.getGenre2();
        }
        Game game = null;
        try {
            game = Game.name(name).info(infoField).machine(machine).romA(romA).romB(romB).extensionRom(extensionRom).diskA(diskA).diskB(diskB).tape(tape).harddisk(harddisk).laserdisc(laserdisc).tclScript(script).sha1Code(sha1Code).size(fileSize).msxGenID(msxGenID).isMSX(isMSX).isMSX2(isMSX2).isMSX2Plus(isMSX2Plus).isTurboR(isTurboR).isPSG(isPSG).isSCC(isSCC).isSCCI(isSCCI).isPCM(isPCM).isMSXMUSIC(isMSXMUSIC).isMSXAUDIO(isMSXAUDIO).isMoonsound(isMoonsound).isMIDI(isMIDI).genre1(Genre.fromValue(genre1)).genre2(Genre.fromValue(genre2)).screenshotSuffix(screenshotSuffix).fddMode(fddMode).tclScriptOverride(scriptOverride).inputDevice(inputDevice).connectGFX9000(connectGFX9000).build();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return game;
    }

    private FileSha1CodeAndSize getFileSha1CodeAndSize(String romA, String romB, String diskA, String diskB, String tape, String harddisk, String laserdisc) {
        FileSha1CodeAndSize fileSha1CodeAndSize = null;
        String mainFile = FileTypeUtils.getMainFile(romA, romB, diskA, diskB, tape, harddisk, laserdisc, null);
        if (mainFile != null) {
            String sha1Code = null;
            long fileSize = 0L;
            File file = new File(mainFile);
            if (file.exists()) {
                if (FileTypeUtils.isZIP(file)) {
                    try (ZipFile zip = new ZipFile(file);){
                        ZipEntry firstZipEntry = zip.entries().nextElement();
                        try (InputStream inputStream = zip.getInputStream(firstZipEntry);){
                            sha1Code = HashUtils.getSHA1Code(inputStream);
                            fileSize = firstZipEntry.getSize();
                        }
                    }
                    catch (ZipException zipException) {
                    }
                    catch (IOException iOException) {}
                } else {
                    fileSize = file.length();
                    sha1Code = HashUtils.getSHA1Code(file);
                }
            }
            fileSha1CodeAndSize = new FileSha1CodeAndSize(sha1Code, fileSize);
        } else {
            fileSha1CodeAndSize = new FileSha1CodeAndSize(null, 0L);
        }
        return fileSha1CodeAndSize;
    }

    private Map<String, ExtraData> initIfNull(Map<String, ExtraData> extraDataMap) {
        if (extraDataMap == null) {
            return Collections.emptyMap();
        }
        return extraDataMap;
    }

    private static class FileSha1CodeAndSize {
        private final String sha1Code;
        private final long size;

        FileSha1CodeAndSize(String sha1Code, long size) {
            this.sha1Code = sha1Code;
            this.size = size;
        }
    }
}

