/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.data.filter;

import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.filter.Filter;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterDescriptor;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterParameter;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterType;
import info.msxlaunchers.openmsx.launcher.data.filter.ParameterField;
import info.msxlaunchers.openmsx.launcher.data.filter.Value1Field;
import info.msxlaunchers.openmsx.launcher.data.filter.Value2Field;
import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.data.repository.RepositoryGame;
import java.util.Objects;

@FilterDescriptor(type=FilterType.YEAR)
final class YearFilter
implements Filter {
    @Value1Field
    private final int year1;
    @Value2Field
    private final int year2;
    @ParameterField
    private final FilterParameter filterParameter;

    YearFilter(int year1, int year2, FilterParameter filterParameter) {
        this.year1 = year1;
        this.year2 = year2;
        this.filterParameter = Objects.requireNonNull(filterParameter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.year1, this.year2, this.filterParameter});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        YearFilter other = (YearFilter)obj;
        return this.filterParameter == other.filterParameter && this.year1 == other.year1 && this.year2 == other.year2;
    }

    @Override
    public boolean isFiltered(Game game, RepositoryGame repositoryGame) {
        Objects.requireNonNull(game);
        boolean filtered = false;
        if (repositoryGame == null) {
            filtered = true;
        } else {
            int year = Utils.getNumber(repositoryGame.getYear());
            switch (this.filterParameter) {
                case EQUAL: {
                    filtered = year != this.year1;
                    break;
                }
                case EQUAL_OR_LESS: {
                    filtered = year > this.year1;
                    break;
                }
                case EQUAL_OR_GREATER: {
                    filtered = year < this.year1;
                    break;
                }
                case LESS: {
                    filtered = year >= this.year1;
                    break;
                }
                case GREATER: {
                    filtered = year <= this.year1;
                    break;
                }
                case BETWEEN_INCLUSIVE: {
                    filtered = year < this.year1 || year > this.year2;
                }
            }
        }
        return filtered;
    }
}

