/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.data.game;

import info.msxlaunchers.openmsx.launcher.data.game.DatabaseItem;
import java.util.Objects;
import java.util.Optional;

public final class RelatedGame {
    private final String gameName;
    private final String company;
    private final String year;
    private final int msxGenId;
    private final DatabaseItem databaseItem;

    public RelatedGame(String gameName, String company, String year, int msxGenId) {
        this(gameName, company, year, msxGenId, null);
    }

    public RelatedGame(String gameName, String company, String year, int msxGenId, DatabaseItem databaseItem) {
        this.gameName = Objects.requireNonNull(gameName);
        this.company = company;
        this.year = year;
        this.msxGenId = msxGenId;
        this.databaseItem = databaseItem;
    }

    public String getGameName() {
        return this.gameName;
    }

    public String getCompany() {
        return this.company;
    }

    public String getYear() {
        return this.year;
    }

    public int getMSXGenId() {
        return this.msxGenId;
    }

    public Optional<DatabaseItem> getDatabaseItem() {
        return Optional.ofNullable(this.databaseItem);
    }

    public int hashCode() {
        return Objects.hash(this.msxGenId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.msxGenId == ((RelatedGame)obj).msxGenId;
    }
}

