/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import info.msxlaunchers.openmsx.launcher.persistence.EmbeddedDatabaseLauncherPersistence;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistence;
import info.msxlaunchers.openmsx.launcher.persistence.favorite.FavoritePersisterModule;
import info.msxlaunchers.openmsx.launcher.persistence.feed.FeedMessagePersisterModule;
import info.msxlaunchers.openmsx.launcher.persistence.filter.FilterPersisterModule;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersisterModule;
import info.msxlaunchers.openmsx.launcher.persistence.search.GameFinderModule;
import info.msxlaunchers.openmsx.launcher.persistence.settings.SettingsPersisterModule;
import java.io.File;
import java.lang.annotation.Annotation;

public class LauncherPersistenceModule
extends AbstractModule {
    private static final String DATABASES_DIRECTORY_NAME = "databases";
    private static final String EMBEDDED_DATABASE_NAME = "launcherdb";

    protected void configure() {
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"DatabasesDirectoryName")).toInstance((Object)DATABASES_DIRECTORY_NAME);
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"EmbeddedDatabaseFullPath")).toProvider(EmbeddedDatabaseFullPathProvider.class);
        this.bind(LauncherPersistence.class).to(EmbeddedDatabaseLauncherPersistence.class).in(Singleton.class);
        this.install((Module)new GamePersisterModule());
        this.install((Module)new FilterPersisterModule());
        this.install((Module)new FavoritePersisterModule());
        this.install((Module)new SettingsPersisterModule());
        this.install((Module)new GameFinderModule());
        this.install((Module)new FeedMessagePersisterModule());
    }

    private static class EmbeddedDatabaseFullPathProvider
    implements Provider<String> {
        private final String userDataDirectory;

        @Inject
        EmbeddedDatabaseFullPathProvider(@Named(value="UserDataDirectory") String userDataDirectory) {
            this.userDataDirectory = userDataDirectory;
        }

        public String get() {
            return new File(new File(this.userDataDirectory, LauncherPersistenceModule.DATABASES_DIRECTORY_NAME), LauncherPersistenceModule.EMBEDDED_DATABASE_NAME).toString();
        }
    }
}

