/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.favorite;

import info.msxlaunchers.openmsx.launcher.data.game.DatabaseItem;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.persistence.DefaultDatabaseResponse;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.TransactionalDatabaseOperation;
import info.msxlaunchers.openmsx.launcher.persistence.favorite.FavoritePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.favorite.FavoritePersistenceExceptionIssue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

final class SaveFavoriteAction
extends TransactionalDatabaseOperation<Boolean> {
    private static final String INSERT_FAVORITE_STATEMENT = "INSERT INTO favorite (IDGAME) VALUES (SELECT game.ID FROM game join database on game.IDDB=database.ID and game.name=? and database.name=?)";
    private static final String NOT_FOUND_ERROR_CODE = "23502";
    private final DatabaseItem favorite;

    SaveFavoriteAction(DatabaseItem favorite) {
        this.favorite = favorite;
    }

    public DefaultDatabaseResponse executeTransactionalOperation(Connection connection) throws LauncherPersistenceException {
        try (PreparedStatement statement = connection.prepareStatement(INSERT_FAVORITE_STATEMENT);){
            statement.setString(1, this.favorite.getGameName());
            statement.setString(2, this.favorite.getDatabase());
            statement.executeUpdate();
        }
        catch (SQLException se) {
            if (this.isDuplicateError(se)) {
                this.throwEncapsulatingException(new FavoritePersistenceException(FavoritePersistenceExceptionIssue.FAVORITE_ALREADY_EXISTS));
            }
            if (se.getSQLState().equals(NOT_FOUND_ERROR_CODE)) {
                this.throwEncapsulatingException(new FavoritePersistenceException(FavoritePersistenceExceptionIssue.GAME_OR_DATABASE_NOT_FOUND));
            }
            LauncherLogger.logException(this, se);
            this.throwEncapsulatingException(new FavoritePersistenceException(FavoritePersistenceExceptionIssue.IO));
        }
        return new DefaultDatabaseResponse();
    }
}

