/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.game;

import info.msxlaunchers.openmsx.common.ActionDecider;
import info.msxlaunchers.openmsx.launcher.data.backup.DatabaseBackup;
import info.msxlaunchers.openmsx.launcher.data.extra.ExtraData;
import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.data.game.RelatedGame;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface GamePersister {
    public void createDatabase(String var1) throws GamePersistenceException;

    public void deleteDatabase(String var1) throws GamePersistenceException;

    public void renameDatabase(String var1, String var2) throws GamePersistenceException;

    public DatabaseBackup backupDatabase(String var1) throws GamePersistenceException;

    public void restoreBackup(DatabaseBackup var1) throws GamePersistenceException;

    public void deleteBackup(DatabaseBackup var1) throws GamePersistenceException;

    public void recreateDatabase(String var1) throws GamePersistenceException;

    public Set<String> getDatabases();

    public Set<DatabaseBackup> getBackups(String var1);

    public int updateGameExtraDataInDatabases(Map<String, ExtraData> var1) throws GamePersistenceException;

    public Set<Game> getGames(String var1) throws GamePersistenceException;

    public void saveGame(Game var1, String var2) throws GamePersistenceException;

    public void saveGames(Set<Game> var1, String var2) throws GamePersistenceException;

    public void updateGame(Game var1, Game var2, String var3) throws GamePersistenceException;

    public void deleteGame(Game var1, String var2) throws GamePersistenceException;

    public void deleteGames(Set<Game> var1, String var2) throws GamePersistenceException;

    public Set<Game> moveGames(Set<Game> var1, String var2, String var3, ActionDecider var4) throws GamePersistenceException;

    public int updateMachine(String var1, String var2, String var3, boolean var4) throws GamePersistenceException;

    public List<RelatedGame> getRelatedGamesWithLauncherLinks(List<RelatedGame> var1) throws GamePersistenceException;
}

