/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.game;

import info.msxlaunchers.openmsx.launcher.data.game.DatabaseItem;
import info.msxlaunchers.openmsx.launcher.data.game.RelatedGame;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.persistence.DatabaseResponse;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.NonTransactionalDatabaseOperation;
import info.msxlaunchers.openmsx.launcher.persistence.game.GetRelatedGamesWithLauncherLinksResponse;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class GetRelatedGamesWithLauncherLinksAction
extends NonTransactionalDatabaseOperation<List<RelatedGame>> {
    private static final String GET_RELATED_GAMES_STATEMENT = "SELECT g.name, d.name FROM game g join database d on g.IDDB=d.ID WHERE g.msx_genid=?";
    private final List<RelatedGame> relatedGames;

    GetRelatedGamesWithLauncherLinksAction(List<RelatedGame> relatedGames) {
        this.relatedGames = relatedGames;
    }

    @Override
    public DatabaseResponse<List<RelatedGame>> executeNonTransactionalOperation(Connection connection) throws LauncherPersistenceException {
        ArrayList<RelatedGame> updatedRelatedGames = new ArrayList<RelatedGame>(this.relatedGames.size());
        for (RelatedGame relatedGame : this.relatedGames) {
            try {
                PreparedStatement statement = connection.prepareStatement(GET_RELATED_GAMES_STATEMENT);
                Throwable throwable = null;
                try {
                    statement.setInt(1, relatedGame.getMSXGenId());
                    ResultSet result = statement.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        if (result.next()) {
                            DatabaseItem databaseItem = new DatabaseItem(result.getString(1), result.getString(2));
                            RelatedGame updatedRelatedGame = new RelatedGame(relatedGame.getGameName(), relatedGame.getCompany(), relatedGame.getYear(), relatedGame.getMSXGenId(), databaseItem);
                            updatedRelatedGames.add(updatedRelatedGame);
                            continue;
                        }
                        updatedRelatedGames.add(relatedGame);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (result == null) continue;
                        if (throwable2 != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        result.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
            catch (SQLException se) {
                updatedRelatedGames.add(relatedGame);
                LauncherLogger.logException(this, se);
            }
        }
        return new GetRelatedGamesWithLauncherLinksResponse(Collections.unmodifiableList(updatedRelatedGames));
    }
}

