/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.game;

import info.msxlaunchers.openmsx.common.ActionDecider;
import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.TransactionalDatabaseOperation;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceExceptionIssue;
import info.msxlaunchers.openmsx.launcher.persistence.game.GetGamesAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.MoveGamesResponse;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

final class MoveGamesAction
extends TransactionalDatabaseOperation<Set<Game>> {
    private static final String MOVE_GAME_STATEMENT = "UPDATE game SET IDDB=? WHERE name=? and IDDB=?";
    private static final String DELETE_OVERRIDDEN_GAMES_STATEMENT = "DELETE FROM game WHERE name=? and IDDB=?";
    private final Set<Game> games;
    private final String oldDatabase;
    private final String newDatabase;
    private final ActionDecider actionDecider;

    MoveGamesAction(Set<Game> games, String oldDatabase, String newDatabase, ActionDecider actionDecider) {
        this.games = games;
        this.oldDatabase = oldDatabase;
        this.newDatabase = newDatabase;
        this.actionDecider = actionDecider;
    }

    public MoveGamesResponse executeTransactionalOperation(Connection connection) throws LauncherPersistenceException {
        Throwable throwable;
        PreparedStatement statement;
        HashSet<Game> movedGames = new HashSet<Game>();
        HashSet<String> overriddenGameNames = new HashSet<String>();
        Set<Game> destinationDatabaseCache = new GetGamesAction(this.newDatabase).executeNonTransactionalOperation(connection).getResult();
        for (Game game : this.games) {
            if (destinationDatabaseCache.contains(game)) {
                if (!this.actionDecider.isYesAll() && !this.actionDecider.isNoAll()) {
                    this.actionDecider.promptForAction(game.getName());
                }
                if (this.actionDecider.isYes() || this.actionDecider.isYesAll()) {
                    movedGames.add(game);
                    overriddenGameNames.add(game.getName());
                    continue;
                }
                if (this.actionDecider.isNo() || this.actionDecider.isNoAll()) continue;
                if (this.actionDecider.isCancel()) break;
                throw new RuntimeException("At least one action must be set");
            }
            movedGames.add(game);
        }
        long oldDatabaseId = this.getDatabaseId(connection, this.oldDatabase);
        long newDatabaseId = this.getDatabaseId(connection, this.newDatabase);
        try {
            statement = connection.prepareStatement(DELETE_OVERRIDDEN_GAMES_STATEMENT);
            throwable = null;
            try {
                for (String gameName : overriddenGameNames) {
                    statement.setString(1, gameName);
                    statement.setLong(2, newDatabaseId);
                    statement.addBatch();
                }
                statement.executeBatch();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (SQLException se) {
            LauncherLogger.logException(this, se);
            this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.IO));
        }
        try {
            statement = connection.prepareStatement(MOVE_GAME_STATEMENT);
            throwable = null;
            try {
                for (Game game : movedGames) {
                    statement.setLong(1, newDatabaseId);
                    statement.setString(2, game.getName());
                    statement.setLong(3, oldDatabaseId);
                    statement.addBatch();
                }
                statement.executeBatch();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (SQLException se) {
            LauncherLogger.logException(this, se);
            this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.IO));
        }
        return new MoveGamesResponse(movedGames);
    }
}

