/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.game;

import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.persistence.DefaultDatabaseResponse;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.AbstractPersistGameAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceExceptionIssue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Set;

final class SaveGamesAction
extends AbstractPersistGameAction {
    private static final String INSERT_GAME_STATEMENT = "INSERT INTO game (name, info, machine, romA, extension_rom, romB, diskA, diskB,tape, harddisk, laserdisc, tcl_script, msx, msx2, msx2plus, turbo_r, psg, scc, scc_i, pcm, msx_music, msx_audio, moonsound, midi,genre1, genre2, msx_genid, screenshot_suffix, sha1, size, IDDB, fdd_mode, tcl_script_override, input_device, connect_gfx9000) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private final Set<Game> games;
    private final String database;

    SaveGamesAction(Set<Game> games, String database) {
        this.games = games;
        this.database = database;
    }

    public DefaultDatabaseResponse executeTransactionalOperation(Connection connection) throws LauncherPersistenceException {
        String duplicateGame = null;
        try (PreparedStatement statement = connection.prepareStatement(INSERT_GAME_STATEMENT);){
            long databaseId = this.getDatabaseId(connection, this.database);
            for (Game game : this.games) {
                this.validateGame(game);
                duplicateGame = game.getName();
                this.setGameStatementFields(statement, game, databaseId);
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException se) {
            if (this.isDuplicateError(se)) {
                this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.GAME_ALREADY_EXISTS, duplicateGame));
            }
            LauncherLogger.logException(this, se);
            this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.IO));
        }
        return new DefaultDatabaseResponse();
    }
}

