/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.search;

import info.msxlaunchers.openmsx.launcher.data.game.DatabaseItem;
import info.msxlaunchers.openmsx.launcher.persistence.DatabaseResponse;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.NonTransactionalDatabaseOperation;
import info.msxlaunchers.openmsx.launcher.persistence.search.GameFinderResponse;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

final class GameFinderAction
extends NonTransactionalDatabaseOperation<Set<DatabaseItem>> {
    private static final String GET_MATCHES_STATEMENT = "SELECT game.name AS gameName, database.name AS database FROM database JOIN game ON database.id=game.IDDB AND (UPPER(game.name) like UPPER(?) OR game.sha1 like ?)";
    private final String string;
    private final int maximumMatches;

    GameFinderAction(String string, int maximumMatches) {
        this.string = string;
        this.maximumMatches = maximumMatches;
    }

    @Override
    public DatabaseResponse<Set<DatabaseItem>> executeNonTransactionalOperation(Connection connection) throws LauncherPersistenceException {
        HashSet<DatabaseItem> matches = new HashSet<DatabaseItem>();
        try (PreparedStatement statement = connection.prepareStatement(GET_MATCHES_STATEMENT);){
            statement.setString(1, "%" + this.string + "%");
            statement.setString(2, this.string.toLowerCase() + "%");
            statement.setMaxRows(this.maximumMatches);
            try (ResultSet result = statement.executeQuery();){
                while (result.next()) {
                    matches.add(new DatabaseItem(result.getString("gameName"), result.getString("database")));
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new GameFinderResponse(Collections.unmodifiableSet(matches));
    }
}

