/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import info.msxlaunchers.openmsx.common.OSUtils;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;

public class AppModule
extends AbstractModule {
    protected void configure() {
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"UserDataDirectory")).toInstance((Object)this.getUserDataDirectory());
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"LauncherDataDirectory")).toInstance((Object)this.getLauncherDataDirectory());
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"JarFilesDirectory")).toInstance((Object)this.getJarFilesDirectory());
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"BaseDirectory")).toProvider(Providers.of(null));
    }

    private String getUserDataDirectory() {
        String userDataDirectory = OSUtils.getUserDataDirectory();
        this.createUserDataDirectoryIfNecessary(userDataDirectory);
        return userDataDirectory;
    }

    private String getLauncherDataDirectory() {
        String launcherDataDirectory = null;
        if (OSUtils.isWindows()) {
            launcherDataDirectory = System.getProperty("user.dir");
        } else if (OSUtils.isMac()) {
            try {
                String appDir = (String)Class.forName("com.apple.eio.FileManager").getMethod("getPathToApplicationBundle", null).invoke(null, (Object[])null);
                launcherDataDirectory = new File(appDir, "share").getAbsolutePath();
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {}
        } else if (OSUtils.isLinux() || OSUtils.isBSD()) {
            launcherDataDirectory = System.getProperty("user.dir");
        }
        return launcherDataDirectory;
    }

    private String getJarFilesDirectory() {
        String jarFilesDirectory = null;
        if (OSUtils.isWindows()) {
            jarFilesDirectory = new File(System.getProperty("user.dir"), "lib").getAbsolutePath();
        } else if (OSUtils.isMac()) {
            try {
                String appDir = (String)Class.forName("com.apple.eio.FileManager").getMethod("getPathToApplicationBundle", null).invoke(null, (Object[])null);
                jarFilesDirectory = new File(appDir, "Contents/Java").getAbsolutePath();
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {}
        } else if (OSUtils.isLinux() || OSUtils.isBSD()) {
            jarFilesDirectory = new File(System.getProperty("user.dir"), "lib").getAbsolutePath();
        }
        return jarFilesDirectory;
    }

    private void createUserDataDirectoryIfNecessary(String userDataDirectory) {
        File userDataDirectoryPath = new File(userDataDirectory);
        if (!userDataDirectoryPath.exists()) {
            userDataDirectoryPath.mkdir();
        }
    }
}

