/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.presenter;

import com.google.inject.Inject;
import info.msxlaunchers.openmsx.launcher.data.feed.FeedMessage;
import info.msxlaunchers.openmsx.launcher.feed.FeedService;
import info.msxlaunchers.openmsx.launcher.ui.presenter.FeedServicePresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.MainView;
import java.io.IOException;
import java.util.List;

class FeedServicePresenterImpl
implements FeedServicePresenter {
    private final FeedService feedService;
    private final MainView view;
    private NewNewsChecker newNewsChecker;
    private volatile boolean running = false;

    @Inject
    FeedServicePresenterImpl(FeedService feedService, MainView view) {
        this.feedService = feedService;
        this.view = view;
    }

    @Override
    public void startService() {
        if (!this.running) {
            this.running = true;
            this.feedService.start();
            this.newNewsChecker = new NewNewsChecker();
            this.newNewsChecker.start();
        }
    }

    @Override
    public void stopService() {
        this.running = false;
        this.feedService.stop();
        if (this.newNewsChecker != null) {
            this.newNewsChecker.stop();
        }
    }

    @Override
    public void onRequestNewsList() throws IOException {
        List<FeedMessage> feedMessages = this.feedService.getMessages();
        if (feedMessages.isEmpty()) {
            this.view.showFeedProcessingMessage();
        } else {
            this.view.showFeedMessagesList(feedMessages);
        }
    }

    private class NewNewsChecker {
        private volatile boolean running = false;

        private NewNewsChecker() {
        }

        void start() {
            if (!this.running) {
                this.running = true;
                new Thread(this::periodicChecker).start();
            }
        }

        void stop() {
            this.running = false;
        }

        void periodicChecker() {
            while (this.running) {
                if (FeedServicePresenterImpl.this.feedService.isNewMessagesFound()) {
                    FeedServicePresenterImpl.this.view.indicateNewFeedMessages(true);
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

