/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.presenter;

import com.google.inject.Inject;
import info.msxlaunchers.openmsx.common.ExternalLinksUtils;
import info.msxlaunchers.openmsx.common.FileTypeUtils;
import info.msxlaunchers.openmsx.common.FileUtils;
import info.msxlaunchers.openmsx.game.repository.RepositoryData;
import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.data.repository.RepositoryGame;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.presenter.GamePropertiesPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.GamePropertiesView;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class GamePropertiesPresenterImpl
implements GamePropertiesPresenter {
    private final GamePropertiesView view;
    private final RepositoryData repositoryData;

    @Inject
    GamePropertiesPresenterImpl(GamePropertiesView view, RepositoryData repositoryData) {
        this.view = Objects.requireNonNull(view);
        this.repositoryData = Objects.requireNonNull(repositoryData);
    }

    @Override
    public void onRequestGamePropertiesScreen(Game game, Language currentLanguage, boolean currentRightToLeft) {
        List<String> fileGroup;
        RepositoryGame repositoryGame = null;
        int knownDumps = 0;
        if (game.getSha1Code() != null) {
            try {
                repositoryGame = this.repositoryData.getGameInfo(game.getSha1Code());
                knownDumps = this.repositoryData.getDumpCodes(game.getSha1Code()).size();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Path mainFile = Paths.get(FileTypeUtils.getMainFile(game.getRomA(), game.getRomB(), game.getDiskA(), game.getDiskB(), game.getTape(), game.getHarddisk(), game.getLaserdisc(), game.getTclScript()), new String[0]);
        try {
            fileGroup = FileUtils.getFileGroup(mainFile);
        }
        catch (IOException ioe) {
            fileGroup = Collections.emptyList();
        }
        this.view.displayGamePropertiesScreen(game, repositoryGame, knownDumps, fileGroup, currentLanguage, currentRightToLeft);
    }

    @Override
    public boolean isGenerationMSXIdValid(Game game) {
        return ExternalLinksUtils.isGenerationMSXIdValid(game.getMsxGenID());
    }

    @Override
    public String getGenerationMSXURL(Game game) {
        return ExternalLinksUtils.getGenerationMSXURL(game.getMsxGenID());
    }
}

