/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.presenter;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import info.msxlaunchers.openmsx.common.Nullable;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceExceptionIssue;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersister;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherExceptionCode;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MachineUpdatePresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MainPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.MachineUpdateView;
import info.msxlaunchers.openmsx.machine.InvalidMachinesDirectoryException;
import info.msxlaunchers.openmsx.machine.MachineLister;
import java.io.IOException;
import java.util.Objects;

final class MachineUpdatePresenterImpl
implements MachineUpdatePresenter {
    private final MainPresenter mainPresenter;
    private final MachineLister machineLister;
    private final MachineUpdateView view;
    private final GamePersister gamePersister;
    private final String currentDatabase;

    @Inject
    MachineUpdatePresenterImpl(MainPresenter mainPresenter, MachineLister machineLister, MachineUpdateView view, GamePersister gamePersister, @Nullable @Assisted String currentDatabase) {
        this.mainPresenter = Objects.requireNonNull(mainPresenter);
        this.machineLister = Objects.requireNonNull(machineLister);
        this.view = Objects.requireNonNull(view);
        this.gamePersister = Objects.requireNonNull(gamePersister);
        this.currentDatabase = currentDatabase;
    }

    @Override
    public void onRequestMachineUpdateScreen(Language currentLanguage, boolean currentRightToLeft) throws LauncherException {
        if (this.currentDatabase == null) {
            throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_NOT_FOUND);
        }
        try {
            this.view.displayScreen(this, this.currentDatabase, currentLanguage, currentRightToLeft, this.machineLister.get());
        }
        catch (InvalidMachinesDirectoryException imde) {
            throw new LauncherException(LauncherExceptionCode.ERR_INVALID_MACHINES_DIRECTORY);
        }
        catch (IOException ioe) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }

    @Override
    public int onRequestMachineUpdateAction(String machineTo, String machineFrom, String database, boolean backupDatabases) throws LauncherException {
        try {
            int totalUpdated = this.gamePersister.updateMachine(machineTo, machineFrom, database, backupDatabases);
            this.mainPresenter.onViewUpdatedDatabase(database);
            return totalUpdated;
        }
        catch (GamePersistenceException gpe) {
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_MAX_BACKUPS_REACHED)) {
                throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_MAX_BACKUPS_REACHED, gpe.getaffectedObject());
            }
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }
}

