/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view;

import com.google.inject.Inject;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LHAExtractorPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.LHAExtractorView;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.LHAExtractorWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.util.Map;

class LHAExtractorSwingView
implements LHAExtractorView {
    private final LHAExtractorPresenter presenter;
    LHAExtractorWindow window = null;

    @Inject
    LHAExtractorSwingView(LHAExtractorPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void displayScreen(Language language, boolean rightToLeft) {
        this.window = new LHAExtractorWindow(this.presenter, language, rightToLeft);
        this.window.displayScreen();
    }

    @Override
    public int displayAndGetActionDecider(String extractedFilename, Language language, boolean rightToLeft) {
        Map<String, String> messages = LanguageDisplayFactory.getDisplayMessages(LHAExtractorWindow.class, language);
        return MessageBoxUtil.showYesNoAllMessageBox(this.window, "<html>\"" + extractedFilename + "\" " + messages.get("CONFIRM_REPLACE_EXTRACTED_FILE_MSG") + "</html>", messages, rightToLeft);
    }
}

