/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.platform;

import info.msxlaunchers.openmsx.launcher.ui.presenter.MainPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.platform.PlatformViewProperties;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.images.Icons;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

final class MacViewProperties
implements PlatformViewProperties {
    private final MainPresenter mainPresenter;

    MacViewProperties(MainPresenter mainPresenter) {
        this.mainPresenter = Objects.requireNonNull(mainPresenter);
    }

    @Override
    public String getSuggestedOpenMSXPath() {
        return "/Applications";
    }

    @Override
    public boolean isMachinesFolderInsideOpenMSX() {
        return true;
    }

    @Override
    public String getOpenMSXMachinesPath() {
        return "openmsx.app/share/machines";
    }

    @Override
    public void setDisplayProperties(JFrame window) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "openMSX Launcher");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            throw new RuntimeException(e);
        }
        try {
            Object app = Class.forName("com.apple.eawt.Application").getMethod("getApplication", null).invoke(null, (Object[])null);
            Object al = Proxy.newProxyInstance(Class.forName("com.apple.eawt.AboutHandler").getClassLoader(), new Class[]{Class.forName("com.apple.eawt.AboutHandler")}, (InvocationHandler)new AboutListener());
            app.getClass().getMethod("setAboutHandler", Class.forName("com.apple.eawt.AboutHandler")).invoke(app, al);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        window.setIconImage(Icons.APPLICATION_32.getImage());
    }

    private class AboutListener
    implements InvocationHandler {
        private AboutListener() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            MacViewProperties.this.mainPresenter.onRequestAboutScreen();
            return null;
        }
    }
}

