/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.common.FileTypeUtils;
import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.game.constants.FDDMode;
import info.msxlaunchers.openmsx.launcher.data.game.constants.InputDevice;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.ProfileEditingPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.GlobalSwingContext;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.MainWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.WindowUtils;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.JTextFieldDragDrop;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.images.Icons;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class AddEditGameWindow
extends JDialog
implements ActionListener {
    private final ProfileEditingPresenter presenter;
    private final Map<String, String> messages;
    private final Set<String> machines;
    private final Set<String> extensions;
    private final boolean rightToLeft;
    private final Component mainWindow;
    private final boolean editMode;
    private JTextField nameTextField;
    private JTextFieldDragDrop infoTextField;
    private JButton browseInfoButton;
    private JComboBox<String> machinesComboBox;
    private JComboBox<String> inputDeviceComboBox;
    private JCheckBox connectGFX9000CheckBox;
    private JCheckBox extensionCheckBox;
    private JTextFieldDragDrop romATextField;
    private JButton browseRomAButton;
    private JTextFieldDragDrop romBTextField;
    private JButton browseRomBButton;
    private JComboBox<String> extensionComboBox;
    private JTextFieldDragDrop diskATextField;
    private JButton browseDiskAButton;
    private JTextFieldDragDrop diskBTextField;
    private JButton browseDiskBButton;
    private JComboBox<String> fddModesComboBox;
    private JTextFieldDragDrop tapeTextField;
    private JButton browseTapeButton;
    private JTextFieldDragDrop harddiskTextField;
    private JButton browseHarddiskButton;
    private JTextFieldDragDrop laserdiscTextField;
    private JButton browseLaserdiscButton;
    private JTextFieldDragDrop scriptTextField;
    private JCheckBox scriptOverrideCheckBox;
    private JButton browseScriptButton;
    private JButton launchButton;
    private JButton saveButton;
    private JButton cancelButton;
    private String oldGameName;

    public AddEditGameWindow(ProfileEditingPresenter presenter, Language language, Set<String> machines, Set<String> extensions, boolean rightToLeft, boolean editMode) {
        this.presenter = presenter;
        this.machines = machines;
        this.extensions = extensions;
        this.rightToLeft = rightToLeft;
        this.mainWindow = GlobalSwingContext.getIntance().getMainWindow();
        this.editMode = editMode;
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
    }

    public void display(String name, String info, String machine, String romA, String romB, String extension, String diskA, String diskB, String tape, String harddisk, String laserdisc, String script, int fddModeCode, boolean isScriptOverride, int inputDevice, boolean connectGX9000) {
        this.setDefaultCloseOperation(2);
        if (this.editMode) {
            this.setTitle(this.messages.get("EDIT_GAME"));
        } else {
            this.setTitle(this.messages.get("ADD_GAME"));
        }
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        JPanel contentPane = new JPanel();
        this.setContentPane(contentPane);
        JPanel topPart = new JPanel();
        JPanel buttonsPart = new JPanel();
        GroupLayout contentPaneLayout = new GroupLayout(contentPane);
        contentPaneLayout.setHorizontalGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(topPart, -2, 560, -2).addComponent(buttonsPart, -2, 560, -2));
        contentPaneLayout.setVerticalGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contentPaneLayout.createSequentialGroup().addComponent(topPart, -2, 205, -2).addGap(3).addComponent(buttonsPart, -2, 35, -2)));
        contentPane.setLayout(contentPaneLayout);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setPreferredSize(new Dimension(560, 240));
        this.addGeneralTab(tabbedPane);
        this.addSetupTab(tabbedPane);
        this.addROMTab(tabbedPane);
        this.addDiskTab(tabbedPane);
        this.addTapeTab(tabbedPane);
        this.addHarddiskTab(tabbedPane);
        this.addLaserdiscTab(tabbedPane);
        this.addScriptTab(tabbedPane);
        topPart.add(tabbedPane);
        this.launchButton = new JButton(this.messages.get("LAUNCH"));
        this.launchButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        this.launchButton.addActionListener(this);
        this.saveButton = new JButton(this.messages.get("SAVE"));
        this.saveButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        this.saveButton.addActionListener(this);
        this.cancelButton = new JButton(this.messages.get("CANCEL"));
        this.cancelButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        this.cancelButton.addActionListener(this);
        buttonsPart.add(this.launchButton);
        buttonsPart.add(this.saveButton);
        buttonsPart.add(this.cancelButton);
        if (this.rightToLeft) {
            topPart.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            topPart.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            buttonsPart.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        if (this.editMode) {
            this.oldGameName = name;
            this.nameTextField.setText(name);
            this.infoTextField.setText(info);
            this.machinesComboBox.setSelectedItem(machine);
            this.inputDeviceComboBox.setSelectedIndex(inputDevice);
            this.connectGFX9000CheckBox.setSelected(connectGX9000);
            this.romATextField.setText(romA);
            this.romBTextField.setText(romB);
            if (extension == null) {
                this.extensionComboBox.setEnabled(false);
            } else {
                this.extensionCheckBox.setSelected(true);
                this.extensionComboBox.setSelectedItem(extension);
            }
            this.diskATextField.setText(diskA);
            this.diskBTextField.setText(diskB);
            this.fddModesComboBox.setSelectedIndex(fddModeCode);
            this.tapeTextField.setText(tape);
            this.harddiskTextField.setText(harddisk);
            this.laserdiscTextField.setText(laserdisc);
            this.scriptTextField.setText(script);
            this.scriptOverrideCheckBox.setSelected(isScriptOverride);
        } else {
            this.extensionComboBox.setEnabled(false);
            this.scriptOverrideCheckBox.setSelected(true);
        }
        this.pack();
        this.setLocationRelativeTo(this.mainWindow);
        this.setVisible(true);
    }

    public void display() {
        if (this.editMode) {
            throw new RuntimeException("Cannot call this in Edit mode");
        }
        this.display(null, null, null, null, null, null, null, null, null, null, null, null, 0, false, 0, false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.launchButton) {
            try {
                this.presenter.onRequestLaunchAction(this.machinesComboBox.getSelectedItem().toString(), this.romATextField.getText(), this.romBTextField.getText(), this.getExtenstionRomSelection(), this.diskATextField.getText(), this.diskBTextField.getText(), this.tapeTextField.getText(), this.harddiskTextField.getText(), this.laserdiscTextField.getText(), this.scriptTextField.getText(), this.fddModesComboBox.getSelectedIndex(), this.scriptOverrideCheckBox.isSelected(), this.inputDeviceComboBox.getSelectedIndex(), this.connectGFX9000CheckBox.isSelected());
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox(this.mainWindow, le, this.messages, this.rightToLeft);
            }
        } else if (source == this.saveButton) {
            try {
                if (this.editMode) {
                    this.presenter.onRequestEditGameSaveAction(this.oldGameName, this.nameTextField.getText(), this.infoTextField.getText(), this.machinesComboBox.getSelectedItem().toString(), this.romATextField.getText(), this.romBTextField.getText(), this.getExtenstionRomSelection(), this.diskATextField.getText(), this.diskBTextField.getText(), this.tapeTextField.getText(), this.harddiskTextField.getText(), this.laserdiscTextField.getText(), this.scriptTextField.getText(), this.fddModesComboBox.getSelectedIndex(), this.scriptOverrideCheckBox.isSelected(), this.inputDeviceComboBox.getSelectedIndex(), this.connectGFX9000CheckBox.isSelected());
                } else {
                    this.presenter.onRequestAddGameSaveAction(this.nameTextField.getText(), this.infoTextField.getText(), this.machinesComboBox.getSelectedItem().toString(), this.romATextField.getText(), this.romBTextField.getText(), this.getExtenstionRomSelection(), this.diskATextField.getText(), this.diskBTextField.getText(), this.tapeTextField.getText(), this.harddiskTextField.getText(), this.laserdiscTextField.getText(), this.scriptTextField.getText(), this.fddModesComboBox.getSelectedIndex(), this.scriptOverrideCheckBox.isSelected(), this.inputDeviceComboBox.getSelectedIndex(), this.connectGFX9000CheckBox.isSelected());
                }
                this.dispose();
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox(this.mainWindow, le, this.messages, this.rightToLeft);
            }
        } else if (source == this.cancelButton) {
            this.dispose();
        } else if (source == this.browseInfoButton) {
            WindowUtils.browseFile(this, this.infoTextField);
        } else if (source == this.browseRomAButton) {
            WindowUtils.browseFile(this, this.romATextField, this.messages.get("ROM"), FileTypeUtils.getROMExtensions(), true);
        } else if (source == this.browseRomBButton) {
            WindowUtils.browseFile(this, this.romBTextField, this.messages.get("ROM"), FileTypeUtils.getROMExtensions(), true);
        } else if (source == this.browseDiskAButton) {
            WindowUtils.browseFile(this, this.diskATextField, this.messages.get("DISK"), FileTypeUtils.getDiskExtensions(), true);
        } else if (source == this.browseDiskBButton) {
            WindowUtils.browseFile(this, this.diskBTextField, this.messages.get("DISK"), FileTypeUtils.getDiskExtensions(), true);
        } else if (source == this.browseTapeButton) {
            WindowUtils.browseFile(this, this.tapeTextField, this.messages.get("TAPE"), FileTypeUtils.getTapeExtensions(), true);
        } else if (source == this.browseHarddiskButton) {
            WindowUtils.browseFile(this, this.harddiskTextField, this.messages.get("HARDDISK"), FileTypeUtils.getHarddiskExtensions(), true);
        } else if (source == this.browseLaserdiscButton) {
            WindowUtils.browseFile(this, this.laserdiscTextField, this.messages.get("LASERDISC"), FileTypeUtils.getLaserdiscExtensions(), true);
        } else if (source == this.browseScriptButton) {
            WindowUtils.browseFile(this, this.scriptTextField);
        } else if (source == this.extensionCheckBox) {
            this.extensionComboBox.setEnabled(this.extensionCheckBox.isSelected());
        }
    }

    private String getExtenstionRomSelection() {
        return this.extensionCheckBox.isSelected() ? this.extensionComboBox.getSelectedItem().toString() : null;
    }

    private void addGeneralTab(JTabbedPane tabbedPane) {
        JPanel generalPanel = new JPanel(false);
        JLabel nameLabel = new JLabel(this.messages.get("NAME"));
        nameLabel.setHorizontalAlignment(11);
        this.nameTextField = new JTextField();
        this.nameTextField.setColumns(10);
        JLabel infoLabel = new JLabel(this.messages.get("INFO"));
        infoLabel.setHorizontalAlignment(11);
        this.infoTextField = new JTextFieldDragDrop();
        this.infoTextField.setColumns(10);
        this.browseInfoButton = new JButton(Icons.FOLDER.getImageIcon());
        this.browseInfoButton.setToolTipText(this.messages.get("BROWSE"));
        this.browseInfoButton.addActionListener(this);
        GroupLayout groupLayout = new GroupLayout(generalPanel);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(nameLabel, -2, 125, -2).addGap(5).addComponent(this.nameTextField, -2, 315, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(infoLabel, -2, 125, -2).addGap(5).addComponent(this.infoTextField, -2, 315, -2).addComponent(this.browseInfoButton, -2, 35, -2)))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(35).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(3).addComponent(nameLabel)).addComponent(this.nameTextField, -2, -1, -2)).addGap(18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4).addComponent(infoLabel)).addGroup(groupLayout.createSequentialGroup().addGap(1).addComponent(this.infoTextField, -2, -1, -2)).addComponent(this.browseInfoButton))));
        generalPanel.setLayout(groupLayout);
        tabbedPane.addTab(this.messages.get("GENERAL"), generalPanel);
    }

    private void addSetupTab(JTabbedPane tabbedPane) {
        JPanel setupPanel = new JPanel(false);
        JLabel machineLabel = new JLabel(this.messages.get("MACHINE"));
        machineLabel.setHorizontalAlignment(11);
        this.machinesComboBox = new JComboBox<String>(Utils.getSortedCaseInsensitiveArray(this.machines));
        JLabel inputDeviceLabel = new JLabel(this.messages.get("INPUT_DEVICE"));
        inputDeviceLabel.setHorizontalAlignment(11);
        String[] inputDeviceValues = (String[])Arrays.asList(InputDevice.values()).stream().map(f -> this.messages.get(f.toString())).toArray(String[]::new);
        this.inputDeviceComboBox = new JComboBox<String>(inputDeviceValues);
        this.connectGFX9000CheckBox = new JCheckBox(this.messages.get("CONNECT_GFX9000"));
        GroupLayout groupLayout = new GroupLayout(setupPanel);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(machineLabel, -2, 125, -2).addGap(5).addComponent(this.machinesComboBox, -2, 270, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(inputDeviceLabel, -2, 125, -2).addGap(5).addComponent(this.inputDeviceComboBox, -2, 270, -2)).addGroup(groupLayout.createSequentialGroup().addGap(105).addComponent(this.connectGFX9000CheckBox, -2, -1, -2)))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(35).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(3).addComponent(machineLabel)).addComponent(this.machinesComboBox, -2, -1, -2)).addGap(18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(3).addComponent(inputDeviceLabel)).addComponent(this.inputDeviceComboBox, -2, -1, -2)).addGap(27).addGroup(groupLayout.createSequentialGroup().addComponent(this.connectGFX9000CheckBox))));
        setupPanel.setLayout(groupLayout);
        tabbedPane.addTab(this.messages.get("SETUP"), setupPanel);
    }

    private void addROMTab(JTabbedPane tabbedPane) {
        JPanel romPanel = new JPanel(false);
        JLabel romALabel = new JLabel(this.messages.get("ROM_A"));
        romALabel.setHorizontalAlignment(11);
        this.romATextField = new JTextFieldDragDrop();
        this.romATextField.setColumns(9);
        this.browseRomAButton = new JButton(Icons.FOLDER.getImageIcon());
        this.browseRomAButton.setToolTipText(this.messages.get("BROWSE"));
        this.browseRomAButton.addActionListener(this);
        JLabel romBLabel = new JLabel(this.messages.get("ROM_B"));
        romBLabel.setHorizontalAlignment(11);
        this.romBTextField = new JTextFieldDragDrop();
        this.romBTextField.setColumns(9);
        this.browseRomBButton = new JButton(Icons.FOLDER.getImageIcon());
        this.browseRomBButton.setToolTipText(this.messages.get("BROWSE"));
        this.browseRomBButton.addActionListener(this);
        this.extensionCheckBox = new JCheckBox(this.messages.get("EXTENSION"));
        this.extensionCheckBox.addActionListener(this);
        this.extensionComboBox = new JComboBox<String>(Utils.getSortedCaseInsensitiveArray(this.extensions));
        GroupLayout groupLayout = new GroupLayout(romPanel);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addComponent(romALabel, -2, 125, -2).addGap(5).addComponent(this.romATextField, -2, 315, -2).addComponent(this.browseRomAButton, -2, 35, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(romBLabel, -2, 125, -2).addGap(5).addComponent(this.romBTextField, -2, 315, -2).addComponent(this.browseRomBButton, -2, 35, -2)).addGroup(groupLayout.createSequentialGroup().addGap(105).addComponent(this.extensionCheckBox).addGap(5).addComponent(this.extensionComboBox, -2, 240, -2)))))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(35).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(3).addComponent(romALabel)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.romATextField, -2, -1, -2).addComponent(this.browseRomAButton))).addGap(18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4).addComponent(romBLabel)).addGroup(groupLayout.createSequentialGroup().addGap(1).addComponent(this.romBTextField, -2, -1, -2)).addComponent(this.browseRomBButton)).addGap(18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.extensionCheckBox).addComponent(this.extensionComboBox))));
        romPanel.setLayout(groupLayout);
        tabbedPane.addTab(this.messages.get("ROM"), romPanel);
    }

    private void addDiskTab(JTabbedPane tabbedPane) {
        JPanel diskPanel = new JPanel(false);
        JLabel diskALabel = new JLabel(this.messages.get("DISK_A"));
        diskALabel.setHorizontalAlignment(11);
        this.diskATextField = new JTextFieldDragDrop();
        this.diskATextField.setColumns(10);
        this.browseDiskAButton = new JButton(Icons.FOLDER.getImageIcon());
        this.browseDiskAButton.setToolTipText(this.messages.get("BROWSE"));
        this.browseDiskAButton.addActionListener(this);
        JLabel diskBLabel = new JLabel(this.messages.get("DISK_B"));
        diskBLabel.setHorizontalAlignment(11);
        this.diskBTextField = new JTextFieldDragDrop();
        this.diskBTextField.setColumns(10);
        this.browseDiskBButton = new JButton(Icons.FOLDER.getImageIcon());
        this.browseDiskBButton.setToolTipText(this.messages.get("BROWSE"));
        this.browseDiskBButton.addActionListener(this);
        JLabel fddModeLabel = new JLabel(this.messages.get("CONFIGURATION"));
        fddModeLabel.setHorizontalAlignment(11);
        String[] fddModesModes = (String[])Arrays.asList(FDDMode.values()).stream().map(f -> this.messages.get(f.toString())).toArray(String[]::new);
        this.fddModesComboBox = new JComboBox<String>(fddModesModes);
        GroupLayout groupLayout = new GroupLayout(diskPanel);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(diskALabel, -2, 125, -2).addGap(5).addComponent(this.diskATextField, -2, 315, -2).addComponent(this.browseDiskAButton, -2, 35, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(diskBLabel, -2, 125, -2).addGap(5).addComponent(this.diskBTextField, -2, 315, -2).addComponent(this.browseDiskBButton, -2, 35, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(fddModeLabel, -2, 125, -2).addGap(5).addComponent(this.fddModesComboBox, -2, -2, -2)))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(35).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(3).addComponent(diskALabel)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.diskATextField, -2, -1, -2).addComponent(this.browseDiskAButton))).addGap(18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4).addComponent(diskBLabel)).addGroup(groupLayout.createSequentialGroup().addGap(1).addComponent(this.diskBTextField, -2, -1, -2)).addComponent(this.browseDiskBButton)).addGap(18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(fddModeLabel).addComponent(this.fddModesComboBox))));
        diskPanel.setLayout(groupLayout);
        tabbedPane.addTab(this.messages.get("DISK"), diskPanel);
    }

    private void addTapeTab(JTabbedPane tabbedPane) {
        JPanel tapePanel = new JPanel(false);
        JLabel tapeLabel = new JLabel(this.messages.get("TAPE"));
        tapeLabel.setHorizontalAlignment(11);
        this.tapeTextField = new JTextFieldDragDrop();
        this.tapeTextField.setColumns(10);
        this.browseTapeButton = new JButton(Icons.FOLDER.getImageIcon());
        this.browseTapeButton.setToolTipText(this.messages.get("BROWSE"));
        this.browseTapeButton.addActionListener(this);
        GroupLayout groupLayout = new GroupLayout(tapePanel);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5).addComponent(tapeLabel, -2, 125, -2).addGap(5).addComponent(this.tapeTextField, -2, 315, -2).addComponent(this.browseTapeButton, -2, 35, -2)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(35).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(3).addComponent(tapeLabel)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tapeTextField, -2, -1, -2).addComponent(this.browseTapeButton))).addGap(95)));
        tapePanel.setLayout(groupLayout);
        tabbedPane.addTab(this.messages.get("TAPE"), tapePanel);
    }

    private void addHarddiskTab(JTabbedPane tabbedPane) {
        JPanel harddiskPanel = new JPanel(false);
        JLabel harddiskLabel = new JLabel(this.messages.get("HARDDISK"));
        harddiskLabel.setHorizontalAlignment(11);
        this.harddiskTextField = new JTextFieldDragDrop();
        this.harddiskTextField.setColumns(10);
        this.browseHarddiskButton = new JButton(Icons.FOLDER.getImageIcon());
        this.browseHarddiskButton.setToolTipText(this.messages.get("BROWSE"));
        this.browseHarddiskButton.addActionListener(this);
        GroupLayout groupLayout = new GroupLayout(harddiskPanel);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5).addComponent(harddiskLabel, -2, 125, -2).addGap(5).addComponent(this.harddiskTextField, -2, 315, -2).addComponent(this.browseHarddiskButton, -2, 35, -2)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(35).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(3).addComponent(harddiskLabel)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.harddiskTextField, -2, -1, -2).addComponent(this.browseHarddiskButton))).addGap(95)));
        harddiskPanel.setLayout(groupLayout);
        tabbedPane.addTab(this.messages.get("HARDDISK"), harddiskPanel);
    }

    private void addLaserdiscTab(JTabbedPane tabbedPane) {
        JPanel laserdiscPanel = new JPanel(false);
        JLabel laserdiscLabel = new JLabel(this.messages.get("LASERDISC"));
        laserdiscLabel.setHorizontalAlignment(11);
        this.laserdiscTextField = new JTextFieldDragDrop();
        this.laserdiscTextField.setColumns(10);
        this.browseLaserdiscButton = new JButton(Icons.FOLDER.getImageIcon());
        this.browseLaserdiscButton.setToolTipText(this.messages.get("BROWSE"));
        this.browseLaserdiscButton.addActionListener(this);
        GroupLayout groupLayout = new GroupLayout(laserdiscPanel);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5).addComponent(laserdiscLabel, -2, 125, -2).addGap(5).addComponent(this.laserdiscTextField, -2, 315, -2).addComponent(this.browseLaserdiscButton, -2, 35, -2)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(35).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(3).addComponent(laserdiscLabel)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laserdiscTextField, -2, -1, -2).addComponent(this.browseLaserdiscButton))).addGap(95)));
        laserdiscPanel.setLayout(groupLayout);
        tabbedPane.addTab(this.messages.get("LASERDISC"), laserdiscPanel);
    }

    private void addScriptTab(JTabbedPane tabbedPane) {
        JPanel scriptPanel = new JPanel(false);
        JLabel scriptLabel = new JLabel(this.messages.get("SCRIPT"));
        scriptLabel.setHorizontalAlignment(11);
        this.scriptTextField = new JTextFieldDragDrop();
        this.scriptTextField.setColumns(10);
        this.browseScriptButton = new JButton(Icons.FOLDER.getImageIcon());
        this.browseScriptButton.setToolTipText(this.messages.get("BROWSE"));
        this.browseScriptButton.addActionListener(this);
        this.scriptOverrideCheckBox = new JCheckBox(this.messages.get("OVERRIDE_OTHER_ARGUMENTS"));
        GroupLayout groupLayout = new GroupLayout(scriptPanel);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5).addComponent(scriptLabel, -2, 125, -2).addGap(5).addComponent(this.scriptTextField, -2, 315, -2).addComponent(this.browseScriptButton, -2, 35, -2)).addGroup(groupLayout.createSequentialGroup().addGap(110).addComponent(this.scriptOverrideCheckBox, -2, -1, -2)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(35).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(3).addComponent(scriptLabel).addGap(32).addComponent(this.scriptOverrideCheckBox)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scriptTextField, -2, -1, -2).addComponent(this.browseScriptButton))).addGap(95)));
        scriptPanel.setLayout(groupLayout);
        tabbedPane.addTab(this.messages.get("SCRIPT"), scriptPanel);
    }
}

