/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MainPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.UserInputTextField;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.UserInputWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.Component;
import java.util.Map;

public class CreateEmptyDatabaseWindow {
    private final MainPresenter presenter;
    private final Map<String, String> messages;
    private final boolean rightToLeft;
    private final Component parent;

    public CreateEmptyDatabaseWindow(MainPresenter presenter, Language language, boolean rightToLeft, Component parent) {
        this.presenter = presenter;
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
        this.rightToLeft = rightToLeft;
        this.parent = parent;
    }

    public void displayAndGetNewDatabaseName() {
        UserInputWindow<String> userInputWindow = new UserInputWindow<String>(this.parent, this.messages, this.rightToLeft, this.messages.get("CREATE_EMPTY_DATABASE"), this.messages.get("CREATE_NEW_DATABASE_MESSAGE"), new UserInputTextField(null));
        String userInput = userInputWindow.displayAndGetUserInput();
        if (userInput != null) {
            try {
                this.presenter.onRequestCreateEmptyDatabaseAction(userInput);
                this.presenter.onViewUpdatedDatabase(userInput);
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox(this.parent, le, this.messages, this.rightToLeft);
            }
        }
    }
}

