/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.presenter.DatabaseAndBackups;
import info.msxlaunchers.openmsx.launcher.ui.presenter.DatabaseInfo;
import info.msxlaunchers.openmsx.launcher.ui.presenter.DatabaseManagerPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.GlobalSwingContext;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.MainWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.JTableButtonColumn;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.images.Icons;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class DatabaseManagerWindow
extends JDialog
implements ActionListener {
    private final DatabaseManagerPresenter presenter;
    private final Map<String, String> messages;
    private final boolean rightToLeft;
    private final Component mainWindow;
    private final DatabaseManagerWindow thisWindow = this;
    private TableModel tableModel;
    private JButton deleteAllBackupsButton;
    private JButton okButton;
    private JLabel totalDatabasesValue;
    private JLabel totalGamesValue;
    private JLabel totalBackupsValue;

    public DatabaseManagerWindow(DatabaseManagerPresenter presenter, Language language, boolean rightToLeft) {
        this.presenter = presenter;
        this.rightToLeft = rightToLeft;
        this.mainWindow = GlobalSwingContext.getIntance().getMainWindow();
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
    }

    public void display(Set<DatabaseAndBackups> databasesAndBackups) {
        this.setDefaultCloseOperation(2);
        this.setTitle(this.messages.get("DATABASE_MANAGER"));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(contentPane);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel databasesTablePane = new JPanel();
        databasesTablePane.setLayout(new BoxLayout(databasesTablePane, 1));
        databasesTablePane.setBorder(BorderFactory.createTitledBorder(this.messages.get("DATABASES")));
        JPanel tablePane = new JPanel();
        this.tableModel = new TableModel();
        JTable table = new JTable(this.tableModel);
        table.setRowSelectionAllowed(false);
        table.setPreferredScrollableViewportSize(new Dimension(450, 82));
        table.getColumnModel().getColumn(0).setPreferredWidth(280);
        table.getColumnModel().getColumn(1).setPreferredWidth(70);
        table.getColumnModel().getColumn(2).setPreferredWidth(70);
        table.getColumnModel().getColumn(3).setPreferredWidth(10);
        table.getColumnModel().getColumn(4).setPreferredWidth(10);
        table.getColumnModel().getColumn(5).setPreferredWidth(10);
        AbstractAction backupAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DatabaseManagerWindow.this.backupTableRow(Integer.parseInt(e.getActionCommand()));
                }
                catch (LauncherException le) {
                    MessageBoxUtil.showErrorMessageBox((Component)DatabaseManagerWindow.this.thisWindow, le, (Map<String, String>)DatabaseManagerWindow.this.messages, DatabaseManagerWindow.this.rightToLeft);
                }
            }
        };
        new JTableButtonColumn(table, backupAction, 3, Icons.BACKUP_SMALL.getImageIcon(), this.messages.get("MANAGE_BACKUPS"));
        AbstractAction editAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DatabaseManagerWindow.this.editTableRow(Integer.parseInt(e.getActionCommand()));
                }
                catch (LauncherException le) {
                    MessageBoxUtil.showErrorMessageBox((Component)DatabaseManagerWindow.this.thisWindow, le, (Map<String, String>)DatabaseManagerWindow.this.messages, DatabaseManagerWindow.this.rightToLeft);
                }
            }
        };
        new JTableButtonColumn(table, editAction, 4, Icons.EDIT_SMALL.getImageIcon(), this.messages.get("RENAME"));
        AbstractAction deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DatabaseManagerWindow.this.removeRowFromTable(Integer.parseInt(e.getActionCommand()));
                }
                catch (LauncherException le) {
                    MessageBoxUtil.showErrorMessageBox((Component)DatabaseManagerWindow.this.thisWindow, le, (Map<String, String>)DatabaseManagerWindow.this.messages, DatabaseManagerWindow.this.rightToLeft);
                }
            }
        };
        new JTableButtonColumn(table, deleteAction, 5, Icons.DELETE_SMALL.getImageIcon(), this.messages.get("DELETE"));
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setVerticalScrollBarPolicy(22);
        tablePane.add(scrollPane);
        databasesTablePane.add(tablePane);
        JPanel deleteBackupsButtonPane = new JPanel();
        this.deleteAllBackupsButton = new JButton(this.messages.get("DELETE_ALL_BACKUPS"));
        this.deleteAllBackupsButton.addActionListener(this);
        deleteBackupsButtonPane.add(this.deleteAllBackupsButton);
        databasesTablePane.add(deleteBackupsButtonPane);
        contentPane.add(databasesTablePane);
        databasesAndBackups.stream().forEach(db -> this.tableModel.addRow(new Object[]{db.getName(), db.getTotalGames(), db.getTotalBackups()}));
        JPanel informationPane = new JPanel();
        informationPane.setBorder(BorderFactory.createTitledBorder(this.messages.get("INFORMATION")));
        GridBagLayout gridBagLayout = new GridBagLayout();
        informationPane.setLayout(gridBagLayout);
        GridBagConstraints valueConstraints = new GridBagConstraints();
        valueConstraints.fill = 2;
        valueConstraints.anchor = 18;
        valueConstraints.weightx = 1.0;
        valueConstraints.gridwidth = 0;
        valueConstraints.insets = new Insets(2, 2, 2, 4);
        GridBagConstraints labelConstraints = (GridBagConstraints)valueConstraints.clone();
        labelConstraints.weightx = 0.0;
        labelConstraints.gridwidth = 1;
        labelConstraints.insets = new Insets(2, 14, 2, 4);
        this.totalDatabasesValue = new JLabel();
        this.totalGamesValue = new JLabel();
        this.totalBackupsValue = new JLabel();
        Set<String> databases = databasesAndBackups.stream().map(d -> d.getName()).collect(Collectors.toSet());
        DatabaseInfo databaseInfo = this.presenter.getDatabaseInfo(databases);
        this.addPropertyToDisplay(this.messages.get("TOTAL_DATABASES"), this.totalDatabasesValue, databaseInfo.getTotalDatabases(), gridBagLayout, labelConstraints, valueConstraints, informationPane);
        this.addPropertyToDisplay(this.messages.get("TOTAL_GAMES"), this.totalGamesValue, databaseInfo.getTotalGames(), gridBagLayout, labelConstraints, valueConstraints, informationPane);
        this.addPropertyToDisplay(this.messages.get("TOTAL_BACKUPS"), this.totalBackupsValue, databaseInfo.getTotalBackups(), gridBagLayout, labelConstraints, valueConstraints, informationPane);
        contentPane.add(informationPane);
        this.enableOrDisableDeleteAllBackupsButton(databaseInfo.getTotalBackups());
        JPanel buttonsPane = new JPanel();
        buttonsPane.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = new JButton(this.messages.get("OK"));
        this.okButton.addActionListener(this);
        this.okButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        buttonsPane.add(this.okButton);
        contentPane.add(buttonsPane);
        if (this.rightToLeft) {
            databasesTablePane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            table.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            DefaultTableCellRenderer tableRenderer = new DefaultTableCellRenderer();
            tableRenderer.setHorizontalAlignment(4);
            table.getColumnModel().getColumn(0).setCellRenderer(tableRenderer);
            table.getColumnModel().getColumn(1).setCellRenderer(tableRenderer);
            table.getColumnModel().getColumn(2).setCellRenderer(tableRenderer);
            ((DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(4);
            informationPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            deleteBackupsButtonPane.setLayout(new FlowLayout(2));
        } else {
            deleteBackupsButtonPane.setLayout(new FlowLayout(0));
        }
        this.pack();
        this.setLocationRelativeTo(this.mainWindow);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.dispose();
        } else if (source == this.deleteAllBackupsButton) {
            this.deleteAllBackups();
        }
    }

    public void updateDatabaseAndBackupsTable(String database, int gamesTotal, int backupsTotal) {
        boolean done = false;
        for (int index = 0; !done || index < this.tableModel.getRowCount(); ++index) {
            if (!((String)this.tableModel.getValueAt(index, 0)).equals(database)) continue;
            this.tableModel.setValueAt(gamesTotal, index, 1);
            this.tableModel.setValueAt(backupsTotal, index, 2);
            done = true;
        }
    }

    public void updateDatabasesInfo(DatabaseInfo databaseInfo) {
        this.totalDatabasesValue.setText("" + databaseInfo.getTotalDatabases());
        this.totalGamesValue.setText("" + databaseInfo.getTotalGames());
        this.totalBackupsValue.setText("" + databaseInfo.getTotalBackups());
        this.enableOrDisableDeleteAllBackupsButton(databaseInfo.getTotalBackups());
    }

    private void deleteAllBackups() {
        if (MessageBoxUtil.showYesNoMessageBox((Component)this, this.messages.get("DELETE_ALL_BACKUPS_CONFIRMATION"), this.messages, this.rightToLeft) == 0) {
            try {
                this.presenter.onRequestDeleteAllBackups();
                this.presenter.updateDatabaseInfoView();
                for (int index = 0; index < this.tableModel.getRowCount(); ++index) {
                    if ((Integer)this.tableModel.getValueAt(index, 2) <= 0) continue;
                    this.presenter.updateDatabaseAndBackupsView((String)this.tableModel.getValueAt(index, 0));
                }
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox((Component)this.thisWindow, le, this.messages, this.rightToLeft);
            }
        }
    }

    private void enableOrDisableDeleteAllBackupsButton(int totalBackups) {
        this.deleteAllBackupsButton.setEnabled(totalBackups > 0);
    }

    private void backupTableRow(int index) throws LauncherException {
        this.presenter.onRequestDatabaseBackupsScreen((String)this.tableModel.getValueAt(index, 0));
    }

    private void editTableRow(int index) throws LauncherException {
        String newName = this.presenter.onRequestRenameDatabaseScreen((String)this.tableModel.getValueAt(index, 0));
        if (newName != null) {
            int insertIndex;
            int currentTotalGames = (Integer)this.tableModel.getValueAt(index, 1);
            int currentTotalBackups = (Integer)this.tableModel.getValueAt(index, 2);
            this.tableModel.removeRow(index);
            for (insertIndex = 0; insertIndex < this.tableModel.getRowCount() && ((String)this.tableModel.getValueAt(insertIndex, 0)).compareToIgnoreCase(newName) < 0; ++insertIndex) {
            }
            this.tableModel.insertRow(insertIndex, new Object[]{newName, currentTotalGames, currentTotalBackups});
        }
    }

    private void removeRowFromTable(int index) throws LauncherException {
        if (MessageBoxUtil.showYesNoMessageBox((Component)this, this.messages.get("DELETE_CONFIRMATION"), this.messages, this.rightToLeft) == 0) {
            String database = (String)this.tableModel.getValueAt(index, 0);
            this.presenter.onRequestDeleteDatabase(database);
            this.presenter.updateDatabaseInfoView();
            this.tableModel.removeRow(index);
        }
    }

    private void addPropertyToDisplay(String attribute, JLabel valueLabel, int value, GridBagLayout layout, GridBagConstraints labelConstraints, GridBagConstraints valueConstraints, JPanel panel) {
        JLabel attributeLabel = new JLabel(attribute + ":");
        layout.setConstraints(attributeLabel, labelConstraints);
        panel.add(attributeLabel);
        valueLabel.setText("" + value);
        if (this.rightToLeft) {
            attributeLabel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            valueLabel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        layout.setConstraints(valueLabel, valueConstraints);
        panel.add(valueLabel);
    }

    private class TableModel
    extends DefaultTableModel {
        private final String[] columnNames;

        private TableModel() {
            this.columnNames = new String[]{(String)DatabaseManagerWindow.this.messages.get("DATABASE"), (String)DatabaseManagerWindow.this.messages.get("GAMES"), (String)DatabaseManagerWindow.this.messages.get("BACKUPS"), "", "", ""};
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }
    }
}

