/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterParameter;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterType;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Genre;
import info.msxlaunchers.openmsx.launcher.data.game.constants.MSXGeneration;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Sound;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.FilterItemObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class FilterUtils {
    FilterUtils() {
    }

    static List<String> getFiltersStringRepresentation(List<String> filterMonikers, Map<String, String> messages) {
        return filterMonikers.stream().sorted().map(FilterUtils::getFilterItemObject).map(f -> (String)messages.get(f.type.toString()) + ": " + FilterUtils.getFilterDescriptor(f.type, f.value1, f.value2, f.parameter, messages)).collect(Collectors.toList());
    }

    static FilterItemObject getFilterItemObject(String filterMoniker) {
        FilterParameter parameter;
        String value2;
        String[] filterMonikerParts = filterMoniker.split(":");
        FilterType type = FilterType.valueOf(filterMonikerParts[0]);
        String value1 = filterMonikerParts[1];
        if (filterMonikerParts.length == 4) {
            value2 = filterMonikerParts[2];
            parameter = FilterParameter.valueOf(filterMonikerParts[3]);
        } else {
            value2 = null;
            parameter = null;
        }
        return new FilterItemObject(type, value1, value2, parameter);
    }

    static String getFilterDescriptor(FilterType type, String value1, String value2, FilterParameter parameter, Map<String, String> messages) {
        String descriptor = null;
        switch (type) {
            case COMPANY: 
            case VIDEO_SOURCE: {
                descriptor = value1;
                break;
            }
            case COUNTRY: 
            case MEDIUM: {
                descriptor = messages.get(value1);
                break;
            }
            case GENERATION: {
                descriptor = MSXGeneration.valueOf(value1).getDisplayName();
                break;
            }
            case GENRE: {
                descriptor = Genre.valueOf(value1).getDisplayName();
                break;
            }
            case SOUND: {
                descriptor = Sound.valueOf(value1).getDisplayName();
                break;
            }
            case SIZE: {
                descriptor = FilterUtils.getFilterWithParameterDescriptor(Utils.getString(Integer.parseInt(value1) / 1024), Utils.getString(Integer.parseInt(value2) / 1024), parameter, " KB");
                break;
            }
            case YEAR: {
                descriptor = FilterUtils.getFilterWithParameterDescriptor(value1, value2, parameter, "");
            }
        }
        return descriptor;
    }

    private static String getFilterWithParameterDescriptor(String value1, String value2, FilterParameter parameter, String valueUnit) {
        StringBuilder buffer = new StringBuilder();
        switch (parameter) {
            case EQUAL: {
                buffer.append("= ").append(value1).append(valueUnit);
                break;
            }
            case EQUAL_OR_GREATER: {
                buffer.append(">= ").append(value1).append(valueUnit);
                break;
            }
            case EQUAL_OR_LESS: {
                buffer.append("<= ").append(value1).append(valueUnit);
                break;
            }
            case GREATER: {
                buffer.append("> ").append(value1).append(valueUnit);
                break;
            }
            case LESS: {
                buffer.append("< ").append(value1).append(valueUnit);
                break;
            }
            case BETWEEN_INCLUSIVE: {
                buffer.append(">= ").append(value1).append(valueUnit).append(" , ").append("<= ").append(value2).append(valueUnit);
            }
        }
        return buffer.toString();
    }
}

