/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.common.FileTypeUtils;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.extractor.ExtractorData;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LHAExtractorPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.GlobalSwingContext;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.MainWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.WindowUtils;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.JTextFieldDragDrop;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.images.Icons;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class LHAExtractorWindow
extends JDialog
implements ActionListener {
    private final LHAExtractorPresenter presenter;
    private final Map<String, String> messages;
    private final boolean rightToLeft;
    private final Component mainWindow;
    private JTextField compressedFileTextField;
    private JButton compressedFileButton;
    private JCheckBox onlyMSXFilesCheckBox;
    private JTextField targetDirectoryTextField;
    private JRadioButton targetOtherDirectoryRadioButton;
    private JRadioButton targetDirectorySameAsFileRadioButton;
    private JButton targetDirectoryButton;
    private JButton okButton;
    private JButton cancelButton;
    private static final FlowLayout LEFT_FLOW_LAYOUT = new FlowLayout(0);
    private static final FlowLayout RIGHT_FLOW_LAYOUT = new FlowLayout(2);

    public LHAExtractorWindow(LHAExtractorPresenter presenter, Language language, boolean rightToLeft) {
        this.presenter = presenter;
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
        this.rightToLeft = rightToLeft;
        this.mainWindow = GlobalSwingContext.getIntance().getMainWindow();
    }

    public void displayScreen() {
        this.setDefaultCloseOperation(2);
        this.setTitle(this.messages.get("LHA_EXTRACTOR"));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(contentPane);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel sourcePane = new JPanel();
        sourcePane.setBorder(BorderFactory.createTitledBorder(this.messages.get("INPUT")));
        sourcePane.setLayout(new BoxLayout(sourcePane, 1));
        JPanel compressedFilePane = new JPanel();
        JLabel compressedFileLabel = new JLabel(this.messages.get("COMPRESSED_FILE"));
        compressedFilePane.add(compressedFileLabel);
        this.compressedFileTextField = new JTextFieldDragDrop();
        this.compressedFileTextField.setColumns(25);
        compressedFilePane.add(this.compressedFileTextField);
        this.compressedFileButton = new JButton(Icons.FOLDER.getImageIcon());
        this.compressedFileButton.addActionListener(this);
        this.compressedFileButton.setToolTipText(this.messages.get("BROWSE"));
        this.compressedFileButton.setPreferredSize(WindowUtils.iconButtonDimension);
        compressedFilePane.add(this.compressedFileButton);
        sourcePane.add(compressedFilePane);
        JPanel onlyMSXFilesPane = new JPanel();
        JPanel ipsChecksumVerifyPane = new JPanel();
        this.onlyMSXFilesCheckBox = new JCheckBox(this.messages.get("ONLY_MSX_FILES"));
        this.onlyMSXFilesCheckBox.addActionListener(this);
        ipsChecksumVerifyPane.add(this.onlyMSXFilesCheckBox);
        ipsChecksumVerifyPane.setBorder(new EmptyBorder(1, 1, 1, WindowUtils.iconButtonDimension.width + 6));
        onlyMSXFilesPane.add(ipsChecksumVerifyPane);
        sourcePane.add(onlyMSXFilesPane);
        contentPane.add(sourcePane);
        JPanel targetPane = new JPanel();
        targetPane.setBorder(BorderFactory.createTitledBorder(this.messages.get("OUTPUT")));
        targetPane.setLayout(new BoxLayout(targetPane, 1));
        JPanel targetDirectoryPane = new JPanel();
        this.targetOtherDirectoryRadioButton = new JRadioButton(this.messages.get("SPECIFY_DIRECTORY"));
        this.targetOtherDirectoryRadioButton.addActionListener(this);
        targetDirectoryPane.add(this.targetOtherDirectoryRadioButton);
        targetPane.add(targetDirectoryPane);
        JPanel targetFilePane = new JPanel();
        JLabel targetDirectoryLabel = new JLabel(this.messages.get("DIRECTORY"));
        targetFilePane.add(targetDirectoryLabel);
        this.targetDirectoryTextField = new JTextField();
        this.targetDirectoryTextField.setColumns(25);
        targetFilePane.add(this.targetDirectoryTextField);
        this.targetDirectoryButton = new JButton(Icons.FOLDER.getImageIcon());
        this.targetDirectoryButton.addActionListener(this);
        this.targetDirectoryButton.setToolTipText(this.messages.get("BROWSE"));
        this.targetDirectoryButton.setPreferredSize(WindowUtils.iconButtonDimension);
        targetFilePane.add(this.targetDirectoryButton);
        targetPane.add(targetFilePane);
        JPanel directorySameAsFilePane = new JPanel();
        targetPane.add(directorySameAsFilePane);
        contentPane.add(targetPane);
        this.targetDirectorySameAsFileRadioButton = new JRadioButton(this.messages.get("USE_SAME_DIRECTORY_AS_FILE"));
        this.targetDirectorySameAsFileRadioButton.addActionListener(this);
        directorySameAsFilePane.add(this.targetDirectorySameAsFileRadioButton);
        targetPane.add(directorySameAsFilePane);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.targetOtherDirectoryRadioButton);
        buttonGroup.add(this.targetDirectorySameAsFileRadioButton);
        JPanel buttonsPane = new JPanel();
        buttonsPane.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = new JButton(this.messages.get("OK"));
        this.okButton.addActionListener(this);
        this.okButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        buttonsPane.add(this.okButton);
        this.cancelButton = new JButton(this.messages.get("CANCEL"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        buttonsPane.add(this.cancelButton);
        contentPane.add(buttonsPane);
        this.onlyMSXFilesCheckBox.setSelected(true);
        this.targetOtherDirectoryRadioButton.setSelected(true);
        if (this.rightToLeft) {
            sourcePane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            targetPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            compressedFilePane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            compressedFilePane.setLayout(LEFT_FLOW_LAYOUT);
            ipsChecksumVerifyPane.setLayout(LEFT_FLOW_LAYOUT);
            ipsChecksumVerifyPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.onlyMSXFilesCheckBox.setHorizontalTextPosition(10);
            this.targetOtherDirectoryRadioButton.setHorizontalTextPosition(10);
            this.targetDirectorySameAsFileRadioButton.setHorizontalTextPosition(10);
            targetFilePane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            targetFilePane.setLayout(LEFT_FLOW_LAYOUT);
            targetDirectoryPane.setLayout(RIGHT_FLOW_LAYOUT);
            directorySameAsFilePane.setLayout(LEFT_FLOW_LAYOUT);
            directorySameAsFilePane.setLayout(RIGHT_FLOW_LAYOUT);
            buttonsPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        } else {
            compressedFilePane.setLayout(RIGHT_FLOW_LAYOUT);
            ipsChecksumVerifyPane.setLayout(RIGHT_FLOW_LAYOUT);
            targetFilePane.setLayout(RIGHT_FLOW_LAYOUT);
            targetDirectoryPane.setLayout(LEFT_FLOW_LAYOUT);
            directorySameAsFilePane.setLayout(LEFT_FLOW_LAYOUT);
        }
        this.pack();
        this.setLocationRelativeTo(this.mainWindow);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.compressedFileButton) {
            WindowUtils.browseFile(this, this.compressedFileTextField, "LHA", FileTypeUtils.getLHAExtensions(), false);
        } else if (source == this.targetDirectoryButton) {
            WindowUtils.browseForDirectory(this, this.targetDirectoryTextField);
        } else if (source == this.targetOtherDirectoryRadioButton) {
            this.targetDirectoryTextField.setEnabled(true);
            this.targetDirectoryButton.setEnabled(true);
        } else if (source == this.targetDirectorySameAsFileRadioButton) {
            this.targetDirectoryTextField.setEnabled(false);
            this.targetDirectoryButton.setEnabled(false);
        } else if (source == this.okButton) {
            this.processExtractRequest();
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }

    private void processExtractRequest() {
        try {
            ExtractorData extractorData = this.presenter.onRequestLHAExtractAction(this.compressedFileTextField.getText(), this.targetOtherDirectoryRadioButton.isSelected() ? this.targetDirectoryTextField.getText() : null, this.onlyMSXFilesCheckBox.isSelected());
            MessageBoxUtil.showInformationMessageBox(this.mainWindow, this.formatExtractorDataAsHtml(extractorData), this.messages, this.rightToLeft);
            this.dispose();
        }
        catch (LauncherException le) {
            MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.rightToLeft);
        }
    }

    private String formatExtractorDataAsHtml(ExtractorData extractorData) {
        return "<html><table>" + this.makeTableRow(this.messages.get("TOTAL_FILES"), extractorData.getTotalFiles()) + this.makeTableRow(this.messages.get("TOTAL_MSX_IMAGES"), extractorData.getTotalMSXImages()) + this.makeTableRow(this.messages.get("TOTAL_EXTRACTED_FILES"), extractorData.getTotalExtractedFiles()) + "</table></html>";
    }

    private String makeTableRow(String key, int value) {
        return "<tr><td>" + key + ":</td><td>" + value + "</td></tr>";
    }
}

