/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.common.FileTypeUtils;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.patch.PatchMethod;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.PatcherPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.GlobalSwingContext;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.MainWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.WindowUtils;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.JTextFieldDragDrop;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.images.Icons;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;

public class PatcherWindow
extends JDialog
implements ActionListener {
    private final PatcherPresenter presenter;
    private final Map<String, String> messages;
    private final boolean rightToLeft;
    private final Component mainWindow;
    private JComboBox<PatchMethod> patchMethodComboBox;
    private JTextField patchFileTextField;
    private JButton patchFileButton;
    private JTextField sourceFileTextField;
    private JButton sourceFileButton;
    private JPanel verifyChecksumPane;
    private JCheckBox verifyChecksumCheckBox;
    private JTextField checksumTextField;
    private JCheckBox skipCRCVerificationCheckBox;
    private JLabel targetFileLabel;
    private JTextField targetFileTextField;
    private JButton targetFileButton;
    private JRadioButton targetPatchedFileRadioButton;
    private JRadioButton patchDirectlyRadioButton;
    private JButton okButton;
    private JButton cancelButton;
    private static final FlowLayout LEFT_FLOW_LAYOUT = new FlowLayout(0);
    private static final FlowLayout RIGHT_FLOW_LAYOUT = new FlowLayout(2);

    public PatcherWindow(PatcherPresenter presenter, Language language, boolean rightToLeft) {
        this.presenter = presenter;
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
        this.rightToLeft = rightToLeft;
        this.mainWindow = GlobalSwingContext.getIntance().getMainWindow();
    }

    public void displayScreen() {
        this.setDefaultCloseOperation(2);
        this.setTitle(this.messages.get("PATCH_CENTER"));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(contentPane);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel sourcesPane = new JPanel();
        sourcesPane.setBorder(BorderFactory.createTitledBorder(this.messages.get("INPUT")));
        sourcesPane.setLayout(new BoxLayout(sourcesPane, 1));
        JPanel patchMethodPane = new JPanel();
        JLabel patchMethodLabel = new JLabel(this.messages.get("METHOD"));
        patchMethodPane.add(patchMethodLabel);
        this.patchMethodComboBox = new JComboBox();
        this.patchMethodComboBox.addItem(PatchMethod.IPS);
        this.patchMethodComboBox.addItem(PatchMethod.UPS);
        this.patchMethodComboBox.setPreferredSize(new Dimension(this.patchMethodComboBox.getPreferredSize().width + 20, this.patchMethodComboBox.getPreferredSize().height));
        this.patchMethodComboBox.addActionListener(this);
        patchMethodPane.add(this.patchMethodComboBox);
        sourcesPane.add(patchMethodPane);
        JPanel patchFilePane = new JPanel();
        JLabel patchFileLabel = new JLabel(this.messages.get("PATCH"));
        patchFilePane.add(patchFileLabel);
        this.patchFileTextField = new JTextFieldDragDrop();
        this.patchFileTextField.setColumns(25);
        patchFilePane.add(this.patchFileTextField);
        this.patchFileButton = new JButton(Icons.FOLDER.getImageIcon());
        this.patchFileButton.addActionListener(this);
        this.patchFileButton.setToolTipText(this.messages.get("BROWSE"));
        this.patchFileButton.setPreferredSize(WindowUtils.iconButtonDimension);
        patchFilePane.add(this.patchFileButton);
        sourcesPane.add(patchFilePane);
        JPanel sourceFilePane = new JPanel();
        JLabel sourceFileLabel = new JLabel(this.messages.get("SOURCE"));
        sourceFilePane.add(sourceFileLabel);
        this.sourceFileTextField = new JTextFieldDragDrop();
        this.sourceFileTextField.setColumns(25);
        sourceFilePane.add(this.sourceFileTextField);
        this.sourceFileButton = new JButton(Icons.FOLDER.getImageIcon());
        this.sourceFileButton.addActionListener(this);
        this.sourceFileButton.setToolTipText(this.messages.get("BROWSE"));
        this.sourceFileButton.setPreferredSize(WindowUtils.iconButtonDimension);
        sourceFilePane.add(this.sourceFileButton);
        sourcesPane.add(sourceFilePane);
        this.verifyChecksumPane = new JPanel();
        CardLayout cardLayout = new CardLayout();
        this.verifyChecksumPane.setLayout(cardLayout);
        JPanel ipsChecksumVerifyPane = new JPanel();
        this.verifyChecksumCheckBox = new JCheckBox(this.messages.get("VERIFY_CHECKSUM"));
        this.verifyChecksumCheckBox.addActionListener(this);
        ipsChecksumVerifyPane.add(this.verifyChecksumCheckBox);
        this.checksumTextField = new JTextField();
        this.checksumTextField.setColumns(18);
        this.checksumTextField.setToolTipText("[ SHA1 , MD5 , CRC32 ]");
        ipsChecksumVerifyPane.add(this.checksumTextField);
        ipsChecksumVerifyPane.setBorder(new EmptyBorder(1, 1, 1, WindowUtils.iconButtonDimension.width + 6));
        this.verifyChecksumPane.add((Component)ipsChecksumVerifyPane, PatchMethod.IPS.toString());
        JPanel upsChecksumVerifyPane = new JPanel();
        this.skipCRCVerificationCheckBox = new JCheckBox(this.messages.get("SKIP_CRC"));
        upsChecksumVerifyPane.add(this.skipCRCVerificationCheckBox);
        upsChecksumVerifyPane.setBorder(new EmptyBorder(6, 1, 1, WindowUtils.iconButtonDimension.width + 6 + this.patchFileTextField.getPreferredSize().width - this.skipCRCVerificationCheckBox.getPreferredSize().width));
        this.verifyChecksumPane.add((Component)upsChecksumVerifyPane, PatchMethod.UPS.toString());
        cardLayout.show(this.verifyChecksumPane, PatchMethod.IPS.toString());
        sourcesPane.add(this.verifyChecksumPane);
        patchMethodPane.setBorder(new EmptyBorder(1, 1, 1, WindowUtils.iconButtonDimension.width + 6 + this.patchFileTextField.getPreferredSize().width - this.patchMethodComboBox.getPreferredSize().width));
        contentPane.add(sourcesPane);
        JPanel targetPane = new JPanel();
        targetPane.setBorder(BorderFactory.createTitledBorder(this.messages.get("OUTPUT")));
        targetPane.setLayout(new BoxLayout(targetPane, 1));
        JPanel targetPatchedFilePane = new JPanel();
        this.targetPatchedFileRadioButton = new JRadioButton(this.messages.get("SPECIFY_LOCATION_PATCHED_FILE"));
        this.targetPatchedFileRadioButton.addActionListener(this);
        targetPatchedFilePane.add(this.targetPatchedFileRadioButton);
        targetPane.add(targetPatchedFilePane);
        JPanel targetFilePane = new JPanel();
        this.targetFileLabel = new JLabel(this.messages.get("TARGET"));
        targetFilePane.add(this.targetFileLabel);
        this.targetFileTextField = new JTextFieldDragDrop();
        this.targetFileTextField.setColumns(25);
        targetFilePane.add(this.targetFileTextField);
        this.targetFileButton = new JButton(Icons.FOLDER.getImageIcon());
        this.targetFileButton.addActionListener(this);
        this.targetFileButton.setToolTipText(this.messages.get("BROWSE"));
        this.targetFileButton.setPreferredSize(WindowUtils.iconButtonDimension);
        targetFilePane.add(this.targetFileButton);
        targetPane.add(targetFilePane);
        JPanel patchDirectlyPane = new JPanel();
        this.patchDirectlyRadioButton = new JRadioButton(this.messages.get("PATCH_DIRECTLY"));
        this.patchDirectlyRadioButton.addActionListener(this);
        patchDirectlyPane.add(this.patchDirectlyRadioButton);
        targetPane.add(patchDirectlyPane);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.targetPatchedFileRadioButton);
        buttonGroup.add(this.patchDirectlyRadioButton);
        contentPane.add(targetPane);
        JPanel buttonsPane = new JPanel();
        buttonsPane.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = new JButton(this.messages.get("OK"));
        this.okButton.addActionListener(this);
        this.okButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        buttonsPane.add(this.okButton);
        this.cancelButton = new JButton(this.messages.get("CANCEL"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        buttonsPane.add(this.cancelButton);
        contentPane.add(buttonsPane);
        this.resetFields();
        if (this.rightToLeft) {
            patchMethodPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            sourcesPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            targetPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            patchFilePane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            patchFilePane.setLayout(LEFT_FLOW_LAYOUT);
            sourceFilePane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            sourceFilePane.setLayout(LEFT_FLOW_LAYOUT);
            sourceFilePane.setBorder(new EmptyBorder(1, 20, 1, 1));
            ipsChecksumVerifyPane.setLayout(LEFT_FLOW_LAYOUT);
            ipsChecksumVerifyPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.verifyChecksumCheckBox.setHorizontalTextPosition(10);
            upsChecksumVerifyPane.setLayout(LEFT_FLOW_LAYOUT);
            upsChecksumVerifyPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.skipCRCVerificationCheckBox.setHorizontalTextPosition(10);
            targetFilePane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            targetFilePane.setLayout(LEFT_FLOW_LAYOUT);
            targetPatchedFilePane.setLayout(RIGHT_FLOW_LAYOUT);
            patchDirectlyPane.setLayout(LEFT_FLOW_LAYOUT);
            patchDirectlyPane.setLayout(RIGHT_FLOW_LAYOUT);
            this.targetPatchedFileRadioButton.setHorizontalTextPosition(10);
            this.patchDirectlyRadioButton.setHorizontalTextPosition(10);
            buttonsPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        } else {
            patchMethodPane.setLayout(RIGHT_FLOW_LAYOUT);
            patchFilePane.setLayout(RIGHT_FLOW_LAYOUT);
            sourceFilePane.setLayout(RIGHT_FLOW_LAYOUT);
            sourceFilePane.setBorder(new EmptyBorder(1, 20, 1, 1));
            ipsChecksumVerifyPane.setLayout(RIGHT_FLOW_LAYOUT);
            upsChecksumVerifyPane.setLayout(RIGHT_FLOW_LAYOUT);
            targetFilePane.setLayout(RIGHT_FLOW_LAYOUT);
            targetPatchedFilePane.setLayout(LEFT_FLOW_LAYOUT);
            patchDirectlyPane.setLayout(LEFT_FLOW_LAYOUT);
        }
        this.pack();
        this.setLocationRelativeTo(this.mainWindow);
        this.setVisible(true);
    }

    public boolean targetFileReplacementIsConfirmed() {
        return MessageBoxUtil.showYesNoMessageBox((Component)this, this.messages.get("CONFIRM_REPLACE_TARGET_FILE_MSG"), this.messages, this.rightToLeft) == 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.patchMethodComboBox) {
            ((CardLayout)this.verifyChecksumPane.getLayout()).show(this.verifyChecksumPane, this.patchMethodComboBox.getSelectedItem().toString());
        } else if (source == this.patchFileButton) {
            WindowUtils.browseFile(this, this.patchFileTextField, this.messages.get("PATCH"), FileTypeUtils.getPatchExtensions(), false);
        } else if (source == this.sourceFileButton) {
            WindowUtils.browseFile(this, this.sourceFileTextField);
        } else if (source == this.targetFileButton) {
            WindowUtils.browseFile(this, this.targetFileTextField);
        } else if (source == this.verifyChecksumCheckBox) {
            this.checksumTextField.setEnabled(this.verifyChecksumCheckBox.isSelected());
        } else if (source == this.patchDirectlyRadioButton) {
            this.targetFileTextField.setEnabled(false);
            this.targetFileButton.setEnabled(false);
            this.targetFileLabel.setEnabled(false);
        } else if (source == this.targetPatchedFileRadioButton) {
            this.targetFileTextField.setEnabled(true);
            this.targetFileButton.setEnabled(true);
            this.targetFileLabel.setEnabled(true);
        } else if (source == this.okButton) {
            this.processPatchRequest();
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }

    private void resetFields() {
        this.patchFileTextField.setText(null);
        this.sourceFileTextField.setText(null);
        this.verifyChecksumCheckBox.setSelected(false);
        this.checksumTextField.setText(null);
        this.checksumTextField.setEnabled(false);
        this.targetPatchedFileRadioButton.setSelected(true);
        this.targetFileTextField.setText(null);
        this.targetFileTextField.setEnabled(true);
        this.targetFileButton.setEnabled(true);
        this.targetFileLabel.setEnabled(true);
    }

    private void processPatchRequest() {
        block5: {
            try {
                boolean isIPSPatchMethod = this.patchMethodComboBox.getSelectedItem().equals((Object)PatchMethod.IPS);
                if (this.presenter.onValidate(this.sourceFileTextField.getText(), this.patchFileTextField.getText(), this.targetPatchedFileRadioButton.isSelected(), this.targetFileTextField.getText(), isIPSPatchMethod, !this.verifyChecksumCheckBox.isSelected(), this.checksumTextField.getText())) {
                    BusyIndicator busyIndicator = new BusyIndicator();
                    busyIndicator.prepareIndicator();
                    PatchTask patchTask = new PatchTask(isIPSPatchMethod, busyIndicator);
                    patchTask.execute();
                    busyIndicator.showIndicator();
                    patchTask.get();
                    MessageBoxUtil.showInformationMessageBox(this.mainWindow, this.messages.get("FILE_PATCHED_SUCCESSFULLY"), this.messages, this.rightToLeft);
                    this.resetFields();
                }
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox(this.mainWindow, le, this.messages, this.rightToLeft);
            }
            catch (InterruptedException le) {
            }
            catch (ExecutionException ee) {
                Throwable ex = ee.getCause();
                if (!(ex instanceof LauncherException)) break block5;
                MessageBoxUtil.showErrorMessageBox(this.mainWindow, (LauncherException)ex, this.messages, this.rightToLeft);
            }
        }
    }

    private class BusyIndicator
    extends JDialog {
        private BusyIndicator() {
        }

        void prepareIndicator() {
            this.setDefaultCloseOperation(2);
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setResizable(false);
            this.setUndecorated(true);
            JPanel panel = new JPanel();
            panel.setBorder(BorderFactory.createEtchedBorder(Color.BLACK, Color.GRAY));
            this.setContentPane(panel);
            if (PatcherWindow.this.rightToLeft) {
                panel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                panel.setLayout(new FlowLayout(2, 8, 8));
            } else {
                panel.setLayout(new FlowLayout(0, 8, 8));
            }
            panel.add(new JLabel(Icons.BUSY_INDICATOR.getImageIcon()));
            panel.add(new JLabel((String)PatcherWindow.this.messages.get("PATCHING") + "..."));
            this.pack();
            this.setLocationRelativeTo(PatcherWindow.this.mainWindow);
        }

        void showIndicator() {
            this.setVisible(true);
        }
    }

    private class PatchTask
    extends SwingWorker<Void, Void> {
        private final boolean isIPSPatchMethod;
        private final BusyIndicator busyIndicator;

        PatchTask(boolean isIPSPatchMethod, BusyIndicator busyIndicator) {
            this.isIPSPatchMethod = isIPSPatchMethod;
            this.busyIndicator = busyIndicator;
        }

        @Override
        protected Void doInBackground() throws LauncherException {
            if (this.isIPSPatchMethod) {
                PatcherWindow.this.presenter.onRequestPatchFileActionForIPS(PatcherWindow.this.patchFileTextField.getText(), PatcherWindow.this.sourceFileTextField.getText(), PatcherWindow.this.targetPatchedFileRadioButton.isSelected(), PatcherWindow.this.targetFileTextField.getText(), !PatcherWindow.this.verifyChecksumCheckBox.isSelected(), PatcherWindow.this.checksumTextField.getText());
            } else {
                PatcherWindow.this.presenter.onRequestPatchFileActionForUPS(PatcherWindow.this.patchFileTextField.getText(), PatcherWindow.this.sourceFileTextField.getText(), PatcherWindow.this.targetPatchedFileRadioButton.isSelected(), PatcherWindow.this.targetFileTextField.getText(), PatcherWindow.this.skipCRCVerificationCheckBox.isSelected());
            }
            return null;
        }

        @Override
        protected void done() {
            this.busyIndicator.dispose();
        }
    }
}

