/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.presenter.DatabaseManagerPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.UserInputTextField;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.UserInputWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.Component;
import java.util.Map;

public class RenameDatabaseWindow {
    private final DatabaseManagerPresenter presenter;
    private final String oldDatabase;
    private final Map<String, String> messages;
    private final boolean rightToLeft;
    private final Component parent;

    public RenameDatabaseWindow(DatabaseManagerPresenter presenter, String oldDatabase, Language language, boolean rightToLeft, Component parent) {
        this.presenter = presenter;
        this.oldDatabase = oldDatabase;
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
        this.rightToLeft = rightToLeft;
        this.parent = parent;
    }

    public String displayAndGetNewDatabaseName() {
        UserInputWindow<String> userInputWindow = new UserInputWindow<String>(this.parent, this.messages, this.rightToLeft, this.messages.get("RENAME_DATABASE"), this.messages.get("RENAME_DATABASE_MESSAGE"), new UserInputTextField(this.oldDatabase));
        String newDatabase = userInputWindow.displayAndGetUserInput();
        if (newDatabase != null) {
            try {
                this.presenter.onRequestRenameDatabaseAction(this.oldDatabase, newDatabase);
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox(this.parent, le, this.messages, this.rightToLeft);
                newDatabase = null;
            }
        }
        return newDatabase;
    }
}

