/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing.component;

import info.msxlaunchers.openmsx.launcher.ui.view.swing.WindowUtils;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JLabel;

public class JCompositeLabel
extends JLabel {
    private final int componentWidth;
    private final int divWidth;
    private final String valueTextAlign;
    private final int maxStringWidthInPixels;
    private final FontMetrics fontMetrics;
    private String currentTitle;
    private String currentValue;
    private String titleTextAlign;
    private static final Color BACKGROUND = new Color(187, 187, 187);
    private static final String textAlignCenter = "center";
    private static final String textAlignLeft = "left";
    private static final String textAlignRight = "right";

    public JCompositeLabel(int componentWidth, int divWidth, boolean valueCenterAligned) {
        this.componentWidth = componentWidth;
        this.divWidth = divWidth;
        this.valueTextAlign = valueCenterAligned ? textAlignCenter : textAlignLeft;
        this.maxStringWidthInPixels = componentWidth - 6;
        this.titleTextAlign = textAlignLeft;
        Font font = new Font(null, 0, 10);
        this.setFont(font);
        this.fontMetrics = this.getFontMetrics(font);
        this.setOpaque(true);
        this.setBackground(BACKGROUND);
    }

    public void setTitle(String title) {
        this.currentTitle = title;
        this.setText(this.getHTMLFormattedText(title, this.currentValue));
    }

    public void setValue(String value) {
        this.currentValue = value;
        this.setText(this.getHTMLFormattedText(this.currentTitle, value));
    }

    @Override
    public void setComponentOrientation(ComponentOrientation orientation) {
        super.setComponentOrientation(orientation);
        if (orientation == ComponentOrientation.RIGHT_TO_LEFT) {
            this.titleTextAlign = textAlignRight;
            this.setHorizontalAlignment(4);
        } else {
            this.titleTextAlign = textAlignLeft;
            this.setHorizontalAlignment(2);
        }
        this.setText(this.getHTMLFormattedText(this.currentTitle, this.currentValue));
    }

    public int getComponentWidth() {
        return this.componentWidth;
    }

    private String getHTMLFormattedText(String title, String value) {
        return "<html><head><style>table, tr, td {border:1px solid #bbbbbb}</style></head><table cellspacing=\"0\" cellpadding=\"0\" style=\"width:" + this.divWidth + "px\"><tr><td style=\"background:#bbbbbb; text-align:" + this.titleTextAlign + "\">" + WindowUtils.truncateStringAndDisplayEllipsis(title, this.fontMetrics, this.maxStringWidthInPixels) + "</td></tr><tr><td style=\"background:#777777; color:white; padding:1px; white-space:nowrap; height:14px; text-align:" + this.valueTextAlign + "\">" + WindowUtils.truncateStringAndDisplayEllipsis(value, this.fontMetrics, this.maxStringWidthInPixels) + "</td></tr></table></html>";
    }
}

