/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing.component;

import info.msxlaunchers.openmsx.common.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class JListWithImagesAndActions
extends JList<Object> {
    public static final String DOUBLE_CLICK_COMMAND = "doubleClickCommand";
    public static final String ENTER_KEY_COMMAND = "enterKeyCommand";
    public static final String DELETE_KEY_COMMAND = "deleteKeyCommand";
    public static final String INSERT_KEY_COMMAND = "insertKeyCommand";
    private static final Color BACKGROUND_COLOR = new Color(250, 250, 250);
    private static final int KEYBOARD_PRESS_DELAY = 800;
    private StringBuilder pressedKeysBuffer = new StringBuilder();
    private long pressTimeValue;
    private final DefaultListModel<Object> listModel;
    ActionListener actionListener;

    public JListWithImagesAndActions(DefaultListModel<Object> listModel) {
        super(listModel);
        this.listModel = listModel;
        this.setCellRenderer(new JListCellRenderer());
        this.setBackground(BACKGROUND_COLOR);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (JListWithImagesAndActions.this.actionListener == null) {
                    return;
                }
                List ob = JListWithImagesAndActions.this.getSelectedValuesList();
                if (SwingUtilities.isLeftMouseButton(me)) {
                    if (ob.size() > 1) {
                        return;
                    }
                    if (me.getClickCount() == 2) {
                        if (!ob.isEmpty()) {
                            JListWithImagesAndActions.this.actionListener.actionPerformed(new ActionEvent(this, 1001, JListWithImagesAndActions.DOUBLE_CLICK_COMMAND));
                        }
                        me.consume();
                    }
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                if (JListWithImagesAndActions.this.actionListener == null || ke.isAltDown()) {
                    return;
                }
                List ob = JListWithImagesAndActions.this.getSelectedValuesList();
                if (ob.size() > 1 && ke.getKeyCode() != 127) {
                    return;
                }
                if (ke.getKeyCode() == 10) {
                    if (!ob.isEmpty()) {
                        JListWithImagesAndActions.this.actionListener.actionPerformed(new ActionEvent(this, 1001, JListWithImagesAndActions.ENTER_KEY_COMMAND));
                    }
                    ke.consume();
                } else if (ke.getKeyCode() == 127) {
                    if (!ob.isEmpty()) {
                        JListWithImagesAndActions.this.actionListener.actionPerformed(new ActionEvent(this, 1001, JListWithImagesAndActions.DELETE_KEY_COMMAND));
                    }
                    ke.consume();
                } else if (ke.getKeyCode() == 155) {
                    if (!ob.isEmpty()) {
                        JListWithImagesAndActions.this.actionListener.actionPerformed(new ActionEvent(this, 1001, JListWithImagesAndActions.INSERT_KEY_COMMAND));
                    }
                    ke.consume();
                } else if (JListWithImagesAndActions.isPrintableChar(ke.getKeyChar())) {
                    long currentTime = System.currentTimeMillis();
                    if (JListWithImagesAndActions.this.pressTimeValue + 800L < currentTime) {
                        JListWithImagesAndActions.this.pressedKeysBuffer = new StringBuilder();
                    }
                    JListWithImagesAndActions.this.pressTimeValue = currentTime;
                    JListWithImagesAndActions.this.pressedKeysBuffer.append(Character.toLowerCase(ke.getKeyChar()));
                    int size = JListWithImagesAndActions.this.getListSize();
                    for (int index = 0; index < size; ++index) {
                        String str = JListWithImagesAndActions.this.getElementAt(index).toLowerCase();
                        if (!str.startsWith(JListWithImagesAndActions.this.pressedKeysBuffer.toString())) continue;
                        JListWithImagesAndActions.this.setSelectedIndex(index);
                        JListWithImagesAndActions.this.ensureIndexIsVisible(index);
                        break;
                    }
                    ke.consume();
                }
            }
        });
    }

    public void addElement(String name, String company, String year, long size, ImageIcon icon) {
        this.listModel.addElement(new TextIcon(name, company, year, size, icon));
    }

    public void clear() {
        this.listModel.clear();
    }

    @Override
    public void remove(int index) {
        this.listModel.remove(index);
    }

    public void setSelectedValue(String name) {
        int index = this.listModel.indexOf(new TextIcon(name, null, null, 0L, null));
        this.setSelectedIndex(index);
        SwingUtilities.invokeLater(() -> this.ensureIndexIsVisible(index));
        this.requestFocusInWindow();
    }

    public String[] getSelectedItems() {
        List selectionValues = this.getSelectedValuesList();
        int size = selectionValues.size();
        String[] selectedItems = new String[size];
        for (int ix = 0; ix < size; ++ix) {
            selectedItems[ix] = ((TextIcon)selectionValues.get(ix)).name;
        }
        return selectedItems;
    }

    public String getElementAt(int index) {
        String element = index < 0 || index >= this.listModel.getSize() ? null : ((TextIcon)this.listModel.elementAt(index)).name;
        return element;
    }

    public int getListSize() {
        return this.listModel.getSize();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    private static boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    private class TextIcon {
        private final String name;
        private final String company;
        private final String year;
        private long size;
        private final ImageIcon icon;

        TextIcon(String name, String company, String year, long size, ImageIcon icon) {
            this.name = name;
            this.company = company;
            this.year = year;
            this.size = size;
            this.icon = icon;
        }

        public boolean equals(Object obj) {
            return ((TextIcon)obj).name.equals(this.name);
        }
    }

    private static class JListCellRenderer
    extends JPanel
    implements ListCellRenderer<Object> {
        private static final JLabel iconLabel = new JLabel();
        private static final JLabel nameLabel = new JLabel();
        private static final JLabel infoLabel = new JLabel();
        private static JPanel textPanel = new JPanel();
        private static final FlowLayout allLayout = new FlowLayout(0, 0, 2);
        private static final BorderLayout textLayout = new BorderLayout();
        private static final Color backgroundColor = new Color(190, 220, 230);
        private static final Color infoColor = new Color(100, 100, 100);
        private static final String LABEL_DASH = " - ";
        private static final String LABEL_KB = " KB";
        private static final String LABEL_SPACE = " ";
        private static final Border LABEL_MARGIN = new EmptyBorder(0, 3, 0, 0);

        private JListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.removeAll();
            this.setLayout(allLayout);
            TextIcon textIcon = (TextIcon)value;
            if (isSelected) {
                this.setBackground(backgroundColor);
                textPanel.setBackground(backgroundColor);
            } else {
                this.setBackground(BACKGROUND_COLOR);
                textPanel.setBackground(BACKGROUND_COLOR);
            }
            iconLabel.setIcon(textIcon.icon);
            this.add(iconLabel);
            nameLabel.setText(textIcon.name);
            infoLabel.setText(this.getFormattedString(textIcon));
            this.add((Component)textPanel, "Center");
            return this;
        }

        private String getFormattedString(TextIcon textIcon) {
            StringBuilder builder = new StringBuilder();
            if (Utils.isEmpty(textIcon.company) && Utils.isEmpty(textIcon.year)) {
                if ((double)textIcon.size > 0.0) {
                    builder.append(textIcon.size / 1024L).append(LABEL_KB);
                }
            } else {
                builder.append(textIcon.company).append(LABEL_SPACE).append(textIcon.year).append(LABEL_DASH).append(textIcon.size / 1024L).append(LABEL_KB);
            }
            return builder.toString();
        }

        static {
            nameLabel.setFont(new Font(null, 0, 14));
            nameLabel.setBorder(LABEL_MARGIN);
            infoLabel.setFont(new Font(null, 0, 9));
            infoLabel.setBorder(LABEL_MARGIN);
            infoLabel.setForeground(infoColor);
            textPanel.setLayout(textLayout);
            textPanel.add((Component)nameLabel, "North");
            textPanel.add((Component)infoLabel, "South");
        }
    }
}

