/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing.component;

import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageWindow;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.util.Map;

public class MessageBoxUtil {
    public static void showErrorMessageBox(Component parent, LauncherException le, Map<String, String> messages, boolean rightToLeft) {
        StringBuilder buffer = new StringBuilder(messages.get(le.getCodeAsString()));
        String additionalString = le.getAdditionalString();
        if (additionalString != null) {
            buffer.append(": ").append(additionalString);
        }
        MessageWindow messageWindow = new MessageWindow(parent, messages.get("ERROR"), buffer.toString(), 0, new String[]{messages.get("OK")}, rightToLeft);
        messageWindow.displayAndGetResult();
    }

    public static void showErrorMessageBox(Component parent, LauncherException le, Map<String, String> messages, ComponentOrientation orientation) {
        MessageBoxUtil.showErrorMessageBox(parent, le, messages, orientation == ComponentOrientation.RIGHT_TO_LEFT);
    }

    public static int showYesNoMessageBox(Component parent, String message, Map<String, String> messages, boolean rightToLeft) {
        MessageWindow messageWindow = new MessageWindow(parent, messages.get("CONFIRMATION"), message, 3, new String[]{messages.get("YES"), messages.get("NO")}, rightToLeft);
        return messageWindow.displayAndGetResult();
    }

    public static int showYesNoMessageBox(Component parent, String message, Map<String, String> messages, ComponentOrientation orientation) {
        return MessageBoxUtil.showYesNoMessageBox(parent, message, messages, orientation == ComponentOrientation.RIGHT_TO_LEFT);
    }

    public static int showYesNoAllMessageBox(Component parent, String message, Map<String, String> messages, boolean rightToLeft) {
        MessageWindow messageWindow = new MessageWindow(parent, messages.get("CONFIRMATION"), message, 3, new String[]{messages.get("YES"), messages.get("YES_ALL"), messages.get("NO"), messages.get("NO_ALL"), messages.get("CANCEL")}, rightToLeft);
        return messageWindow.displayAndGetResult();
    }

    public static int showInformationMessageBox(Component parent, String message, Map<String, String> messages, boolean rightToLeft) {
        MessageWindow messageWindow = new MessageWindow(parent, messages.get("RESULTS"), message, 1, new String[]{messages.get("OK")}, rightToLeft);
        return messageWindow.displayAndGetResult();
    }

    public static int showInformationMessageBox(Component parent, String message, Map<String, String> messages, ComponentOrientation orientation) {
        return MessageBoxUtil.showInformationMessageBox(parent, message, messages, orientation == ComponentOrientation.RIGHT_TO_LEFT);
    }
}

