/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing.component;

import info.msxlaunchers.openmsx.launcher.ui.view.swing.MainWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.UserInputMethodComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UserInputWindow<E>
extends JDialog
implements ActionListener {
    private final Component mainWindow;
    private final boolean rightToLeft;
    private final String windowTitle;
    private final String message;
    private final UserInputMethodComponent<E> userInputMethodComponent;
    private final JButton okButton;
    private final JButton cancelButton;
    private E userInput;

    public UserInputWindow(Component parent, Map<String, String> messages, boolean rightToLeft, String title, String message, UserInputMethodComponent<E> userInputMethodComponent) {
        this.mainWindow = parent;
        this.rightToLeft = rightToLeft;
        this.windowTitle = title;
        this.message = message;
        this.userInputMethodComponent = userInputMethodComponent;
        this.okButton = new JButton(messages.get("OK"));
        this.cancelButton = new JButton(messages.get("CANCEL"));
    }

    public E displayAndGetUserInput() {
        this.setDefaultCloseOperation(2);
        this.setTitle(this.windowTitle);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        this.setBounds(0, 0, 300, 150);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel messagePane = new JPanel();
        this.getContentPane().add((Component)messagePane, "North");
        if (this.rightToLeft) {
            messagePane.setLayout(new FlowLayout(2, 8, 10));
        } else {
            messagePane.setLayout(new FlowLayout(0, 8, 10));
        }
        JLabel messageLabel = new JLabel(this.message);
        messagePane.add(messageLabel);
        JPanel userInputPane = new JPanel();
        this.getContentPane().add((Component)userInputPane, "Center");
        userInputPane.setLayout(new FlowLayout(1, 5, 10));
        Component component = this.userInputMethodComponent.getMethodComponent();
        component.setPreferredSize(new Dimension(178, 28));
        userInputPane.add(component);
        JPanel buttonPane = new JPanel();
        this.getContentPane().add((Component)buttonPane, "South");
        buttonPane.setLayout(new FlowLayout(1, 5, 5));
        this.okButton.addActionListener(this);
        this.okButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        buttonPane.add(this.okButton);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        buttonPane.add(this.cancelButton);
        if (this.rightToLeft) {
            buttonPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        this.setLocationRelativeTo(this.mainWindow);
        this.setVisible(true);
        return this.userInput;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.userInput = this.userInputMethodComponent.getInput();
            this.dispose();
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }
}

