/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.updater;

import info.msxlaunchers.openmsx.launcher.updater.FileUpdateFailedException;
import info.msxlaunchers.openmsx.launcher.updater.LauncherUpdater;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

abstract class AbstractLauncherUpdater
implements LauncherUpdater {
    private final int WRITE_BUFFER = 2048;
    private final String JAR_EXT = ".jar";
    protected final String UPDATE_EXT = "_update";
    protected final String STARTER_UPDATE_EXT = "_starter_update";
    private final String UPDATE_JAR_ENDING = ".jar_update";
    protected final String OLD_EXE_EXT = ".old";
    private final String HELP_FILENAME = "README.html";

    AbstractLauncherUpdater() {
    }

    @Override
    public final void installNewOpenMSXLauncher(String jarFilesDirectory, String executableDirectory, String helpFileDirectory, File zipFile) throws FileUpdateFailedException, IOException {
        this.startInstallation(jarFilesDirectory, executableDirectory, helpFileDirectory, zipFile);
        this.deleteNewLauncherStarters(jarFilesDirectory);
    }

    protected abstract void startInstallation(String var1, String var2, String var3, File var4) throws FileUpdateFailedException, IOException;

    protected final void unzipUpdateFile(String jarFilesDirectory, File zipFile) throws FileUpdateFailedException, IOException {
        byte[] buffer = new byte[2048];
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                File newFile = new File(jarFilesDirectory, fileName);
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
                catch (IOException ioe) {
                    throw new FileUpdateFailedException();
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
        }
        if (!zipFile.delete()) {
            throw new FileUpdateFailedException();
        }
    }

    protected final void installNewJarFiles(String jarFilesDirectory) throws FileUpdateFailedException {
        File[] files = new File(jarFilesDirectory).listFiles();
        if (files != null) {
            ArrayList<File> oldJarFiles = new ArrayList<File>(files.length);
            ArrayList<File> newUpdateJarFiles = new ArrayList<File>(files.length);
            for (File file : files) {
                String filename = file.getName();
                if (filename.endsWith(".jar_update")) {
                    newUpdateJarFiles.add(file);
                    continue;
                }
                if (!filename.endsWith(".jar")) continue;
                oldJarFiles.add(file);
            }
            if (newUpdateJarFiles.size() > 0) {
                for (File file : oldJarFiles) {
                    if (file.delete()) continue;
                    throw new FileUpdateFailedException();
                }
                int jarFileValidLength = ".jar_update".length() - ".jar".length();
                for (File file : newUpdateJarFiles) {
                    if (file.renameTo(new File(jarFilesDirectory, file.getName().substring(0, file.getName().length() - jarFileValidLength)))) continue;
                    throw new FileUpdateFailedException();
                }
            }
        }
    }

    protected final void installNewHelpFile(String jarFilesDirectory, String helpFileDirectory) throws FileUpdateFailedException {
        File[] files = new File(jarFilesDirectory).listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().equals("README.html")) continue;
                File destination = new File(helpFileDirectory, file.getName());
                if (!destination.delete()) {
                    throw new FileUpdateFailedException();
                }
                if (!file.renameTo(destination)) {
                    throw new FileUpdateFailedException();
                }
                return;
            }
        }
    }

    private void deleteNewLauncherStarters(String jarFilesDirectory) throws FileUpdateFailedException {
        File[] files = new File(jarFilesDirectory).listFiles();
        if (files != null) {
            for (File file : files) {
                File destination;
                if (!file.getName().endsWith("_starter_update") || (destination = new File(jarFilesDirectory, file.getName())).delete()) continue;
                throw new FileUpdateFailedException();
            }
        }
    }
}

