/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.updater;

import info.msxlaunchers.openmsx.launcher.updater.AbstractLauncherUpdater;
import info.msxlaunchers.openmsx.launcher.updater.FileUpdateFailedException;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

final class WindowsLauncherUpdater
extends AbstractLauncherUpdater {
    private final String EXE_FILENAME = "openMSX Launcher.exe";
    private final String EXE_FILENAME_UPDATE = "openMSX Launcher.exe_starter_update";

    WindowsLauncherUpdater() {
    }

    @Override
    public void startInstallation(String jarFilesDirectory, String executableDirectory, String helpFileDirectory, File zipFile) throws FileUpdateFailedException, IOException {
        this.unzipUpdateFile(jarFilesDirectory, zipFile);
        this.installNewExecutable(jarFilesDirectory, executableDirectory);
        this.installNewHelpFile(jarFilesDirectory, helpFileDirectory);
    }

    private void installNewExecutable(String jarFilesDirectory, String executableDirectory) throws FileUpdateFailedException {
        File[] files = new File(jarFilesDirectory).listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().equals("openMSX Launcher.exe_starter_update")) continue;
                Path currentExecutable = Paths.get(executableDirectory, "openMSX Launcher.exe");
                Path backupExecutable = currentExecutable.resolveSibling(currentExecutable.getFileName() + ".old");
                Path newExecutable = Paths.get(jarFilesDirectory, "openMSX Launcher.exe_starter_update");
                try {
                    Files.move(currentExecutable, backupExecutable, new CopyOption[0]);
                    Files.move(newExecutable, currentExecutable, new CopyOption[0]);
                }
                catch (IOException ioe) {
                    throw new FileUpdateFailedException();
                }
                return;
            }
        }
    }
}

