/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.io;

import java.io.IOException;
import java.io.OutputStream;
import jp.gr.java_conf.dangan.io.Disconnectable;

public class DisconnectableOutputStream
extends OutputStream
implements Disconnectable {
    private OutputStream out;

    private DisconnectableOutputStream() {
    }

    public DisconnectableOutputStream(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("out");
        }
        this.out = out;
    }

    @Override
    public void write(int data) throws IOException {
        this.out.write(data);
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.out.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int index, int length) throws IOException {
        this.out.write(buffer, index, length);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() {
        this.disconnect();
    }

    @Override
    public void disconnect() {
        this.out = null;
    }
}

