/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.IOException;
import java.io.OutputStream;
import jp.gr.java_conf.dangan.io.BitOutputStream;
import jp.gr.java_conf.dangan.util.lha.BadHuffmanTableException;
import jp.gr.java_conf.dangan.util.lha.DynamicHuffman;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;

public class PostLh1Encoder
implements PostLzssEncoder {
    private static final int DictionarySize = 4096;
    private static final int MaxMatch = 60;
    private static final int Threshold = 3;
    private BitOutputStream out;
    private DynamicHuffman huffman;
    private int[] offHiCode;
    private int[] offHiLen;

    private PostLh1Encoder() {
    }

    public PostLh1Encoder(OutputStream out) {
        if (out != null) {
            this.out = out instanceof BitOutputStream ? (BitOutputStream)out : new BitOutputStream(out);
            this.huffman = new DynamicHuffman(314);
            this.offHiLen = PostLh1Encoder.createLenList();
            try {
                this.offHiCode = StaticHuffman.LenListToCodeList(this.offHiLen);
            }
            catch (BadHuffmanTableException badHuffmanTableException) {}
        } else {
            throw new NullPointerException("out");
        }
    }

    @Override
    public void writeCode(int code) throws IOException {
        int node = this.huffman.codeToNode(code);
        int hcode = 0;
        int hlen = 0;
        do {
            hcode >>>= 1;
            ++hlen;
            if ((node & 1) == 0) continue;
            hcode |= Integer.MIN_VALUE;
        } while ((node = this.huffman.parentNode(node)) != 0);
        this.out.writeBits(hlen, hcode >> 32 - hlen);
        this.huffman.update(code);
    }

    @Override
    public void writeOffset(int offset) throws IOException {
        int offHi = offset >> 6;
        this.out.writeBits(this.offHiLen[offHi], this.offHiCode[offHi]);
        this.out.writeBits(6, offset);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        this.out = null;
        this.huffman = null;
        this.offHiLen = null;
        this.offHiCode = null;
    }

    @Override
    public int getDictionarySize() {
        return 4096;
    }

    @Override
    public int getMaxMatch() {
        return 60;
    }

    @Override
    public int getThreshold() {
        return 3;
    }

    private static int[] createLenList() {
        int length = 64;
        int[] nArray = new int[7];
        nArray[0] = 3;
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 12;
        nArray[4] = 24;
        nArray[5] = 48;
        int[] list = nArray;
        int[] LenList = new int[64];
        int index = 0;
        int len = list[index++];
        int i = 0;
        while (i < 64) {
            if (list[index] == i) {
                ++index;
            }
            LenList[i] = ++len;
            ++i;
        }
        return LenList;
    }
}

