/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import jp.gr.java_conf.dangan.util.lha.PreLz5Decoder;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;

public class LzssInputStream
extends InputStream {
    private PreLzssDecoder decoder;
    private int Threshold;
    private int MaxMatch;
    private long Length;
    private byte[] TextBuffer;
    private long TextPosition;
    private long TextDecoded;
    private byte[] MarkTextBuffer;
    private long MarkTextPosition;
    private long MarkTextDecoded;

    private LzssInputStream() {
    }

    public LzssInputStream(PreLzssDecoder decoder) {
        this(decoder, Long.MAX_VALUE);
    }

    public LzssInputStream(PreLzssDecoder decoder, long length) {
        this.MaxMatch = decoder.getMaxMatch();
        this.Threshold = decoder.getThreshold();
        this.Length = length;
        this.decoder = decoder;
        this.TextBuffer = new byte[decoder.getDictionarySize()];
        this.TextPosition = 0L;
        this.TextDecoded = 0L;
        if (this.decoder instanceof PreLz5Decoder) {
            this.initLz5TextBuffer();
        }
    }

    @Override
    public int read() throws IOException {
        block3: {
            if (this.TextDecoded <= this.TextPosition) {
                try {
                    this.decode();
                }
                catch (EOFException exception) {
                    if (this.TextDecoded > this.TextPosition) break block3;
                    return -1;
                }
            }
        }
        return this.TextBuffer[(int)this.TextPosition++ & this.TextBuffer.length - 1] & 0xFF;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int index, int length) throws IOException {
        int position;
        block4: {
            position = index;
            int end = index + length;
            try {
                while (position < end) {
                    if (this.TextDecoded <= this.TextPosition) {
                        this.decode();
                    }
                    position = this.copyTextBufferToBuffer(buffer, position, end);
                }
            }
            catch (EOFException exception) {
                position = this.copyTextBufferToBuffer(buffer, position, end);
                if (position != index) break block4;
                return -1;
            }
        }
        return position - index;
    }

    @Override
    public long skip(long length) throws IOException {
        long end = this.TextPosition + length;
        try {
            while (this.TextPosition < end) {
                if (this.TextDecoded <= this.TextPosition) {
                    this.decode();
                }
                this.TextPosition = Math.min(end, this.TextDecoded);
            }
        }
        catch (EOFException exception) {
            this.TextPosition = Math.min(end, this.TextDecoded);
        }
        return length - (end - this.TextPosition);
    }

    @Override
    public void mark(int readLimit) {
        readLimit -= (int)(this.TextDecoded - this.TextPosition);
        int Size = this.TextBuffer.length - this.MaxMatch;
        readLimit = (readLimit + Size - 1) / Size * Size;
        this.decoder.mark(Math.max(readLimit, 0));
        if (this.MarkTextBuffer == null) {
            this.MarkTextBuffer = (byte[])this.TextBuffer.clone();
        } else {
            System.arraycopy(this.TextBuffer, 0, this.MarkTextBuffer, 0, this.TextBuffer.length);
        }
        this.MarkTextPosition = this.TextPosition;
        this.MarkTextDecoded = this.TextDecoded;
    }

    @Override
    public void reset() throws IOException {
        if (this.MarkTextBuffer == null) {
            throw new IOException("not marked.");
        }
        if (this.TextDecoded - this.MarkTextPosition <= (long)this.TextBuffer.length) {
            this.TextPosition = this.MarkTextPosition;
        } else if (this.decoder.markSupported()) {
            this.decoder.reset();
            System.arraycopy(this.MarkTextBuffer, 0, this.TextBuffer, 0, this.TextBuffer.length);
            this.TextPosition = this.MarkTextPosition;
            this.TextDecoded = this.MarkTextDecoded;
        } else {
            throw new IOException("mark/reset not supported.");
        }
    }

    @Override
    public boolean markSupported() {
        return this.decoder.markSupported();
    }

    @Override
    public int available() throws IOException {
        return (int)(this.TextDecoded - this.TextPosition) + this.decoder.available();
    }

    @Override
    public void close() throws IOException {
        this.decoder.close();
        this.decoder = null;
        this.TextBuffer = null;
        this.MarkTextBuffer = null;
    }

    private void decode() throws IOException {
        if (this.TextDecoded < this.Length) {
            int TextStart;
            int TextMask = this.TextBuffer.length - 1;
            int TextPos = TextStart = (int)this.TextDecoded & TextMask;
            int TextLimit = (int)(Math.min(this.TextPosition + (long)this.TextBuffer.length - (long)this.MaxMatch, this.Length) - this.TextDecoded) + TextStart;
            try {
                while (TextPos < TextLimit) {
                    int Code = this.decoder.readCode();
                    if (Code < 256) {
                        this.TextBuffer[TextMask & TextPos++] = (byte)Code;
                        continue;
                    }
                    int MatchLength = (Code & 0xFF) + this.Threshold;
                    int MatchPosition = TextPos - this.decoder.readOffset() - 1;
                    while (MatchLength-- > 0) {
                        this.TextBuffer[TextMask & TextPos++] = this.TextBuffer[TextMask & MatchPosition++];
                    }
                }
            }
            finally {
                this.TextDecoded += (long)(TextPos - TextStart);
            }
        } else {
            throw new EOFException();
        }
    }

    private int copyTextBufferToBuffer(byte[] buffer, int position, int end) {
        int length;
        if ((this.TextPosition & (long)(~(this.TextBuffer.length - 1))) < (this.TextDecoded & (long)(~(this.TextBuffer.length - 1)))) {
            length = Math.min(this.TextBuffer.length - ((int)this.TextPosition & this.TextBuffer.length - 1), end - position);
            System.arraycopy(this.TextBuffer, (int)this.TextPosition & this.TextBuffer.length - 1, buffer, position, length);
            this.TextPosition += (long)length;
            position += length;
        }
        if (this.TextPosition < this.TextDecoded) {
            length = Math.min((int)(this.TextDecoded - this.TextPosition), end - position);
            System.arraycopy(this.TextBuffer, (int)this.TextPosition & this.TextBuffer.length - 1, buffer, position, length);
            this.TextPosition += (long)length;
            position += length;
        }
        return position;
    }

    private void initLz5TextBuffer() {
        int position = 18;
        int i = 0;
        while (i < 256) {
            int j = 0;
            while (j < 13) {
                this.TextBuffer[position++] = (byte)i;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 256) {
            this.TextBuffer[position++] = (byte)i;
            ++i;
        }
        i = 0;
        while (i < 256) {
            this.TextBuffer[position++] = (byte)(255 - i);
            ++i;
        }
        i = 0;
        while (i < 128) {
            this.TextBuffer[position++] = 0;
            ++i;
        }
        while (position < this.TextBuffer.length) {
            this.TextBuffer[position++] = 32;
        }
    }
}

