/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class FileUtils {
    public static String getFileNameWithoutExtension(String filename) {
        String filenameWithoutExt = null;
        if (filename != null) {
            String filePortion = new File(filename).getName();
            int pos = filePortion.lastIndexOf(".");
            filenameWithoutExt = pos == -1 ? filePortion : filePortion.substring(0, pos);
        }
        return filenameWithoutExt;
    }

    public static String getFileNameWithoutExtension(File file) {
        String filename = null;
        if (file != null) {
            return FileUtils.getFileNameWithoutExtension(file.getName());
        }
        return filename;
    }

    public static List<String> getFileGroup(Path file) throws IOException {
        if (!file.toFile().exists()) {
            return Collections.emptyList();
        }
        Path folder = file.getParent();
        List<String> files = Files.list(folder).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::getFileName).map(Object::toString).sorted().collect(Collectors.toList());
        String filename = file.getFileName().toString();
        int diskNumberFormat = filename.indexOf("(Disk ");
        if (diskNumberFormat > -1 && Character.isDigit(filename.charAt(diskNumberFormat + 6)) && filename.substring(diskNumberFormat + 8, diskNumberFormat + 11).equals("of ") && Character.isDigit(filename.charAt(diskNumberFormat + 11)) && filename.charAt(diskNumberFormat + 12) == ')') {
            return FileUtils.getFileGroupForDiskXofYFormat(files, filename);
        }
        return FileUtils.getFileGroupForSimpleSequentialFormat(files, filename);
    }

    private static List<String> getFileGroupForDiskXofYFormat(List<String> files, String filename) {
        String escapedFilename = filename.replaceAll("[\\W]", "\\\\$0");
        int diskNumberFormat = escapedFilename.indexOf("(Disk\\ ");
        StringBuilder builder = new StringBuilder(escapedFilename);
        builder.setCharAt(diskNumberFormat + 7, '.');
        escapedFilename = builder.toString();
        Pattern pattern = Pattern.compile(escapedFilename);
        List potentialMatches = files.stream().filter(f -> pattern.matcher((CharSequence)f).matches()).sorted().collect(Collectors.toList());
        int indexOfCharacterToMatch = filename.indexOf("(Disk ") + 6;
        List charachtersToMatch = potentialMatches.stream().map(s -> Character.valueOf(s.charAt(indexOfCharacterToMatch))).collect(Collectors.toList());
        int index = potentialMatches.indexOf(filename);
        char characterToMatch = ((Character)charachtersToMatch.get(index)).charValue();
        boolean done = false;
        while (index > 0 && !done) {
            if (characterToMatch == ((Character)charachtersToMatch.get(index - 1)).charValue() + '\u0001') {
                characterToMatch = (char)(characterToMatch - '\u0001');
                --index;
                continue;
            }
            done = true;
        }
        ArrayList<String> matches = new ArrayList<String>(potentialMatches.size());
        characterToMatch = ((Character)charachtersToMatch.get(index)).charValue();
        done = false;
        while (index < charachtersToMatch.size() && !done) {
            if (characterToMatch == ((Character)charachtersToMatch.get(index)).charValue()) {
                matches.add((String)potentialMatches.get(index++));
                characterToMatch = (char)(characterToMatch + '\u0001');
                continue;
            }
            done = true;
        }
        return matches;
    }

    private static List<String> getFileGroupForSimpleSequentialFormat(List<String> files, String filename) {
        String escapedFilename = filename.replaceAll("[\\W]", "\\\\$0");
        int firstAlphanumericIndex = escapedFilename.lastIndexOf(46);
        while (!Character.isLetterOrDigit(escapedFilename.charAt(firstAlphanumericIndex))) {
            --firstAlphanumericIndex;
        }
        StringBuilder builder = new StringBuilder(escapedFilename);
        builder.setCharAt(firstAlphanumericIndex, '.');
        escapedFilename = builder.toString();
        Pattern pattern = Pattern.compile(escapedFilename);
        List<String> potentialMatches = files.stream().filter(f -> pattern.matcher((CharSequence)f).matches()).sorted().collect(Collectors.toList());
        if (potentialMatches.size() <= 1) {
            return potentialMatches;
        }
        int indexOfCharacterToMatch = filename.lastIndexOf(46) - 1;
        List charachtersToMatch = potentialMatches.stream().map(s -> Character.valueOf(s.charAt(indexOfCharacterToMatch))).collect(Collectors.toList());
        int index = potentialMatches.indexOf(filename);
        char characterToMatch = ((Character)charachtersToMatch.get(index)).charValue();
        boolean done = false;
        while (index > 0 && !done) {
            if (characterToMatch == ((Character)charachtersToMatch.get(index - 1)).charValue() + '\u0001') {
                characterToMatch = (char)(characterToMatch - '\u0001');
                --index;
                continue;
            }
            done = true;
        }
        ArrayList<String> matches = new ArrayList<String>(potentialMatches.size());
        characterToMatch = ((Character)charachtersToMatch.get(index)).charValue();
        done = false;
        while (index < charachtersToMatch.size() && !done) {
            if (characterToMatch == ((Character)charachtersToMatch.get(index)).charValue()) {
                matches.add(potentialMatches.get(index++));
                characterToMatch = (char)(characterToMatch + '\u0001');
                continue;
            }
            done = true;
        }
        return matches;
    }
}

