/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.zip.CRC32;

public final class HashUtils {
    public static final int READ_WRITE_BUFFER_SIZE = 0x200000;
    private static final String SHA1 = "SHA1";
    private static final String MD5 = "MD5";

    public static String getSHA1Code(InputStream inputStream) {
        Objects.requireNonNull(inputStream);
        return HashUtils.getHash(inputStream, SHA1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSHA1Code(File file) {
        Objects.requireNonNull(file);
        try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file), 0x200000);){
            String string = HashUtils.getSHA1Code(fis);
            return string;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getMD5Sum(File file) {
        Objects.requireNonNull(file);
        try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file), 0x200000);){
            String string = HashUtils.getHash(fis, MD5);
            return string;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCRC32Code(File file) {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file), 0x200000);){
            int count;
            CRC32 crc = new CRC32();
            while ((count = ((InputStream)inputStream).read()) != -1) {
                crc.update(count);
            }
            String string = Long.toHexString(crc.getValue());
            return string;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private static String getHash(InputStream inputStream, String algorithm) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] dataBytes = new byte[65536];
        int nread = 0;
        try {
            while ((nread = inputStream.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
        }
        catch (IOException e) {
            return null;
        }
        byte[] mdbytes = md.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mdbytes.length; ++i) {
            sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }
}

