/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.data.extra;

public class ExtraData {
    private final int msxGenerationID;
    private final int generations;
    private final int soundChips;
    private final int genre1;
    private final int genre2;
    private final String suffix;
    private static final int MASK_BIT_1 = 1;
    private static final int MASK_BIT_2 = 2;
    private static final int MASK_BIT_3 = 4;
    private static final int MASK_BIT_4 = 8;
    private static final int MASK_BIT_5 = 16;
    private static final int MASK_BIT_6 = 32;
    private static final int MASK_BIT_7 = 64;
    private static final int MASK_BIT_8 = 128;

    public ExtraData(int msxGenerationID, int generations, int soundChips, int genre1, int genre2, String suffix) {
        this.msxGenerationID = msxGenerationID;
        this.generations = generations;
        this.soundChips = soundChips;
        this.genre1 = genre1;
        this.genre2 = genre2;
        this.suffix = suffix;
    }

    public int getMSXGenerationsID() {
        return this.msxGenerationID;
    }

    public boolean isMSX() {
        return (this.generations & 1) == 1;
    }

    public boolean isMSX2() {
        return (this.generations & 2) == 2;
    }

    public boolean isMSX2Plus() {
        return (this.generations & 4) == 4;
    }

    public boolean isTurboR() {
        return (this.generations & 8) == 8;
    }

    public boolean isPSG() {
        return (this.soundChips & 1) == 1;
    }

    public boolean isSCC() {
        return (this.soundChips & 2) == 2;
    }

    public boolean isSCCI() {
        return (this.soundChips & 4) == 4;
    }

    public boolean isPCM() {
        return (this.soundChips & 8) == 8;
    }

    public boolean isMSXMUSIC() {
        return (this.soundChips & 0x10) == 16;
    }

    public boolean isMSXAUDIO() {
        return (this.soundChips & 0x20) == 32;
    }

    public boolean isMoonsound() {
        return (this.soundChips & 0x40) == 64;
    }

    public boolean isMIDI() {
        return (this.soundChips & 0x80) == 128;
    }

    public int getGenre1() {
        return this.genre1;
    }

    public int getGenre2() {
        return this.genre2;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

